#ifndef __LIGHTMODEL_HEADER__
#define __LIGHTMODEL_HEADER__

#include "graphics.h"
#include "vector.h"
#include "light.h"

#include <vector>


/**
 *	Simple ambient + diffuse light phong based shading model
 */
class LightModel {

	union color d_ambient;
	Light **d_lights;
	size_t d_nLights;

	public:
		
		LightModel(float const *lights, size_t nLights);
		~LightModel();

		void setAmbientLight(union color ambient);		

		Light &light(int idx);		
		union color colorAt(Gfx &gfx, vector3 const &position, vector3 const &normal);
};



/** 
 *	Free the memory allocated for the lights
 */
inline LightModel::~LightModel() {

	for (size_t idx = 0; idx < d_nLights; ++idx) {
		delete d_lights[idx];
	}
	
	delete[] d_lights;
}

inline void LightModel::setAmbientLight(union color ambient) {
	d_ambient = ambient;
}

inline Light &LightModel::light(int idx) {
	return *d_lights[idx];
}

#endif

