#include "light.h"
#include "lookup.h"
#include <cmath>

/**
 *	Initialize a light source 
 */
Light::Light(float *info) 
:
	d_intensity(info[6])
{
	// initialize light
	d_rgb.r = static_cast<int>(255.0f * info[3]);
	d_rgb.g = static_cast<int>(255.0f * info[4]);
	d_rgb.b = static_cast<int>(255.0f * info[5]);
	
	// setup positions
	d_pos.x = info[0];
	d_pos.y = info[1];
	d_pos.z = info[2];
	
}


/**
 *	Initialize data-members
 */
Light::Light(float x, float y, float z, float intensity, union color rgba) 
:
	d_intensity(intensity)
{
	d_rgb.rgba = rgba.rgba;
	d_pos.x = x;
	d_pos.y = y;
	d_pos.z = z;
}

float Light::intensityAt(vector3 const &position) const {

	// distance
	float xDistance = position.x - d_pos.x;
	float yDistance = position.y - d_pos.y;
	float zDistance = position.z - d_pos.z;
	
	float distance = 
			sqrt(
				xDistance * xDistance + 
				yDistance * yDistance + 
				zDistance * zDistance
			);

	if (distance < d_intensity)  {
		return 1.0f - (distance / d_intensity);
	}
	
	return 0.0f;

}


