#ifndef __GRAPHICS_HEADER_
#define __GRAPHICS_HEADER_

#include <cstddef>
#include <SDL/SDL.h>

/**
 * Color definition
 */
union color {
	Uint32 rgba;
	struct {
		Uint8 r;
		Uint8 g;
		Uint8 b;
		Uint8 a;
	};
	Uint8 c[4];
};

/**
 *	Simple SDL Wrapper class that is able to put a pixel to the screen
 */
class Gfx {

	size_t d_width;
	size_t d_height;

	SDL_Surface *d_primary;

	public:
		Gfx(size_t width, size_t height);
		~Gfx();

		union color color(Uint8 r, Uint8 g, Uint8 b);
		void convert(SDL_PixelFormat *fmt, Uint32 val, Uint8 &r, Uint8 &g, Uint8 &b);
		void putpixel(size_t x, size_t y, union color c);
		void flip();
		void clear() const;
		
		size_t width() const;
		size_t height() const;

		SDL_Surface *picture(char const *filename);
		SDL_Surface *surface();
};

inline void Gfx::flip() {
	SDL_Flip(d_primary);
}

inline union color Gfx::color(Uint8 r, Uint8 g, Uint8 b) {
	union color c;
	c.rgba = SDL_MapRGB(d_primary->format, r, g, b);
	return c;
}

inline void Gfx::clear() const {
	SDL_FillRect(d_primary, 0, 0);
}

inline SDL_Surface *Gfx::surface() {
	return d_primary;
}

inline size_t Gfx::width() const {
	return d_width;
}

inline size_t Gfx::height() const {
	return d_height;
}

#endif

