#include "graphics.h"

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <cstdlib>
#include <iostream>

using namespace std;


/**
 *	Constructor that shall initialize the SDL video library
 */
Gfx::Gfx(size_t width, size_t height)
:
	d_width(width),
	d_height(height)
{
	int result;

	// setup video subsystem
	result = SDL_Init(SDL_INIT_VIDEO);

	if (result == -1) {
		cerr << "Unable to initialize video system. Aborting!" << endl;
		exit(-1);
	}

	// get the primary surface
	d_primary = SDL_SetVideoMode(d_width, d_height, 32, SDL_HWSURFACE | SDL_DOUBLEBUF);

	if (d_primary == 0) {
		cerr << "Unable to setup video mode. Aborting!" << endl;
		exit(-1);
	}


}

SDL_Surface *Gfx::picture(char const *filename) {
	return IMG_Load(filename);
}

/** 
 *	Convert a pixel value to separate rgb components 
 */
void Gfx::convert(SDL_PixelFormat *fmt, Uint32 val, Uint8 &r, Uint8 &g, Uint8 &b) {
	Uint32 r32 = ((val & fmt->Rmask) >> fmt->Rshift) << fmt->Rloss;
	Uint32 g32 = ((val & fmt->Gmask) >> fmt->Gshift) << fmt->Gloss;
	Uint32 b32 = ((val & fmt->Bmask) >> fmt->Bshift) << fmt->Bloss;
	r = static_cast<Uint8>(r32);
	g = static_cast<Uint8>(g32);
	b = static_cast<Uint8>(b32);
}



/**
 *	Quit the graphics system
 */
Gfx::~Gfx() {
	SDL_Quit();
}

void Gfx::putpixel(size_t x, size_t y, union color c) {

	SDL_LockSurface(d_primary);

	Uint32 *pxl = (Uint32 *) d_primary->pixels;
	*(pxl + (y * (d_primary->pitch >> 2)) + x) = c.rgba;

	SDL_UnlockSurface(d_primary);

}
