/*
  Sortieralgorithmen-Demoprogramm - PD (w) Adok

  Falls ihr Borland C++ benutzt (Makro __BORLANDC__ wird in diesem Fall
  automatisch definiert), wird der Zufallszahlengenerator ber den Timer
  initialisiert. Auf diese Weise entstehen bei (jaja, fast) jedem Aufruf
  andere Zufallszahlen.

  Der Defaultwert fr die Anzahl der zu sortierenden Zahlen betrgt, damit es
  auf dem Bildschirm bersichtlich bleibt, 100. Wer die Geschwindigkeit der
  einzelnen Algorithmen miteinander vergleichen will, mu diesen Wert jedoch,
  abhngig von der Geschwindigkeit des Computers, um einiges raufsetzen. Auf
  meinem 486 DX2/66 werden die Geschwindigkeitsunterschiede erst ab einem Wert
  von 1000 deutlich.
*/

//--------------------------------------------------------------------------\\

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

void bubblesort(int *zahlen,int anz_zahlen)
{
  int         counter,    //Schleifenzhler
              swap;       //temporre Variable (zum Tauschen der Werte)
  signed char changed;    //Flag, ob getauscht wurde

  do
  {
    changed=0;
    for(counter=0;counter<anz_zahlen;counter++)
      //wenn Zahl grer als der nchsthhere Nachbar -> tauschen
      if(zahlen[counter]>zahlen[counter+1])
      {
        swap=zahlen[counter];
        zahlen[counter]=zahlen[counter+1];
        zahlen[counter+1]=swap;
        changed=-1;
      }
  } while(changed!=0);    //wiederhole solange, bis in einem Durchlauf nicht
                          //getauscht wurde
}

void quicksort(int *zahlen,int min,int max)
{
  int min_counter=min,           //Schleifenzhler von "unten"
      max_counter=max,           //Schleifenzhler von "oben"
      mitte=zahlen[(max+min)/2], //zentraler Wert in Array
      swap;                      //temporre Variable (zum Tauschen der Werte)

  do
  {
    //zwei Zahlen suchen, die - vom mittleren Element her betrachtet - nicht
    //in die Reihenfolge passen
    while(zahlen[min_counter]<mitte) min_counter++;
    while(zahlen[max_counter]>mitte) max_counter--;
    //falls der "untere" den "oberen" Counter noch nicht berstiegen hat,
    //gefundene Werte vertauschen
    if(min_counter<=max_counter)
    {
      swap=zahlen[min_counter];
      zahlen[min_counter]=zahlen[max_counter];
      zahlen[max_counter]=swap;
      min_counter++;
      max_counter--;
    }
  } while(min_counter<=max_counter);

  //Rekursion: noch nicht sortierte Zahlenbereiche sortieren
  if(min<max_counter) quicksort(zahlen,min,max_counter);
  if(max>min_counter) quicksort(zahlen,min_counter,max);
}

void insertsort(int *zahlen,int anz_zahlen)
{
  int counter1, //Schleifenzhler, markiert das letzte Element der Zielsequenz
      counter2, //Schleifenzhler, durchforstet die Elemente der Zielsequenz
      counter3, //Schleifenzhler, dient zum Verschieben der Elemente
      temp;     //temporre Variable, in der das 1. Element der Quellsequenz
                //abgelegt wird

  for(counter1=0;counter1<anz_zahlen;counter1++)
  {
    temp=zahlen[counter1+1];
    for(counter2=0;counter2<=counter1;counter2++)
    {
      //wenn 1. Element der Quellsequenz kleiner als aktuelles Element der
      //Zielsequenz -> Platz schaffen und einfgen
      if(zahlen[counter2]>temp)
      {
        for(counter3=counter1;counter3>=counter2;counter3--)
          zahlen[counter3+1]=zahlen[counter3];
        zahlen[counter2]=temp;
        break; //wichtig!! unterbricht counter2-for-Schleife
      }
    }
  }
}

void selectsort(int *zahlen,int anz_zahlen)
{
  int counter1, //Schleifenzhler, markiert den Anfang des Durchsuchbereichs
      counter2, //Schleifenzhler fr zwei Aufgaben:
                //a) Finden des kleinsten Elements
                //b) Verschieben der Elemente
      temp,     //Wert des kleinsten bisher gefundenen Elements
      temp_idx; //Index des kleinsten bisher gefundenen Elements

  for(counter1=0;counter1<anz_zahlen;counter1++)
  {
    //kleinstes Element finden
    temp_idx=counter1;
    temp=zahlen[temp_idx];
    for(counter2=counter1+1;counter2<=anz_zahlen;counter2++)
      if(zahlen[counter2]<temp)
      {
        temp=zahlen[counter2];
        temp_idx=counter2;
      }
    //dieses am Array-Anfang einfgen und den Rest nach hinten verschieben
    for(counter2=temp_idx-1;counter2>=counter1;counter2--)
      zahlen[counter2+1]=zahlen[counter2];
    zahlen[counter1]=temp;
  }
}

void main()
{
  int     *zahlen,            /*Pointer auf den Array, in dem die Zahlen
                                gespeichert werden*/
          anz_zahlen,         //Anzahl der zu sortierenden Zahlen
          counter,            //Schleifenzhler
          verfahren;          //zu benutzendes Sortierverfahren
  clock_t start,
          ende;

  printf("Anzahl der zu sortierenden Zahlen (Default=100, max. 32767)? ");
  scanf("%d",&anz_zahlen);
  if(anz_zahlen<1) anz_zahlen=100;

  if(NULL==(zahlen=(int*)malloc(anz_zahlen)))
  {
    printf("Speicherreservierung fehlgeschlagen - probiere es mit einer "
           "geringeren Anzahl\nvon Zahlen noch einmal!\n");
    exit(1);
  }

  printf("Welches Sortierverfahren soll angewandt werden?\n"
         "1 BubbleSort\n"
         "2 SelectSort\n"
         "3 InsertSort\n"
         "4 QuickSort (rekursiv)\n"
         "? ");
  do scanf("%d",&verfahren); while((verfahren<1)||(verfahren>4));

  printf("unsortiert:\n");

  //Zufallszahlen zwischen 0 und 32767 generieren
  #ifdef __BORLANDC__
    randomize();
  #endif
  for(counter=0;counter<anz_zahlen;counter++)
    printf("%u ",zahlen[counter]=rand()%32767);

  //Zahlenarray sortieren
  start=clock();
  switch(verfahren)
  {
    case 1:  bubblesort(zahlen,anz_zahlen-1);  break;
    case 2:  selectsort(zahlen,anz_zahlen-1);  break;
    case 3:  insertsort(zahlen,anz_zahlen-1);  break;
    case 4:  quicksort(zahlen,0,anz_zahlen-1); break;
  }
  ende=clock();

  printf("\nsortiert:\n");
  for(counter=0;counter<anz_zahlen;counter++)
    printf("%u ",zahlen[counter]);
  printf("\nZeitbedarf: %lf",((double)ende-start)/CLK_TCK);
  printf("\n");

  free(zahlen);
}