;----------------------------------------------------------------------------
;
;     ------------------------
;          Coded by        -= IMPORTANT: =-
;              *frank*
;     >  Copyright (c) 1997  <       dedicated to hugi-diskmag!
;     ------------------------
;
;     -->>> ADLIB & OPL 3 lowlevel support v 0.9 <<<--
;
;     Copyright (c) 1995-1997 by Frank Baumgartner aka frank/riot
; 
;     E-mail: frank@itc.or.at
;     Fido: 2:317/11.81
;
;----------------------------------------------------------------------------


;--- GLOBALS ---

op_table    db 00h, 01h, 02h, 08h   ;OP's-index for adlib
	    db 09h, 0ah, 10h, 11h
	    db 12h

comment 
opl_table   db 00h, 01h, 02h, 06h   ;OP's-index for OPL-3...
	    db 07h, 08h, 12h, 13h
	    db 14h, 18h, 19h, 20h
	    db 24h, 25h, 26h, 30h
	    db 31h, 32h


stereo  EQU 1                       ;OPL3-support globals
mono    EQU 0

adl_delay1      dw  8               ;default port delay-times...
adl_delay2      db  35

adl_base        dw  210h            ;start-port for auto-detection


;--- adl_write --------------------------------------------------------------
;
;AL = reg, AH = value
;
adl_write PROC
	push	cx
	mov     dx, adl_base
	out     dx, al                  ;write register..

	mov     cx, adl_delay1          ;delay...
sloop:
	in      al, dx
	loop    sloop

	inc     dx                      ;write value
	xchg    al, ah
	out     dx, al

	mov     cl, adl_delay2          ;delay...
sloop2:
	in      al, dx
	loop    sloop2
	pop	cx
	ret
adl_write ENDP


;--- adl_reset --------------------------------------------------------------
;
;reset the adlib-card registers...
;
adl_reset PROC

	mov     cx, 09h                 ;stop all channels!
rescloop:
	mov     ax, cx
	add     al, 0b0h-1
	call    adl_write
	mov	ax, cx
	add     al, 0a0h-1
	call    adl_write
	loop    rescloop

	mov     cl, 0ffh                 ;clear adlib main-regs...
resetloop:
	mov     ax, cx
	call    adl_write
	loop    resetloop

	ret
adl_reset ENDP


;----------------------------------------------------------------------------

num_baseports   EQU     8

;--- adl_detect -------------------------------------------------------------
;
;returns: CF = 0 ... no Adlib or compatible found!
;            = 1 ... okay, "base" = base-port of soundcard!
;
adl_detect PROC

	mov     cx, num_baseports
detectloop:                             ;auto-detection loop...

	;--- test 4 adlib ---
	mov     ax, 6004h               ;beide timer resetten
	call    adl_write

	mov     ax, 8004h               ;beide timer sperren
	call    adl_write

	dec	dx			;status 1 auslesen
	in	al, dx
	and     al, 0e0h
	jnz     not_found

	mov     ax, 0ff02h              ;timer 2 starten
	call    adl_write

	mov     ax, 2104h               ;timer 1 starten
	call    adl_write

	push	cx			;wait 4 adlib
	inc	ch
adl_delay:
	in	al, dx
	loop	adl_delay
	pop	cx

	dec	dx			;status 2 auslesen
	in	al, dx
	and     al, 0e0h
	cmp     al, 0c0h
	je      detected_adlib          ;--- found adlib ? ---

not_found:                              ;not found -> try next base-port!
	add     adl_base, 10h
	loop    detectloop

	inc	cx			;test reg. 388h
	add	adl_base, 388h-280h
	test	dl, 8h
	jz	detectloop

detection_done:
	clc                             ;--- adlib not found ---
	ret

detected_adlib:                         ;--- found adlib ---

	call    adl_reset               ;reset adlib

	mov     ax, 2001h               ;control waveform of each op.
	call    adl_write

	mov     ax, 4008h               ;sel. keyboard split-point
	call    adl_write

	stc                             ;return adlib found...
	ret
adl_detect ENDP

comment 

;--- adl_speechmode ----------------------------------------------------------
;
;initialises speech synthesis mode
;
adl_speechmode PROC
	mov     cx, 09h                 ;set keybd.-split for all channels...
speechl:
	mov     ax, cx
	add     ax, 10b0h-1
	call    adl_write
	loop    speechl

	mov     ax, 8008h               ;activate speech synthesis mode!
	call    adl_write
	ret
adl_speechmode ENDP


;----------------------------------------------------------------------------
;                    **** OPL 3+ specific support ****
;----------------------------------------------------------------------------
;
;*Achtung*:
;
;Alle OPL3-Funktionen funktionieren auch mit OPL2, *AUSSER*
;da bei OPL2 nur der Linke Kanal zur Verfgung steht, weil
;nur 1 OPL-Chip vorhanden ist!!!
;Info-quelle: PC-Intern 4.0
;

;--- opl3_setmode -----------------------------------------------------------
;
;Switch OPL-chips into mono or stereo mode (OPL 3+ only!)
;
;in:     AH: mode (mono = 0/stereo = 1)
;
opl3_setmode PROC

	push	ax
	add	adl_base, 2		;reset 2nd OPL
	call    adl_reset
	pop	ax

	mov     opl_mode, ah            ;which mode ?
	test	ah, ah
	jz      opl3_mono

opl3_stereo:                            ;--- opl3 stereo mode ---

	mov     al, 05h                 ;activate OPL3-mode (reg 05 = 1)
	call    adl_write

opl3_mono:                              ;opl3 mono-mode (reset done -> mono)

	sub	adl_base, 2		;restore base-port
	ret
opl3_setmode ENDP


;----------------------------------------------------------------------------

opl_pan_left EQU 10h                    ;hardware panning values...
opl_pan_right EQU 20h
opl_pan_middle EQU (opl_pan_left OR opl_pan_right)


;--- opl3_setchanpanning ----------------------------------------------------
;
;in:    CL = OPL 0 or 1
;       AL = channel
;       AH = original value for reg. 0xc0
;       BH = hardware panning-position
;
opl3_setchanpanning PROC

	shl     cl, 1			;calc base-port...
	add     byte ptr adl_base, cl

	add     al, 0c0h                ;reg.
	and     ah, NOT opl_pan_middle  ;value
	or      ah, bh
	call    adl_write

	sub     byte ptr adl_base, cl   ;restore port-nr.
	ret
opl3_setchanpanning ENDP


;--- opl3_detect ------------------------------------------------------------
;
;returns: CF = 0 OPL 2 only
;            = 1 OPL 3+ found!
;
opl3_detect PROC

	mov     dx, adl_base
	test    dl, 0fh                 ;wrong base -> no OPL 3+!
	jnz     no_opl3_detected

	in	al, dx			;baseport okay, test 4 OPL-3 now...
	test    al, 06h
	jz      opl3_detected

no_opl3_detected:
	clc                             ;OPL 2 only!
	ret

opl3_detected:

	mov     adl_delay1, 1           ;OPL3+ are faster!
	mov     adl_delay2, 15

	mov     dx, adl_base            ;initialize ports...
	mov     opl_base_l, dx
	inc     dx
	inc     dx
	mov     opl_base_r, dx

	stc
	ret
opl3_detect ENDP


;----------------------------------------------------------------------------
; **** ZERO DATA ****
;----------------------------------------------------------------------------

opl_base_l      dw      ?               ;- " - in OPL3+ mode
opl_base_r      dw      ?

opl_mode db     ?                       ;default replay-mode

;adl_regs db 256 dup (?)                 ;copy of the adlib-registers...


;----------------------------------------------------------------------------

