		ORG	100h		;COMPILER: FLAT ASSEMBLER 1.62
					;HC24 entry by Chut (fekete.akos@freemail.hu)
B		EQU	BYTE		;14.09.2005 converting into flat asm format (1 hour)
W		EQU	WORD		;03.09.2005 secure optimization before work (20 minutes)

		mov	di,pen.x
		mov	ch,251
		rep	stosb

bigLoop:	mov	ax,3		;enter textmode
		int	10h

openFile:	mov	ah,0Ah		;get file name from console
		mov	dx,keyBuf
		int	21h

		add	dx,2		;Z-terminate string
		mov	bx,dx
		movzx	di,B [bx-1]
		mov	B [bx+di],0

		mov	ax,3D00h	;open file
		int	21h
		jnc	@@1B		;if error, exit program
		int	20h

@@1B:		mov	[fileHandle],ax

		mov	ax,13h		;enter gfx mode 13h
		int	10h

		push	0A000h		;restore saved screendump
		pop	es
		mov	si,buf
		xor	di,di
		call	copy

execute:	mov	bp,readByte
		call	bp
		jcxz	@@1A
		add	ax,ax		;entries in cmdRoutineTable is 2 bytes
		cmp	al,20
		jb	nocut
		sub	al,12
nocut:		xchg	ax,bx
		call	W [bx + cmdRoutineTable] ;call command service
		jmp	execute 		;routine

@@1A:		mov	ah,3Eh		;close file
		mov	bx,[fileHandle]
		int	21h

		push	0A000h		;save screendump
		pop	ds
		push	cs
		pop	es
		xor	si,si
		mov	di,buf
		call	copy
		push	cs
		pop	ds
		jmp	bigLoop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; copy 64000 bytes from ds:si to es:di
copy:		pusha
		mov	ch,251
		rep	movsb
		popa
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
readByte:	mov	bx,[fileHandle]
		mov	cx,1
		mov	ah,3Fh
		mov	dx,buf
		int	21h

		xchg	ax,cx
		movzx	ax,B [buf]
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; plots pixel at pen.x, pen.y
; if pen.x,pen.y isnt whithin the screen, then they are clipped
; a pixel is plotted only if no clipping has occured
plot:		pusha
		call	clip
		mov	[pen.x],cx
		mov	[pen.y],ax
		test	dl,dl
		jnz	@@1D		 ;dont plot
		cmp	[pen.on],0
		je	@@1D		 ;dont plot
		call	getVideoAddress
		mov	al,[pen.color]
		stosb
@@1D:		popa
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; returns clipped pen.x in cx, and clipped pen.y in ax, dl != 0 if
; clipping has occured
clip:		push	bp
		xor	dl,dl
		mov	ax,[pen.x]
		mov	bp,319
		call	bound_func
		xchg	ax,cx
		mov	ax,[pen.y]
		mov	bp,199
		call	bound_func
		pop	bp
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; variable to test in ax, maxlimit in bp, increases dl if clipping is
; made
bound_func:	cmp	ax,0
		jge	@@1E
		xor	ax,ax
		inc	dl
@@1E:		cmp	ax,bp
		jle	@@2E
		mov	ax,bp
		inc	dl
@@2E:		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
getVideoAddress:imul	di,[pen.y],320
		add	di,[pen.x]
nop_func:	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveUp: 	mov	B [@@1G+1],0Eh	;DEC
		jmp	moveUD

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveDown:	mov	B [@@1G+1],06h	;INC
moveUD: 	call	plot
		call	bp
		xchg	ax,cx
		jcxz	@@2G
@@1G:		inc	[pen.y]
		call	plot
		loop	@@1G
@@2G:		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveLeft:	mov	B [@@1I+1],0Eh	;DEC
		jmp	moveLR

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveRight:	mov	B [@@1I+1],06h	;INC
moveLR: 	call	plot
		call	bp
		push	ax
		call	bp
		pop	cx
		mov	ch,al
		jcxz	@@2I
@@1I:		inc	[pen.x]
		call	plot
		loop	@@1I
@@2I:		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
moveCoord:	call	bp
		mov	B [pen.x],al
		call	bp
		mov	B [pen.x+1],al
		call	bp
		mov	B [pen.y],al
		call	bp
		mov	B [pen.y+1],al
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
penOn:		mov	[pen.on],-1
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
penOff: 	mov	[pen.on],0
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
changeColor:	call	bp
		mov	[pen.color],al
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pause_func:	xor	ax,ax
		int	16h
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; traditional midpoint line circle algorithm
midpointCircle:

; for your reading pleasure =D
X		EQU	BX
Y		EQU	AX
radius		EQU	AX
deltaE		EQU	BP
deltaSE 	EQU	CX
D		EQU	DX

		push	W [pen.on]	;circle cmd should not be affected by
		mov	[pen.on],-1	;pen on/off state

		call	bp		;Y = radius
		xor	X,X
		mov	D,1
		sub	D,radius
		mov	deltaE,3
		mov	deltaSE,5
		sub	deltaSE,radius
		sub	deltaSE,radius	;D = 1-radius, deltaE = 3
				;deltaSE = 5 - 2*radius
		call	circlePlot
@@1J:		cmp	Y,X
		jbe	@@3J
		test	D,D
		jns	southEast
east:		add	D,deltaE
		add	deltaE,2
		add	deltaSE,2
		jmp	@@2J
southEast:	add	D,deltaSE
		add	deltaE,2
		add	deltaSE,4
		dec	Y

@@2J:		inc	X
		call	circlePlot
		jmp	@@1J
@@3J:		pop	W [pen.on]
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; use symmetry in order to print a circle
circlePlot:	pusha
		mov	bp,circlePlot2
		call	bp		;x,y
		neg	Y
		call	bp		;x,-y
		neg	X
		call	bp		;-x,-y
		neg	Y
		call	bp		;-x,y
		xchg	Y,X
		call	bp		;y,-x
		neg	Y
		call	bp		;y,x
		neg	X
		call	bp		;-y,x
		neg	Y
		call	bp
		popa
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
circlePlot2:	pusha
		xchg	[pen.x],X
		add	[pen.x],X
		xchg	[pen.y],Y
		add	[pen.y],Y
		call	plot
		mov	[pen.x],X
		mov	[pen.y],Y
		popa
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; this function is highly recursive and requires a lot of stack, worst
; case senario is that the levels of recursion equals the number of
; pixels available; a little less then 64k. Hence one can only afford
; one byte to be pushed on the stack per level of recusrion. A special
; "custom stack" is used for this.
fill:		call	bp
		mov	[fcolor.use],al

		call	getVideoAddress
		mov	al,B [es:di]
		mov	[fcolor.target],al

		mov	bx,buf
		mov	B [bx],@@1K - fill  ;call    filler
		jmp	filler
@@1K:		ret

filler: 	inc	bx

		call	clip		;on screen?
		test	dl,dl
		jnz	@@2L

		call	getVideoAddress
		mov	al,B [es:di]
		cmp	al,[fcolor.target]
		jnz	@@2L		 ;dont plot if color on pixel isnt
				;target color
		cmpxchg [fcolor.use],al
		jz	@@2L		 ;dont plot if target color and the
		stosb			;color in use (the color of the pixel
				;to be plotted) is equal
fillWest:	dec	[pen.x]
		mov	B [bx],fillEast - fill	   ;call    filler
		jmp	filler
fillEast:	add	[pen.x],2
		mov	B [bx],fillNorth - fill    ;call    filler
		jmp	filler
fillNorth:	dec	[pen.x]
		dec	[pen.y]
		mov	B [bx],fillSouth - fill    ;call    filler
		jmp	filler
fillSouth:	add	[pen.y],2
		mov	B [bx],@@1L - fill	    ;call    filler
		jmp	filler

@@1L:		dec	[pen.y] 	;back to were we started
@@2L:		dec	bx		;ret
		movsx	ax,B [bx]
		add	ax,fill
		jmp	ax

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cmdRoutineTable:
    DW	nop_func
    DW	moveUp
    DW	moveDown
    DW	moveLeft
    DW	moveRight
    DW	moveCoord
    DW	penOn
    DW	penOff
    DW	changeColor
    DW	pause_func
    DW	midpointCircle
    DW	fill

keyBuf		DB 20,0,20 dup(?)

pen.x		DW ?
pen.y		DW ?
pen.on		DB ?
pen.color	DB ?

fcolor.target	DB ?
fcolor.use	DB ?

fileHandle	DW ?

buf: