#include "allegro.h"   
#include "C:\Dev-Cpp\fmodapi374win\api\inc\fmod.h"
#include "C:\Dev-Cpp\fmodapi374win\api\inc\fmod_errors.h"  
#include <string.h>

#define screen_x 320
#define screen_y 200
#define font_x 1536

// font size
#define font_width 32
#define font_height 64

using namespace std;
FMUSIC_MODULE *mod = NULL;
BITMAP *font_bmp;    // the image from the pcx file 
PALETTE font_pal;  // the palette from the pcx file
BITMAP *off_screen; // off screen buffer
BITMAP *background; // background buffer
PALETTE background_pal;
PALETTE combo_pal;

void Init_Music(void)
{
 	// verify FMOD version
 	if (FSOUND_GetVersion() < FMOD_VERSION)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);         
        allegro_message("Error : You are using the wrong DLL version!  You should be using FMOD %.02f\n", FMOD_VERSION);
        exit(1); // force abort
    }

 	// Initalize Allegro
    if (!FSOUND_Init(32000, 64, 0))
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);         
        allegro_message("Fmod Error: %s\n", FMOD_ErrorString(FSOUND_GetError()));
        exit(1); // force abort
    }
    // Set Allegro Message
    mod = FMUSIC_LoadSong("86sec.s3m");
    if (!mod)
    {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);         
        allegro_message("%s\n", FMOD_ErrorString(FSOUND_GetError()));
        exit(1); // force abort
    }
}

void Play_Music(void)
{
    // Play Song!
    FMUSIC_PlaySong(mod);   
}

void Kill_Music(void)
{
    FMUSIC_FreeSong(mod);
    FSOUND_Close();
}

void Init_Font(void)
{
    font_bmp = load_bitmap("bigfont.pcx", font_pal);  // image load 

}

void Kill_Font(void)
{
    destroy_bitmap(font_bmp);     // release bitmap data
}
void DrawCharacter(int x,int y, char letter)
{
    int i;
    
    // figure out the character mapping for the letter.
    // Credits and greets go to Barzoule for this mapping approach
    char chrmap[]="abcdefghijklmnopqrstuvwxyz0123456789\"'(),.;:+-!?";
    
    // character map, as seen on bigfont.pcx.  
    // char letter is passed by value (not by reference), so I can force upper 
    // case letters to lower case to match the map.
    if(letter>='A' && letter<='Z')
        letter +='a'-'A';

    // do linear search
    for (i=0;i<strlen(chrmap)&&(chrmap[i]!=letter);i++);      

    // Copy character from font_bmp to screen. (if we found a valid one)
    if (i<strlen(chrmap))
      if ((x+font_width)>0 && x<screen_x)     // verify that the x position is visible
        masked_blit(font_bmp, off_screen,
                i*font_width,0, // font position
                x, y, // letter on screen
                font_width, font_height); // letter dimensions

}

void DrawString(int x,int y,char *message)
{
    int i;
    
    for (i=0;i<strlen(message);i++)
        DrawCharacter(x+i*font_width,y,message[i]);
}



void ResolvePalettes(PALETTE font_pal,PALETTE img_pal,BITMAP *font_bmp, 
    BITMAP *img_bmp,PALETTE out_pal)
{   
    int freq[64][64][64];
    int r,g,b;
    int x,y,i;
    int best_freq_value;

    RGB bestColour;
    RGB tempColour;
    
    // initalize the palette frequency table to 0
    memset(freq,0,sizeof(freq));                 
    
    // populate colour frequency for font
    set_palette(font_pal); // used by get_color
    for (x=0;x<font_x;x++)
        for (y=0;y<font_height;y++)
        {
                get_color(getpixel(font_bmp,x,y),&tempColour);
                freq[tempColour.r][tempColour.g][tempColour.b]++; // inc freq
        }

    // populate colour frequency for background
    set_palette(img_pal); // used by get_color
    for (x=0;x<screen_x;x++)
        for (y=0;y<screen_y;y++)
        {
                get_color(getpixel(font_bmp,x,y),&tempColour);
                freq[tempColour.r][tempColour.g][tempColour.b]++; // inc freq
        }
    

    // we now have color frequencies, let's build a palette from it. 
    // we want to make sure that black is included, so we'll force it
    out_pal[0].r=0;out_pal[0].g=0;out_pal[0].b=0;
    freq[0][0][0]=-1; // not required.
    for (i=1;i<256;i++)
    {
        // scan the frequency table, finding the "best frequency" to use.
        best_freq_value=0;
        bestColour.r=0;  bestColour.g=0;  bestColour.b=0;
        //allegro_message("entering scan");
        for (r=0;r<64;r++) 
                for (g=0;g<64;g++)
                        for (b=0;b<64;b++)
                            if (freq[r][g][b]>best_freq_value)
                            {
                               bestColour.r=r;
                               bestColour.g=g;
                               bestColour.b=b;
                               best_freq_value=freq[r][g][b];
                            }

        // adopt best palette
        out_pal[i]=bestColour;
        freq[bestColour.r][bestColour.g][bestColour.b]=-1; // force new pick
    }
    
    // adjust images to use the best colour
    set_palette(font_pal);
    for (x=0;x<font_x;x++) // font image
        for (y=0;y<font_height;y++)
        {       
                if (getpixel(font_bmp,x,y)==0)
                   putpixel(font_bmp,x,y,0); // preserve colour 0 for masking
                else
                {
                  get_color(getpixel(font_bmp,x,y),&tempColour);                 
                  putpixel(font_bmp,x,y,
                                bestfit_color(out_pal, 
                                tempColour.r, tempColour.g, tempColour.g));
                }
        }

     set_palette(img_pal);
     for (x=0;x<screen_x;x++) // background image
        for (y=0;y<screen_y;y++)
        {
                get_color(getpixel(img_bmp,x,y),&tempColour); 
                putpixel(img_bmp,x,y,
                                bestfit_color(out_pal, 
                                tempColour.r, tempColour.g, tempColour.g));
        }

}
// main program
int main(int argc, char *argv[]) {

    int framecount;
    framecount=0;

    allegro_init();        // init Allegro 
	install_keyboard();    // setup allegro keyboard
	
	set_color_depth(8) ;   // 8 bit colour
	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, screen_x, screen_y, 0, 0)<0)
	{
	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);  
	    allegro_message("Failure to init video mode!\n%s\n", allegro_error);
	    exit(1); // force abort
	}
 	
 	 off_screen = create_bitmap(screen_x, screen_y);  
 	 background = load_bitmap("backgrnd.pcx", background_pal);  // image load 
 	 
 	// init more stuff  (next phase)
 	Init_Music();
    Init_Font();
    ResolvePalettes(font_pal,background_pal,font_bmp, background,combo_pal);
    // use our new palette!!!
    set_palette(combo_pal);

    install_timer(); 
    Play_Music();
    

	while ((!key[KEY_ESC])&&(!key[KEY_SPACE])) 
    {
        // DO SOMETHING AMAZING HERE!
        blit(background, off_screen, 0, 0, 0, 0, screen_x, screen_y);  
        DrawString((framecount % 640)-320,68,"SCROLLER");
        framecount+=1;
        vsync();
        blit(off_screen, screen, 0, 0, 0, 0, screen_x, screen_y);  
        rest(1); 
    };
    
    
    // de-init more stuff  (next phase)
    destroy_bitmap(off_screen);     // release screen buffer
    destroy_bitmap(background);
    Kill_Music();
    Kill_Font();
    remove_timer();     
	return 0;     
}     
END_OF_MAIN();
