import java.applet.Applet;

import java.awt.image.BufferedImage;
import java.awt.Graphics;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;

class DrawBxFX extends TimerTask
{
	Applet		FXApplet;
	int		Pixels[];
	int		Black[];
	int		x, y, ix, iy;
	BufferedImage	TheImage;

	DrawBxFX(Applet TargetApplet, BufferedImage TargetImage)
	{
		int	i;
		Pixels = new int[160*120];
		Black = new int[160*120];
		for (i=0;i<160*120;i++)
			Black[i] = 0;

		FXApplet = TargetApplet;
		TheImage = TargetImage;

		x = 80;
		y = 60;
		ix = 1;
		iy = -1;
	}

	public void run()
	{
		Graphics	g;
		System.arraycopy(Black, 0, Pixels, 0, 160*120);
		Pixels[y*160+x] = 255<<24|255<<16|255<<8|255;
		if (x == 159 || x == 0)
			ix = -ix;
		if (y == 119 || y == 0)
			iy = -iy;
		x += ix;
		y += iy;
		TheImage.setRGB(0, 0, 160, 120, Pixels, 0, 160);
		g = FXApplet.getGraphics();
		g.drawImage(TheImage, 0, 0, null);
	}
}

public class BxFX extends Applet
{
	BufferedImage	TheImage;
	Timer		aTimer;

	public void init()
	{
		setBackground(new Color(0, 0, 0, 0));
		TheImage = (BufferedImage) createImage(160, 120);
		aTimer = new Timer();
		aTimer.scheduleAtFixedRate(new DrawBxFX(this, TheImage), 0, 50);
	}

	public void paint(Graphics g)
	{
		g.drawImage(TheImage, 0, 0, null);
	}

	public String getAppletInfo()
	{
		return "BxFX Applet for Bad Sector's homepage by Bad Sector :-)";
	}
}
