// mutagenDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mutagen.h"
#include "mutagenDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMutagenDlg dialog

CMutagenDlg::CMutagenDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMutagenDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMutagenDlg)
	m_smpn = _T("");
	m_freq = _T("");
	m_att = _T("");
	m_sust = _T("");
	m_rel = _T("");
	m_smp_len = _T("");
	m_pitch_env = _T("");
	m_cutoff = _T("");
	m_resonance = _T("");
	m_cut_env = _T("");
	m_res_env = _T("");
	m_pass_high = _T("");
	m_pass_low = _T("");
	m_pass_high_env = _T("");
	m_pass_low_env = _T("");
	m_amplitude = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMutagenDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMutagenDlg)
	DDX_Control(pDX, IDC_CHK_RENDERING, m_chk_render);
	DDX_Control(pDX, IDC_CHECK_CR, m_chk_cr);
	DDX_Control(pDX, IDC_EDT_SMPN, m_edt_smpn);
	DDX_Control(pDX, IDC_SPIN1, m_spin1);
	DDX_Control(pDX, IDC_CMB_GEN, m_cmb_gen);
	DDX_Control(pDX, IDC_CMB_SRATE, m_cmb_srate);
	DDX_Control(pDX, IDC_CMB_SMP, m_cmb_smp);
	DDX_Text(pDX, IDC_EDT_SMPN, m_smpn);
	DDV_MaxChars(pDX, m_smpn, 4);
	DDX_Text(pDX, IDC_EDT_FREQ, m_freq);
	DDX_Text(pDX, IDC_EDT_ATT, m_att);
	DDX_Text(pDX, IDC_EDT_SUST, m_sust);
	DDX_Text(pDX, IDC_EDT_REL, m_rel);
	DDX_Text(pDX, IDC_EDT_LEN, m_smp_len);
	DDX_Text(pDX, IDC_EDT_PITCH_ENV, m_pitch_env);
	DDX_Text(pDX, IDC_EDT_FREQ_CUT, m_cutoff);
	DDX_Text(pDX, IDC_EDT_FREQ_RES, m_resonance);
	DDX_Text(pDX, IDC_EDT_CUT_ENV, m_cut_env);
	DDX_Text(pDX, IDC_EDT_RES_ENV, m_res_env);
	DDX_Text(pDX, IDC_EDT_FREQ_HIGHF, m_pass_high);
	DDX_Text(pDX, IDC_EDT_FREQ_LOWF, m_pass_low);
	DDX_Text(pDX, IDC_EDT_HIGHF_ENV, m_pass_high_env);
	DDX_Text(pDX, IDC_EDT_LOWF_ENV, m_pass_low_env);
	DDX_Text(pDX, IDC_EDT_AMPLITUDE, m_amplitude);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMutagenDlg, CDialog)
	//{{AFX_MSG_MAP(CMutagenDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN1, OnDeltaposSpin1)
	ON_CBN_SELCHANGE(IDC_CMB_SMP, OnSelchangeCmbSmp)
	ON_COMMAND(ID_FILESTAFF_OPEN, OnFilestaffOpen)
	ON_BN_CLICKED(IDC_BTN_PASS, OnBtnPass)
	ON_CBN_SELCHANGE(IDC_CMB_SRATE, OnSelchangeCmbSrate)
	ON_EN_CHANGE(IDC_EDT_FREQ, OnChangeEdtFreq)
	ON_EN_CHANGE(IDC_EDT_ATT, OnChangeEdtAtt)
	ON_EN_CHANGE(IDC_EDT_SUST, OnChangeEdtSust)
	ON_EN_CHANGE(IDC_EDT_REL, OnChangeEdtRel)
	ON_EN_CHANGE(IDC_EDT_PITCH_ENV, OnChangeEdtPitchEnv)
	ON_CBN_SELCHANGE(IDC_CMB_GEN, OnSelchangeCmbGen)
	ON_BN_CLICKED(IDC_CHECK_CR, OnCheckCr)
	ON_EN_CHANGE(IDC_EDT_FREQ_CUT, OnChangeEdtFreqCut)
	ON_EN_CHANGE(IDC_EDT_FREQ_RES, OnChangeEdtFreqRes)
	ON_EN_CHANGE(IDC_EDT_CUT_ENV, OnChangeEdtCutEnv)
	ON_EN_CHANGE(IDC_EDT_RES_ENV, OnChangeEdtResEnv)
	ON_EN_CHANGE(IDC_EDT_FREQ_LOWF, OnChangeEdtFreqLowf)
	ON_EN_CHANGE(IDC_EDT_FREQ_HIGHF, OnChangeEdtFreqHighf)
	ON_EN_CHANGE(IDC_EDT_LOWF_ENV, OnChangeEdtLowfEnv)
	ON_EN_CHANGE(IDC_EDT_HIGHF_ENV, OnChangeEdtHighfEnv)
	ON_COMMAND(ID_FILESTAFF_NEW, OnFilestaffNew)
	ON_COMMAND(ID_FILESTAFF_SAVEAS, OnFilestaffSaveas)
	ON_COMMAND(ID_FILESTAFF_EXIT, OnFilestaffExit)
	ON_WM_CLOSE()
	ON_COMMAND(ID_FILESTAFF_GENERATE, OnFilestaffGenerate)
	ON_BN_CLICKED(IDC_BTN_PLAY, OnBtnPlay)
	ON_BN_CLICKED(IDC_BT_RENDER, OnBtRender)
	ON_EN_CHANGE(IDC_EDT_AMPLITUDE, OnChangeEdtAmplitude)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMutagenDlg message handlers

BOOL CMutagenDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_cmb_gen.SetCurSel(0);
  m_cmb_srate.SetCurSel(0);

  m_cmb_smp.AddString("0");
  m_cmb_smp.SetCurSel(0);
  m_smpn = "1\0";
  UpdateData(FALSE);

  samples = 1;
  cur_smp = 0;
  m_spin1.SetRange(1,256);
  strcpy(wfile,"spmpack.txt");
  ftype = 0;
  NewPack();
  //"$mtg_tmp$.wav"
  GetWindowsDirectory(this->tmp_path,240);
  strcat(this->tmp_path,"\\$mtg_tmp$.wav");
  //MessageBox(this->tmp_path);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMutagenDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMutagenDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMutagenDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMutagenDlg::OnHelpAbout() 
{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();	
}

void CMutagenDlg::OnDeltaposSpin1(NMHDR* pNMHDR, LRESULT* pResult) 
{

	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

  char str[10];
  samples+= pNMUpDown->iDelta;
  if(samples<=0) 
    samples = 1;
  if(samples-1<cur_smp) 
    cur_smp = samples - 1;
  _itoa(samples,str,10);
  m_smpn = str;
  UpdateData(FALSE);

  m_cmb_smp.ResetContent();
  for(int i=0;i<samples;i++) {
    _itoa(i,str,10);
    m_cmb_smp.AddString(str);
  }
  m_cmb_smp.SetCurSel(cur_smp);
  ShowSample(cur_smp);
	*pResult = samples;
}



void CMutagenDlg::OnSelchangeCmbSmp() 
{
  cur_smp = m_cmb_smp.GetCurSel();
  ShowSample(cur_smp);
  char str[50];
  sprintf(str,"sample# %d",cur_smp);
//  MessageBox(str,NULL,MB_OK);
}

void CMutagenDlg::ShowSample(int smp_num)
{
  double db;

  char str[256];
//  int  decimal, sign;
  m_cmb_srate.ResetContent();
  m_cmb_srate.AddString("11025");
  m_cmb_srate.AddString("22050");
  m_cmb_srate.AddString("44100");
  m_cmb_srate.AddString("48000");
  switch(si[smp_num].rate) {
    case 48000: m_cmb_srate.SetCurSel(3); break;
    case 44100: m_cmb_srate.SetCurSel(2); break;
    case 22050: m_cmb_srate.SetCurSel(1); break;
    case 11025: m_cmb_srate.SetCurSel(0); break;
    default:  
      { 
        _itoa(si[smp_num].rate,str,10);
        m_cmb_srate.AddString(str);
        m_cmb_srate.SetCurSel(4); break;
      }
  }
  sprintf(str, "%6.4f", si[smp_num].frequency);
  m_freq  = str;
  db = ((float)si[smp_num].attack)/si[smp_num].rate;
  sprintf(str, "%3.7f", db);
  m_att   = str;
  UpdateData(FALSE);

  db = ((float)si[smp_num].sustain)/si[smp_num].rate;
  sprintf(str, "%3.7f", db);
  m_sust  = str;
  UpdateData(FALSE);
  db = ((float)si[smp_num].release)/si[smp_num].rate;
  sprintf(str, "%3.7f", db);
  m_rel   = str;
  UpdateData(FALSE);

  db = ((float)(si[smp_num].attack+si[smp_num].sustain+si[smp_num].release))/si[smp_num].rate;
  sprintf(str, "%3.7f", db);
  m_smp_len = str;
  UpdateData(FALSE);
  sprintf(str, "%3.7f", si[smp_num].pitch_env);
  m_pitch_env = str;
  UpdateData(FALSE);
  switch(si[smp_num].gen_type) {
    case G_SQU:   m_cmb_gen.SetCurSel(0); break;
    case G_SAW:   m_cmb_gen.SetCurSel(1); break;
    case G_NOISE: m_cmb_gen.SetCurSel(2); break;
    case G_SIN:   m_cmb_gen.SetCurSel(3); break;
  };
  sprintf(str, "%6.4f", si[smp_num].amplitude);
  m_amplitude = str;   

  if(si[smp_num].filter&1)
    m_chk_cr.SetCheck(1);
  else
    m_chk_cr.SetCheck(0);
  sprintf(str, "%6.4f", si[smp_num].cutoff);
  m_cutoff = str;
  sprintf(str, "%6.4f", si[smp_num].resonance);
  m_resonance = str;
  sprintf(str, "%6.4f", si[smp_num].cut_env);
  m_cut_env = str;
  sprintf(str, "%6.4f", si[smp_num].res_env);
  m_res_env = str;
  UpdateData(FALSE);

  CWnd* btn = this->GetDlgItem(IDC_BTN_PASS);
  switch(si[smp_num].filter&14) {
    case LOWPASS:btn->SetWindowText("low-pass filter");break;
    case HIGHPASS:btn->SetWindowText("high-pass filter");break;
    case BENDPASS:btn->SetWindowText("bend-pass filter");break;
    default:btn->SetWindowText("not use ...pass filter");break;
  }
  sprintf(str, "%d", si[smp_num].high_freq);
  m_pass_high = str;
  sprintf(str, "%d", si[smp_num].low_freq);
  m_pass_low = str;

  sprintf(str, "%f", si[smp_num].high_env);
  m_pass_high_env = str;
  sprintf(str, "%f", si[smp_num].low_env);
  m_pass_low_env = str;
  UpdateData(FALSE);
}

void CMutagenDlg::UpdateSample(int smp_num)
{
  double db;

  char str[256];
  switch( m_cmb_srate.GetCurSel()) {
    case 3: si[smp_num].rate =  48000;  break;
    case 2: si[smp_num].rate =  44100; break;
    case 1: si[smp_num].rate =  22050; break;
    case 0: si[smp_num].rate =  11025; break;
    default:  
      { 
        CWnd* select = this->GetDlgItem(IDC_CMB_SRATE);
        select->GetWindowText(str,256);
        si[smp_num].rate = atoi(str);
      }
  }
  UpdateData(TRUE);
  si[smp_num].frequency = (float)atof(m_freq);

  db = atof(m_att);
  si[smp_num].attack = (unsigned int)floor(db*si[smp_num].rate);

  db = atof(m_sust);
  si[smp_num].sustain = (unsigned int)floor(db*si[smp_num].rate);

  db = atof(m_rel);
  si[smp_num].release = (unsigned int)floor(db*si[smp_num].rate);

//  //  //
  db = ((float)(si[smp_num].attack+si[smp_num].sustain+si[smp_num].release))/si[smp_num].rate;
  sprintf(str, "%3.7f", db);
  m_smp_len = str;
  UpdateData(FALSE);
//  //  //

  
  si[smp_num].pitch_env = (float)atof(m_pitch_env);

  UpdateData(FALSE);
  switch(m_cmb_gen.GetCurSel()) {
    case 0: si[smp_num].gen_type = G_SQU; break;
    case 1: si[smp_num].gen_type = G_SAW; break;
    case 2: si[smp_num].gen_type = G_NOISE; break;
    case 3: si[smp_num].gen_type = G_SIN; break;
  };
  
  si[smp_num].amplitude = (float)atof(m_amplitude);

  if(m_chk_cr.GetCheck())
    si[smp_num].filter = si[smp_num].filter|1;    
  else
    si[smp_num].filter = si[smp_num].filter&(!1);

  si[smp_num].cutoff    = (float)atof(m_cutoff);
  si[smp_num].resonance = (float)atof(m_resonance);
  si[smp_num].cut_env   = (float)atof(m_cut_env);
  si[smp_num].res_env   = (float)atof(m_res_env);

  si[smp_num].high_freq = atoi(m_pass_high);
  si[smp_num].low_freq  = atoi(m_pass_low);
  si[smp_num].high_env  = (float)atof(m_pass_high_env);
  si[smp_num].low_env   = (float)atof(m_pass_low_env);
}

void CMutagenDlg::OnFilestaffOpen() 
{
	OPENFILENAME OpenFileName;
	TCHAR         szFile[MAX_PATH]      = "\0";
//	char *lpBufPtr;
  strcpy( szFile, "");
  char ftitle[128];
  char win_title[64];
  

	// Fill in the OPENFILENAME structure to support a template and hook.
	OpenFileName.lStructSize       = sizeof(OPENFILENAME);
  OpenFileName.hwndOwner         = this->GetSafeHwnd();
  //OpenFileName.hInstance         = this->Get;
  OpenFileName.lpstrFilter       = "Text files [*.txt]\0*.txt;\0Compiled samples [*.csm]\0*.csm;\0*.*\0*.*\0\0";
  OpenFileName.lpstrCustomFilter = NULL;
  OpenFileName.nMaxCustFilter    = 0;
  OpenFileName.nFilterIndex      = 0;
  OpenFileName.lpstrFile         = szFile;
  OpenFileName.nMaxFile          = sizeof(szFile);
  OpenFileName.lpstrFileTitle    = ftitle;
  OpenFileName.nMaxFileTitle     = 128;
  OpenFileName.lpstrInitialDir   = NULL;
  OpenFileName.lpstrTitle        = "Open samples pack...";
  OpenFileName.nFileOffset       = 0;
  OpenFileName.nFileExtension    = 0;
  OpenFileName.lpstrDefExt       = NULL;
//  OpenFileName.lCustData         = (LPARAM)&sMyData;
//  OpenFileName.lpfnHook 		   = ComDlg32DlgProc;
//	OpenFileName.lpTemplateName    = MAKEINTRESOURCE(IDD_COMDLG32);
  OpenFileName.Flags             = 0;

  char *extpos = strpbrk( ftitle, ".csm");
   
	// Call the common dialog function.
    if (GetOpenFileName(&OpenFileName)) {	
      if(OpenFileName.nFilterIndex==2)
        this->LoadCSM(OpenFileName.lpstrFile);
      else
        if(this->LoadTXT(OpenFileName.lpstrFile)) {
          strcpy(wfile,ftitle);
          strcpy(win_title,"MutaGen V0.0a  ");
          strcat(win_title ,wfile);
          this->SetWindowText(win_title);
        } 
        else {
          MessageBox("Can't open file for writing!",NULL,MB_OK|MB_ICONERROR);
        }
    }
    this->cur_smp = 0;
    this->ShowSample(this->cur_smp);
    SetSamplesNum(this->samples);
}

int CMutagenDlg::LoadTXT(char *fname)
{

  FILE  *fin;
  int sample_num=0;
 // short int *buf=NULL;
  //int len=0;



  fin = fopen(fname,"r");
  if(!fin)
    return 0;
  fseek_section("[SAMPLES_COUNT]",MF_RESUME,true,fin);

  fscanf(fin,"%d",&samples);

  for(int k=0;k<samples; k++) {
    fseek_section("[SAMPLE]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&sample_num);

    fseek_section("[FREQUENCY]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].frequency);

    fseek_section("[PITCH_ENV]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].pitch_env);

    fseek_section("[PHY]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].phy);

    fseek_section("[AMPLITUDE]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].amplitude);

    fseek_section("[RATE]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].rate);

    fseek_section("[GENERATOR]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].gen_type);

    fseek_section("[ATTACK]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].attack);

    fseek_section("[SUSTAIN]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].sustain);

    fseek_section("[RELEASE]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].release);

    fseek_section("[FILTER]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].filter);

    fseek_section("[CUTOFF]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].cutoff);

    fseek_section("[RESONANCE]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].resonance);

    fseek_section("[CUT_ENV]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].cut_env);

    fseek_section("[RES_ENV]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].res_env);

    fseek_section("[HIGH_FREQ]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].high_freq);

    fseek_section("[LOW_FREQ]",MF_RESUME,true,fin);
    fscanf(fin,"%d",&si[k].low_freq);

    fseek_section("[HIGH_ENV]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].high_env);

    fseek_section("[LOW_ENV]",MF_RESUME,true,fin);
    fscanf(fin,"%f",&si[k].low_env);
  }
  fclose(fin);
  return 1;
}

int CMutagenDlg::LoadCSM(char *fname)
{

  FILE  *fin;
  fin = fopen(fname,"rb");
  if(!fin)
    return 0;
  fread((void*)&this->samples,sizeof(this->samples),1,fin);
  for(int k=0;k<this->samples;k++) {
    fread((void*)&this->si[k],sizeof(this->si[k]),1,fin);
  }
  fclose(fin);
  return 1;
}

void CMutagenDlg::SetSamplesNum(int num)
{
  char str[10];
  samples = num;
  if(samples<=0) 
    samples = 1;
  if(samples-1<cur_smp) 
    cur_smp = samples - 1;
  _itoa(samples,str,10);
  m_smpn = str;
  UpdateData(FALSE);

  m_cmb_smp.ResetContent();
  for(int i=0;i<samples;i++) {
    _itoa(i,str,10);
    m_cmb_smp.AddString(str);
  }
  m_cmb_smp.SetCurSel(cur_smp);
  ShowSample(cur_smp);
}

void CMutagenDlg::OnBtnPass() 
{
  CWnd* btn = this->GetDlgItem(IDC_BTN_PASS);
  int curf = si[cur_smp].filter&14;
//#define LOWPASS 2
//#define HIGHPASS 4
//#define BENDPASS 8
  switch(si[cur_smp].filter&14) {
    case        0: si[cur_smp].filter = si[cur_smp].filter&(!(14))|LOWPASS; break;
    case LOWPASS : si[cur_smp].filter = si[cur_smp].filter&(!(14))|HIGHPASS;break;
    case HIGHPASS: si[cur_smp].filter = si[cur_smp].filter&(!(14))|BENDPASS;break;
    case BENDPASS: si[cur_smp].filter = si[cur_smp].filter&(!(14));         break;
  }
/*  if(curf) {
    curf =(curf<<1)&14;
    si[cur_smp].filter = (si[cur_smp].filter&0xFFFFFFF1)|curf;
  }
  else {
    si[cur_smp].filter = (si[cur_smp].filter&0xFFFFFFF1)|2;
  }*/

  switch(si[cur_smp].filter&14) {
    case LOWPASS:btn->SetWindowText("low-pass filter");break;
    case HIGHPASS:btn->SetWindowText("high-pass filter");break;
    case BENDPASS:btn->SetWindowText("bend-pass filter");break;
    default:btn->SetWindowText("not use ...pass filter");break;
  }
  
}

void CMutagenDlg::OnSelchangeCmbSrate() 
{
  this->UpdateSample(this->cur_smp);
}

void CMutagenDlg::OnChangeEdtFreq() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtAtt() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtSust() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtRel() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtPitchEnv() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnSelchangeCmbGen() 
{
  this->UpdateSample(this->cur_smp);	
}

void CMutagenDlg::OnCheckCr() 
{
  this->UpdateSample(this->cur_smp);	
}

void CMutagenDlg::OnChangeEdtFreqCut() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtFreqRes() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtCutEnv() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtResEnv() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtFreqLowf() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);

	
}

void CMutagenDlg::OnChangeEdtFreqHighf() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtLowfEnv() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::OnChangeEdtHighfEnv() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
	
}

void CMutagenDlg::NewPack()
{
  char win_title[64];

  this->cur_smp = 0;
  this->samples = 1;
  for(int i=0;i<256;i++) {
    si[i].amplitude = 0;
    si[i].attack    = 0;
    si[i].cut_env   = 0;
    si[i].cutoff    = 0;
    si[i].filter    = 0;
    si[i].frequency = 0;
    si[i].gen_type  = 1;
    si[i].high_env  = 0;
    si[i].high_freq = 30000;
    si[i].low_env   = 0;
    si[i].low_freq  = 20;
    si[i].phy       = 0;
    si[i].pitch_env = 0;
    si[i].rate      = 44100;
    si[i].release   = 0;
    si[i].res_env   = 0;
    si[i].resonance = 1;
    si[i].sustain   = 1;
  }
  this->ShowSample(this->cur_smp);
  strcpy(wfile,"new_pack.txt");
  strcpy(win_title,"MutaGen V0.0a  ");
  strcat(win_title, wfile);
  this->SetWindowText(win_title);
}

void CMutagenDlg::OnFilestaffNew() 
{
  this->NewPack();
}

void CMutagenDlg::OnFilestaffSaveas() 
{
	OPENFILENAME SaveFileName;
	TCHAR         szFile[MAX_PATH]      = "\0";
//	char *lpBufPtr;
  strcpy( szFile, "");
  char ftitle[128];
  char win_title[64];
  

	// Fill in the OPENFILENAME structure to support a template and hook.
	SaveFileName.lStructSize       = sizeof(OPENFILENAME);
  SaveFileName.hwndOwner         = this->GetSafeHwnd();
  //SaveFileName.hInstance         = this->Get;
  SaveFileName.lpstrFilter       = "Text files [*.txt]\0*.txt;\0Compiled samples [*.csm]\0*.csm;\0*.*\0*.*\0\0";
  SaveFileName.lpstrCustomFilter = NULL;
  SaveFileName.nMaxCustFilter    = 0;
  SaveFileName.nFilterIndex      = 0;
  SaveFileName.lpstrFile         = szFile;
  SaveFileName.nMaxFile          = sizeof(szFile);
  SaveFileName.lpstrFileTitle    = ftitle;
  SaveFileName.nMaxFileTitle     = 128;
  SaveFileName.lpstrInitialDir   = NULL;
  SaveFileName.lpstrTitle        = "Save samples pack as...";
  SaveFileName.nFileOffset       = 0;
  SaveFileName.nFileExtension    = 0;
  SaveFileName.lpstrDefExt       = NULL;
//  SaveFileName.lCustData         = (LPARAM)&sMyData;
//  SaveFileName.lpfnHook 		   = ComDlg32DlgProc;
//	SaveFileName.lpTemplateName    = MAKEINTRESOURCE(IDD_COMDLG32);
  SaveFileName.Flags             = 0;

  char *extpos = strpbrk(ftitle, ".csm");
   
	// Call the common dialog function.
    if (GetSaveFileName(&SaveFileName)) {	
      if(SaveFileName.nFilterIndex==2)
        this->SaveCSM(SaveFileName.lpstrFile);
      else
        if(this->SaveTXT(SaveFileName.lpstrFile)) {
          strcpy(wfile,ftitle);
          strcpy(win_title,"MutaGen V0.0a  ");
          strcat(win_title, wfile);
          this->SetWindowText(win_title);
        }
        else {
          MessageBox("Can't open file for writing!",NULL,MB_OK|MB_ICONERROR);
        }
    }
    this->cur_smp = 0;
    this->ShowSample(this->cur_smp);
    SetSamplesNum(this->samples);	
}

int CMutagenDlg::SaveTXT(char *fname)
{
  FILE  *fout;

  fout = fopen(fname,"w");
  if(!fout)
    return 0;

  fprintf(fout, "[SAMPLES_COUNT] %d\n",samples);

  for(int k=0;k<this->samples; k++) {
    fprintf(fout, "\n[SAMPLE] %d\n\n",k);

    fprintf(fout, "[FREQUENCY] %f\n",si[k].frequency);
    fprintf(fout, "[PITCH_ENV] %f\n",si[k].pitch_env);
    fprintf(fout, "[PHY] %f\n",si[k].phy);
    fprintf(fout, "[AMPLITUDE] %f\n",si[k].amplitude);
    fprintf(fout, "[RATE] %d\n",si[k].rate);
    fprintf(fout, "[GENERATOR] %d\n",si[k].gen_type);

    fprintf(fout, "[ATTACK] %d\n",si[k].attack);
    fprintf(fout, "[SUSTAIN] %d\n",si[k].sustain);
    fprintf(fout, "[RELEASE] %d\n",si[k].release);

    fprintf(fout, "[FILTER] %d\n",si[k].filter);

    fprintf(fout, "[CUTOFF] %f\n",si[k].cutoff);
    fprintf(fout, "[RESONANCE] %f\n",si[k].resonance);
    fprintf(fout, "[CUT_ENV] %f\n",si[k].cut_env);
    fprintf(fout, "[RES_ENV] %f\n",si[k].res_env);

    fprintf(fout, "[HIGH_FREQ] %d\n",si[k].high_freq);
    fprintf(fout, "[LOW_FREQ] %d\n",si[k].low_freq);
    fprintf(fout, "[HIGH_ENV] %f\n",si[k].high_env);
    fprintf(fout, "[LOW_ENV] %f\n",si[k].low_env);
  }
  fclose(fout);
  return 1;
}

int CMutagenDlg::SaveCSM(char *fname)
{

  FILE  *fout;
  fout = fopen(fname,"wb");
  if(!fout)
    return 0;
  fwrite((void*)&this->samples,sizeof(this->samples),1,fout);
  for(int k=0;k<this->samples;k++) {
    fwrite((void*)&this->si[k],sizeof(this->si[k]),1,fout);
  }
  fclose(fout);
  return 1;
}
void CMutagenDlg::OnFilestaffExit() 
{
  //this->OnOK();	
  CDialog::OnOK();
}

void CMutagenDlg::OnOK() 
{
//	CDialog::OnOK();
}

void CMutagenDlg::OnCancel() 
{
//	CDialog::OnCancel();
}

void CMutagenDlg::OnClose() 
{
	CDialog::OnOK();	
	//CDialog::OnClose();
}

void CMutagenDlg::WriteWaveHead16m(FILE *f, int srate, int slen)
{
  int raw_len = slen*2;
  int byterate = srate*2;
  int big_chunk = raw_len+36;
  unsigned char ch[16] = {'W','A','V','E','f','m','t',0x20,0x10,0x00,0x00,0x00,0x01,0x00,0x01,0x00};
  unsigned char ch1[8] = {0x02,0x00,0x10,0x00,'d','a','t','a'};
  fwrite("RIFF",4,1,f);
  fwrite(&big_chunk,1,4,f);
  fwrite(ch,1,16,f);
  fwrite(&srate,4,1,f);
  fwrite(&byterate,4,1,f);
  fwrite(ch1,1,8,f);
  fwrite(&raw_len,4,1,f);
}

int CMutagenDlg::GenerateSamples()
{
  FILE  *fout;
  char  str[256];
  char  fname[64];
  short int *buf=NULL;
  int len=0;

  strcpy(fname,this->wfile);
  for(int i = 0;i<64; i++)
    if(fname[i] == '.') {
      fname[i] = 0;
      break;
    }


  for(int k=0;k<samples; k++) {
    m_chk_render.SetCheck(1);
    len = si[k].attack+si[k].sustain+si[k].release;

    if(buf!=NULL)
      delete []buf;
    buf = new short int [len];
    if(!buf)
      return 0;
    GenerateSample16((void*)buf,&si[k]);
    sprintf(str,"%s%02d.wav",fname,k);
    fout = fopen(str,"wb");
    if(!fout) {
      if(buf!=NULL)
        delete []buf;
      return 0;
    }
    this->WriteWaveHead16m(fout,si[k].rate,len);
    fwrite((const void*)buf,2,len,fout);
    fclose(fout);
    m_chk_render.SetCheck(0);
  }

  if(buf!=NULL)
    delete []buf;
  return 1;
}

void CMutagenDlg::OnFilestaffGenerate() 
{
  GenerateSamples();	
}

void CMutagenDlg::OnBtnPlay() 
{
//  if(this->sample)
//    if(!PlaySound((const char *)this->sample, NULL, SND_MEMORY|SND_ASYNC))
//      MessageBox("Can't play sound");

    if(!PlaySound(this->tmp_path, NULL, SND_FILENAME|SND_ASYNC))
      MessageBox("Can't play sound");
}

void CMutagenDlg::OnBtRender() 
{/*
  short int *buf=NULL;
  int len=0;

  int raw_len;
  int byterate;
  int big_chunk;
  unsigned char ch[16] = {'W','A','V','E','f','m','t',0x20,0x10,0x00,0x00,0x00,0x01,0x00,0x01,0x00};
  unsigned char ch1[8] = {0x02,0x00,0x10,0x00,'d','a','t','a'};



  m_chk_render.SetCheck(1);
  len = si[cur_smp].attack+si[cur_smp].sustain+si[cur_smp].release;

  raw_len = len*2;
  byterate = si[cur_smp].rate*2;
  big_chunk = raw_len+36;

  if(sample!=NULL)
    delete []sample;
  sample = (unsigned char*)new short int [len + 22];
  if(!sample)
    return;
  buf = (short int*)((unsigned char*)(sample) + 44);

  memcpy(sample   ,"RIFF",4);
  memcpy(sample+ 4,&big_chunk,4);
  memcpy(sample+ 8,ch,16);
  memcpy(sample+24,&si[cur_smp].rate,4);
  memcpy(sample+28,&byterate,4);
  memcpy(sample+32,ch1,8);
  memcpy(sample+40,&raw_len,4);
  GenerateSample16((void*)buf,&si[cur_smp]);
  m_chk_render.SetCheck(0);*/

  FILE  *fout;
  short int *buf=NULL;
  int len=0;

  m_chk_render.SetCheck(1);
  len = si[cur_smp].attack+si[cur_smp].sustain+si[cur_smp].release;

  if(buf!=NULL)
    delete []buf;
  buf = new short int [len];
  if(!buf) {
    MessageBox("Can't alocate memory for sample.\nCheck sample length!!!",NULL,MB_OK|MB_ICONERROR);
    return;
  }
  GenerateSample16((void*)buf,&si[cur_smp]);
  fout = fopen(this->tmp_path,"wb");
  if(!fout) {
    MessageBox("Can't create temp file!!!",NULL,MB_OK|MB_ICONERROR);
    if(buf!=NULL)
      delete []buf;
    return;
  }
  this->WriteWaveHead16m(fout,si[cur_smp].rate,len);
  fwrite((const void*)buf,2,len,fout);
  fclose(fout);
  m_chk_render.SetCheck(0);

  if(buf!=NULL)
    delete []buf;
}

void CMutagenDlg::OnChangeEdtAmplitude() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
  this->UpdateSample(this->cur_smp);
}
