#include <math.h>
#include "vector.h"


CVector CVector::operator+=(CVector &vec)
{
	CVector ret;

	ret = *this = *this + vec;
	return ret;
}

CVector CVector::operator-=(CVector &vec)
{
   CVector ret;

   ret = *this = *this - vec;
   return ret;
}

CVector CVector::operator*=(CVector &vec)
{
   CVector ret;

   ret = *this = *this * vec;
   return ret;
}

CVector CVector::operator*=(GLfloat val)
{
   CVector ret;

   ret = *this = *this * val;
   return ret;
}

CVector CVector::operator/=(CVector &vec)
{
   CVector ret;

   ret = *this = *this / vec;
   return ret;
}

CVector CVector::operator/=(GLfloat val)
{
   CVector ret;

   ret = *this = *this / val;
   return ret;
}

void CVector::normalize () 
{
	GLfloat len, lmul = 0;

	len = length();

	if (len == 0)
		return;

	lmul = 1.0f / len;
	v[0] *= lmul;
	v[1] *= lmul;
	v[2] *= lmul;
}

CVector CVector::normalized ()
{
	GLfloat len, lmul = 0;
	CVector ret = *this;

	len = length();

	if (len == 0)
		return 0;

	lmul = 1.0f / len;
	ret[0] *= lmul;
	ret[1] *= lmul;
	ret[2] *= lmul;

	return ret;
}

float CVector::length () 
{
	double len = 0;

	len = (v[0] * v[0]) + (v[1] * v[1]) + (v[2] * v[2]);
	return (GLfloat) sqrt(len);
}

void CVector::cross(CVector &p, CVector &q)
{
	v[0] = p.v[1] * q.v[2] - p.v[2] * q.v[1];
	v[1] = p.v[2] * q.v[0] - p.v[0] * q.v[2];
	v[2] = p.v[0] * q.v[1] - p.v[1] * q.v[0];
}

void CVector::rotateX(float a)
{
  float s = (float) sin (a);
  float c = (float) cos (a);
  float y = v[1];
  float z = v[2];
  
  v[1] = (y * c) - (z * s);
  v[2] = (y * s) + (z * c);
}

void CVector::rotateY(float a)
{
  float s = (float) sin(a);
  float c = (float) cos(a);
  float x = v[0];
  float z = v[2];
  
  v[0] = (x * c) + (z * s);
  v[2] = (z * c) - (x * s);
}

void CVector::rotateZ(float a)
{
  float s = (float) sin(a);
  float c = (float) cos(a);
  float x = v[0];
  float y = v[1];
  
  v[0] = (x * c) - (y * s);
  v[1] = (y * c) + (x * s);
}
