#include "temple.h"
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "globals.h"
#include "system.h"
#include "text.h"
#include "keys.h"
#include "objgen.h"
#include "templedata.h"
//#include "nedata.h"
#include "plasma.h"
#include "tunnel.h"

Model *templesubmodel[ntemplemodels];
Model *buildingsubmodel[nbuildingmodels];
Model *templewater1;
Model *templeland;
Model *templeback1;
//Model *templefloor;

void generate_Temple()
{
int i = 0;

for (i = 0; i < ntemplemodels; i++)
	{
	templesubmodel[i] = new Model;
	templesubmodel[i]->textured = true;
	templesubmodel[i]->texture = TID_ATG[7];
	}

templesubmodel[templepillar1]->setpos(-2.5,0.6,-2.5);
templesubmodel[templepillar2]->setpos( 2.5,0.6,-2.5);
templesubmodel[templepillar3]->setpos(-2.5,0.6, 2.5);
templesubmodel[templepillar4]->setpos( 2.5,0.6, 2.5);

templesubmodel[templecube1b]->setpos(-2.5,0.5,-2.5);
templesubmodel[templecube2b]->setpos( 2.5,0.5,-2.5);
templesubmodel[templecube3b]->setpos(-2.5,0.5, 2.5);
templesubmodel[templecube4b]->setpos( 2.5,0.5, 2.5);
templesubmodel[templecube1t]->setpos(-2.5,3.7,-2.5);
templesubmodel[templecube2t]->setpos( 2.5,3.7,-2.5);
templesubmodel[templecube3t]->setpos(-2.5,3.7, 2.5);
templesubmodel[templecube4t]->setpos( 2.5,3.7, 2.5);

for (i=templepillar1;i<=templepillar4;i++)
	{
	genCone(*templesubmodel[i],12, 3.0, 0.3, 0.3);
	templesubmodel[i]->texture = TID_ATG[0];
	}

// the blocks above and below the pillars
for (i=templecube1b;i<=templecube4t;i++)
	{
	genCube(*templesubmodel[i]);
	templesubmodel[i]->scale(0.04,0.01,0.04);
	}

// the base (stairs)
loadModel(*templesubmodel[templebottom],templedata,32,56);
//loadModel(*templesubmodel[templebottom],nedata,78,136);
templesubmodel[templebottom]->scale(3,0.5,3);
//templesubmodel[templebottom]->scale(0.6,0.6,0.6);
templesubmodel[templebottom]->rY = 45;

// the dome
templesubmodel[templedome]->rX = 180;
genSphere(*templesubmodel[templedome],2.3,10,5,true);
templesubmodel[templedome]->setpos( 0,4.3,0 );
templesubmodel[templedome]->texture = TID_ATG[0];

// the roof
templesubmodel[templeroof]->setpos(0,4,0);
genCube(*templesubmodel[templeroof]);
templesubmodel[templeroof]->scale(0.3,0.03,0.3);

// generates the floor
templesubmodel[templefloor]->texture = TID_ATG[2];
genTerrain (*templesubmodel[templefloor], 2, NULL, 1.0);
templesubmodel[templefloor]->scale(2.2,1.0,2.2);
templesubmodel[templefloor]->pY = -0.1;


// add all part of the temple to the temple object list
for (i = 0; i < ntemplemodels; i++)	
	templemodel.addobject(templesubmodel[i]); 

// generates the land
templeland = new Model;
templeland->textured = true;
templeland->texture = TID_ATG[6];
genTerrain (*templeland, 20, NULL, 15.0);
templeland->scale(3.0,0.0,3.0);
templeland->pY = -0.4;

// generates the water1
templewater1 = new Model;
templewater1->textured = true;
templewater1->texture = TID_ATG[5];
genTerrain (*templewater1, 32, NULL, 1.0);
templewater1->scale(0.07,1.0,0.07);
//templewater1->pY = 0.00;


for (i = 0; i < nbuildingmodels; i++)
	{
	buildingsubmodel[i] = new Model;
	buildingsubmodel[i]->textured = true;
	buildingsubmodel[i]->texture = TID_ATG[7];
	}

genCone(*buildingsubmodel[bpillar1],12, 3.0, 0.3, 0.3);
buildingsubmodel[bpillar1]->setpos(-1.5,0.0,-15);
genCone(*buildingsubmodel[bpillar2],12, 3.0, 0.3, 0.3);
buildingsubmodel[bpillar2]->setpos( 0,0.0,-15);
genCone(*buildingsubmodel[bpillar3],12, 3.0, 0.3, 0.3);
buildingsubmodel[bpillar3]->setpos( 1.5,0.0,-15);

genCube(*buildingsubmodel[btop]);
buildingsubmodel[btop]->setpos( 0.0,3.0,-15);
buildingsubmodel[btop]->scale(0.20,0.03,0.07);


// add all part of the temple to the temple object list
for (i = 0; i < nbuildingmodels; i++)	
	buildingmodel.addobject(buildingsubmodel[i]); 






/*
// generates the background 
templeback1 = new Model;
templeback1->textured = true;
templeback1->texture = TID_ATG[7];
genCube (*templeback1);
templeback1->scale(0.3,0.2,0.3);
templeback1->pY = 2;
templeback1->pZ = 20.00;
*/

}

GLfloat AmbientLight[4];
GLfloat DiffuseLight[4];
GLfloat LightPosition[4];
GLfloat fogCol[4];
GLfloat clearCol[4];

GLfloat AmbientLight2[4] = { 0.75f, 0.75f, 0.75f, 1.0f };
GLfloat DiffuseLight2[4] = { 1.0f, 1.0f, 1.0f, 1.0f };
GLfloat LightPosition2[4] = { 0.0f, 100.0f, -100.0f, 1.0f };
GLfloat fogCol2[4] = { 0.85f, 0.85f, 0.65f, 1.0f };
GLfloat clearCol2[4] = { 0.85f, 0.85f, 0.65f, 1.0f };

GLfloat AmbientLight1[4] = { 0.6f, 0.16f, 0.0f, 1.0f };
GLfloat DiffuseLight1[4] = { 0.98f, 0.25f, 0.0f, 1.0f };
GLfloat LightPosition1[4] = { 0.0f, 5.0f, -100.0f, 1.0f };
GLfloat fogCol1[4] = { 0.6f, 0.16f, 0.0f, 1.0f };
GLfloat clearCol1[4] = { 0.6f, 0.16f, 0.0f, 1.0f };


void mixlights(float a)
{
float ma = 1.0-a;

for (int i=0;i<4;i++)
	{
    AmbientLight[i] = AmbientLight1[i]*a + AmbientLight2[i]*ma;
	DiffuseLight[i] = DiffuseLight1[i]*a + DiffuseLight2[i]*ma;
	LightPosition[i] = LightPosition1[i]*a + LightPosition2[i]*ma;
	fogCol[i] = fogCol1[i]*a + fogCol2[i]*ma;
	clearCol[i] = clearCol1[i]*a + clearCol2[i]*ma;
	}

glLightfv(GL_LIGHT1, GL_AMBIENT, AmbientLight);
glLightfv(GL_LIGHT1, GL_DIFFUSE, DiffuseLight);
glLightfv(GL_LIGHT1, GL_POSITION, LightPosition); 
glFogfv (GL_FOG_COLOR, fogCol);
glClearColor (clearCol[0],clearCol[1],clearCol[2],clearCol[3]);

}



void init_Temple ()
{     /*
	GLfloat AmbientLight[] = { 0.75f, 0.75f, 0.75f, 1.0f };
	GLfloat DiffuseLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat LightPosition[] = { 0.0f, 100.0f, -100.0f, 1.0f };
*/
glEnable (GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
	glEnable (GL_TEXTURE_2D);
	glDisable (GL_DEPTH_TEST);
	glBindTexture (GL_TEXTURE_2D, TID_LOGO);


	//GLfloat AmbientLight[] = { 0.75f, 0.75f, 0.75f, 1.0f };
	//GLfloat DiffuseLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };
	//GLfloat LightPosition[] = { 0.0f, 100.0f, -100.0f, 1.0f };

	mixlights(0.0);
/*
	GLfloat AmbientLight[] = { 0.6f, 0.16f, 0.0f, 1.0f };
	GLfloat DiffuseLight[] = { 0.98f, 0.25f, 0.0f, 1.0f };
	GLfloat LightPosition[] = { 0.0f, 5.0f, -100.0f, 1.0f };

	glLightfv(GL_LIGHT1, GL_AMBIENT, AmbientLight);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, DiffuseLight);
	glLightfv(GL_LIGHT1, GL_POSITION, LightPosition); 
*/	
	glDisable (GL_LIGHT0);
	glEnable (GL_LIGHT1);
	glEnable (GL_LIGHTING);
	glDisable (GL_BLEND);
	glDisable (GL_TEXTURE_GEN_T);
	glDisable (GL_TEXTURE_GEN_S);
	
	glEnable (GL_FOG);
	glFogf (GL_FOG_START, 0.0);
	glFogf (GL_FOG_END, 50.0);
	//GLfloat fogCol[4] = { 0.85f, 0.85f, 0.65f, 1.0f };
	//GLfloat fogCol[4] = { 0.6f, 0.16f, 0.0f, 1.0f };
	//glFogfv (GL_FOG_COLOR, fogCol);
	
	
	glEnable (GL_DEPTH_TEST);
	//glClearColor (0.85f, 0.85f, 0.65f, 1.0f);
	glClearColor (clearCol[0],clearCol[1],clearCol[2],clearCol[3]);
	glEnable (GL_CULL_FACE);
	glCullFace (GL_BACK);
	glEnable (GL_TEXTURE_2D);

	fov = 60;

	cam.directional = false;
	cam.tgt[0] = 0;
	cam.tgt[1] = 0;
	cam.tgt[2] = 0;
}


void anim_templewater(Model &m)
{
unsigned char plasbuf[32*32];

move_plasma2(plasbuf);

for (int y=0;y<32;y++)
   for (int x=0;x<32;x++)
	  m.vertex[y*32+x].y = plasbuf[y*32+x]/500.0f+(rand()%100)/2000.0f;
      
}




int templefirst = 1;

void part_Templepart ()
{
	static float starttime = time;
	static float lasttime = 0, previoustime = 123;
	static float fa = 1.0;

	static int lastorder = -1;

	static float fade = 0.0;

	float lapsedtime = time - starttime;
	float delta = lapsedtime - lasttime;

	//static int templefirst = 1;
	static float dist = 20.0f;

	//if (templefirst == 1)
	//{
		init_Temple ();
		templefirst = 0;
	//}

	
	mixlights(fade*0.10);

	anim_templewater(*templewater1);

	float stime = time*sin(3.14*time/23);

	dist = 15 -( sin(3.14*time/400)*10* cos(3.14*time/4) );

	cam.pos[0] = (GLfloat)sin(3.14*time/7)*dist;
	cam.pos[1] = 5;//fabs(sin(3.14*stime/37)*10*(GLfloat)cos(3.14*stime/17));
	cam.pos[2] = (GLfloat)cos(3.14*time/7)*dist;

	SetProjection ();

	templemodel.render ();
	buildingmodel.render ();
	templeland->render ();
	//templeback1->render ();

	glEnable(GL_BLEND);
	templewater1->render ();
	glDisable(GL_BLEND);

	if (lapsedtime < 1)
	{
		ledsensmiley (0.0,0.0,0.0,fa);
		fa -= delta;
	}

	if (order == 14)
		{
		if (order == 14 && lastorder != 14)
			{
			previoustime = time;
			lastorder = 14;
			}

		if ( (fade = ((time - previoustime))) > 4.0)
			fa = 4.0;
		}	
}
