#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "globals.h"
#include "system.h"
#include "cubes.h"
#include "keys.h"
#include "objgen.h"
#include "text.h"

void init_Cube ()
{
	GLfloat fogCol[4] = { 0.0f, 0.0f, 0.0f, 1.0f };
	glClearColor (0.0f, 0.0f, 0.0f, 1.0f);
	glFogfv (GL_FOG_COLOR, fogCol);
	cam.directional = false;
	cam.pos[0] = 0;
	cam.pos[1] = 0;
	cam.pos[2] = -120.0f;
	cam.tgt[0] = 0;
	cam.tgt[1] = 0;
	cam.tgt[2] = -150.0f;
	fov = 100;
	genCube (*cube);
	cube->pX = cube->pY = cube->pZ = 0;
	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);
	glEnable (GL_BLEND);
	glDisable (GL_LIGHTING);
	glDisable (GL_TEXTURE_2D);
	glFogf (GL_FOG_START, 200.0);
	glFogf (GL_FOG_END, 400.0);
	cube->textured = false;
	for (int i = 0; i < cube->nVertices; i++)
		cube->vertex[i].a = 0.1f;
}

void part_Cubepart ()
{
	static bool first = true;
	static float starttime = time;
	static float lasttime = 0;
	static GLfloat d = 1.0;
	float lapsedtime = time - starttime;
	float delta = lapsedtime - lasttime;

	static float xr = 0, yr = 0, zr = 0;

	char *creds[10] = {	"code",
						"korona",
						"code",
						"kanttu",
						"music",
						"kenshi",
						"gfx",
						"korupt & kydrox",
						"models",
						"kragen"	};

	int i;

	if (mtime > 2.30)		i = 0;
	if (mtime > 2.35)		i = 1;
	if (mtime > 2.43)		i = 2;
	if (mtime > 2.51)		i = 3;
	if (mtime > 2.59)		i = 4;
	if (mtime > 2.61)		i = 5;
	if (mtime > 3.03)		i = 6;
	if (mtime > 3.11)		i = 7;
	if (mtime > 3.19)		i = 8;
	if (mtime > 3.27)		i = 9;


	xr = (sin(time) + cos(time)) * 0.25 + 1 ;
	yr = -sin(time) * 0.5 + 1 ;
	zr = cos(time) * 0.5 + 1;

	if (first)
	{
		init_Cube ();
		first = false;
	}

	SetProjection ();

	d += delta;

	if (d > 20.0f) d = 20.0f;
	if (d < 1.0f) d = 1.0f;

	glTranslatef (0, 0, -150.0f);
	for (int x = 0; x < 20; x++)
	{
		glPushMatrix ();
			glRotatef (lapsedtime*100.0f, (GLfloat) (sin(x*0.03)+cos(x*0.07))*0.5f, (GLfloat)cos(x*0.08+1), cos(time));
			glScalef ( (GLfloat)(1.0/d*x), (GLfloat)(1.0/d*x), (GLfloat)(1.0/d*x));
			cube->render ();
		glPopMatrix ();
	}

	glColor4f (1.0f, 1.0f, 1.0f, 1.0f);
	glText3D (creds[i], 0, 0, -125, 200);

	lasttime = lapsedtime;
}











