comment	-Ŀ
	     entry for HUGI size coding	competition #10		
  
  
    	    
    		   Taquin Puzzle	     	     
    	     
  
   history:
    99/12/2? start
    99/12/26 first complete and working version:  333 bytes
    99/12/26 330,329,327,326,325,323,322,321,320
    99/12/28 completely rewrote the drawing code: 310 bytes
    99/12/29 309,307,305,304,302,301
    99/12/30 300
    99/12/31 299,298
    00/01/05 297
    00/01/08 296 !!!buggy!!!
    00/01/11 295, finally added a few comments
    00/01/20 291
    00/01/22 290
    00/01/23 289
    00/01/25 287
    00/01/26 286, completely rewrote text output: 280 bytes
    00/01/26 279
    00/01/29 278,277,276,275,273
  
   credits:
    to	claw, for encouraging me to optimize further, and for
    exchanging	some size info.
  
-
.model tiny
.486
.code
.startup
; assume
; ax=??00
; bx=0000
; si=0100
; sp=FFFE
	o	equ	offset

	dec	bx		; bx=FFFF
	inc	bp
	pop	cx		; cx=0,	empty stack (very useful)
	jnb	$+2		; db "KEYs",0
	mov	dx,si		; dx points to file name
initl:	add	al,3		; note that 3*5=-1
	and	al,0Fh		; tile no for slot (x,y) is stored
	push	ax		; at address 11111111111yyxx0b
	jnz	initl		; initialise puzzle
	mov	di,sp		; di points to hole
	mov	ah,3Ch
	int	21h		; create "keys"	file
	xchg	ax,bx		; bx=handle; ax=FFFF
	aad	-14h		; ax=0013h
	int	10h		; set graphics mode

main:	mov	si,sp		; init si, si points to	start of puzzle
	cwd			; dx=0	 direction info	for line
	mov	bp,319		; bp=319 drawing function
	pusha
	mov	di,37*320+97-34*320-96
				; point	to upper left corner of	first slot
puzzl:	lodsw			; get color/number of current tile
	mov	cl,30		; tile width is	30
boxl:	pusha
	mov	cl,30		; tile height is 30, too
	call	line		; draw vertical	line
	popa
	inc	di		; move one pixel to the	right
	loop	boxl		; draw box
	pusha
	scasw			; now, di is advanced by 32, af	is cleared
digitl:	push	0A000h+48*20+5	; segment for lower digit half ("ring")
	push	0A000h+41*20+5	; segment for upper digit ring
	mov	bx,o digits
	aaa			; calculate digits (ah=0/1, al=0..9)
	xlat			; get digit bitmask
	mov	bh,07h		; !!!warning: requires 273 bytes entry!!!
;	 mov	 bx,0707h	 ; line	lengths	(+1) for ring
halfd:	pop	es		; get segment for ring
ringl:	ror	ax,1		; get info for current bar (cf=0 -> set)
				; is executed exactly 8	times per digit	(!)
	push	ax
	mov	cl,bl		; cl=line length+1
	db	214		; salc
	and	al,es:[di+bp]	; calculate line color
				; the +bp was added to make the	drawing	of
				; the center line more flexible
	call	linex		; draw line, sets cf in	4th loop
	pop	ax
	xchg	bh,bl		; swap vertical/horizontal line	length
	jnz	ringl		; do full ring
	inc	bx
	jpo	halfd		; 08:po, 09:pe,	clears af
	lea	di,[di-10]	; update di for	second digit
	das			; cf is	set, af	is cleared
	js	digitl		; check	whether	digit (-> negative) or
				; digit	bitmask	(->non-negative)
	mov	di,bp		; mov di,35*320+95-34*320-96
				; upper	left corner of border
	mov	al,7		; al=border color
bordl:	mov	cl,129		; draw border...the code is here because
	call	line		; I need ES=0A2AE for the scasw	below
	jnz	bordl		; border is drawn 16 times...who cares?
	popa
	and	bx,ax		; after	this instruction, and after the
				; empty	field was drawn, bx contains the
				; current slot number if and only if all
				; already drawn	fields are in the correct
	inc	bx		; position
	scasw			; check	whether	we hit the border
	jnc	puzzl		; finish row of	slots
	add	di,316*32	; go to	next row
	jns	puzzl		; finish grid
	test	bx,sp		; (sp=-48 here)	test whether bx=16, i.e.
	popa			; test for winning position (bx<=16 is sure)

	mov	si,o @num	; used for counting and	in the exit code
	jnz	quit		; print	text if	player won

	int	16h		; read a key (ah is already 0)
	mov	cl,1		; write	one byte
	mov	ah,40h
	push	ax
	mov	dx,sp		; dx=FF3E
int21:	int	21h
	pop	ax		; write	key to the "keys" file

	sub	ax,4032h	; sets ah=0 (al>=32h) or ah=FFh	(otherwise)
	jpe	ud		; cl=3 for '2' or '8' (and some	other keys)
badmove:test	al,not 6	; test for '2','4','6','8', clears cf.
	jne	badkey		; not a	move ->	check for exit
	and	al,2
	dec	ax		; ax=-1	('4' and '8') or ax=1 ('2' or '6')
	shl	ax,cl		; calculate offset '2':8,'4':-2,'6':2,'8':-8
	xchg	ax,bp		; bp = offset; ax=319
	lea	dx,[di+bp]	; ax = new hole	position
	xor	dx,di		; dx = modified	bits
ud:	inc	cx
	inc	cx		; advance cl by	2 (bit width of	coordinate)
	shr	dx,cl		; check	for invalid move, i.e. check whether
	jnz	badmove		; bits above the x(y)-coordinate were modified.
	xchg	dl,[di+bp]
	mov	[di],dl		; update puzzle
	lea	di,[di+bp]	; update hole pointer
countl:	mov	al,[si]		; inc counter: get digit
	inc	ax		; inc digit by one
	aaa			; calculate carry, set upper nibble = 0(!)
	mov	[si],al		; store	digit
badkey:	dec	si		; update si (set si=@num-1 if badkey)
	jc	countl		; do next digit	if carry
	aad	32-50		; ' ' pressed?,	set ah=0
	jne	main		; no ->	next loop

quit:	mov	al,3		; ah is	already	0
	int	10h		; set text mode
	mov	al,o @num-o @win; here,	si points to @num (win), or to
				; @num-1 (quit)...let si point to @win [-1]
moveptr:sub	si,ax		; update si
printl:	lodsb			; get one character
	add	al,30h
	jo	int21		; 68h is end marker -> quit (ah=0,int 21h)
	cbw			; ah=0 for chars; sign extend delta
	jle	moveptr		; if delta, update si
	int	29h		; else print char
	jmp	printl		; do next char

	Y	equ	30h
; format of the	following data:
; D1..4F: a character (01..7F) (00..09 are digits)
; 50..7F: end of text marker (sets OF on add al,30h)
; 80..D0: next character is read at current position+1 + (50..00)

@quit:	db	o @win-o @lose-Y
@win:	db	'W'-Y,'i'-Y,'n'-Y,'n'-Y,'i'-Y,'n'-Y,'g'-Y
	db	' '-Y,'f'-Y,'i'-Y,'e'-Y,'l'-Y,'d'-Y
	db	o @lose-o @after-Y
@lose:	db	'Y'-Y,'o'-Y,'u'-Y,' '-Y,'h'-Y,'a'-Y,'v'-Y
	db	'e'-Y,' '-Y,'q'-Y,'u'-Y,'i'-Y,'t'-Y
@after:	db	' '-Y,'a'-Y,'f'-Y,'t'-Y,'e'-Y,'r'-Y,' '-Y
	db	4 dup (-Y)
@num:	db	0
	db	' '-Y,'m'-Y,'o'-Y,'v'-Y,'e'-Y,'s'-Y,13-Y,10-Y
				; opcode (68) is used as end marker
line:	push	0A000h+34*20+6	; init screen segment for frame	and box
	org	$-2		; this saved one byte, the code	from here is
linex:	org	$+2		; scasb	(skip on byte),	mov [AA07],al and
				; then the add di,bp is	executed.
	pop	es
linel:	stosb			; set one pixel
	add	di,bp		; update di
	loop	linel

	xchg	bp,dx		; rotate direction by 90 degree
	not	dx		; +-> dx=  0,bp=319 -> dx=-321,bp=   0	-+
	dec	dx		; +-  dx=319,bp= -2 <- dx=  -2,bp=-321 <-+
	ret

ddigit	macro	b0,b1,b2,b3,b4,b5,b6
	db	not (0*128+b5*64+b6*32+b4*16+b0*8+b2*4+b3*2+b1*1)
endm

digits:	ddigit	1,1,1,0,1,1,1	; 0   
	ddigit	0,0,1,0,0,1,0	; 1  	0  
	ddigit	1,0,1,1,1,0,1	; 2  1	  2
	ddigit	1,0,1,1,0,1,1	; 3  	3  
	ddigit	0,1,1,1,0,1,0	; 4  
	ddigit	1,1,0,1,0,1,1	; 5  	   
	ddigit	1,1,0,1,1,1,1	; 6  4	  5
	ddigit	1,1,1,0,0,1,0	; 7  	6  
	ddigit	1,1,1,1,1,1,1	; 8   
	ddigit	1,1,1,1,0,1,1	; 9

end
