// Faster symbol difference encoding, very bad over all, extremely slow and
// doesn't achieve very good compression, the main reason is its difference
// encoding:
// correct prediction = byte number 0
// incorrect prediction = random byte.
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include "FileIO.H"

const int BLOCK_SIZE = 200;
const int HOW_MANY_PROBES = 4096;
const int CONTEXT_ORDER = 25;

Files Data;
int *Probes[256], UsedProbes[256];
char CodingState;

void Transform(char *Block, int BlockLength);
void ClearProbes();

int main(int argc, char **argv)
{                             
   if(argc < 3)
   {
      cout << "Specify I/O files on command line.";
      return 0;
   }
   Data.Open(argv[1], argv[2]);
   if(Data.IOStatus != IO_OK)
   {
      if(Data.IOStatus == INPUT_ERROR) cout << "Could not read input file.";
      else cout << "Could not read output file.";
      return 0;
   }
   cout << "Decode? 'd': ";
   cin >> CodingState;
   cout << "Using block size of " << BLOCK_SIZE << 'K' << endl;
   cout << "Allocating " << ((HOW_MANY_PROBES << 10) / (float) (1 << 20)) << "MB for fast context searching.\n\n";

   int BlockLength = BLOCK_SIZE << 10;
   char *Block = new char[BlockLength];
   int InputLength = Data.GetLength();                
   float Blocks = InputLength / (float) BlockLength;
   int HowManyBlocks = (int) Blocks, Remainder = 0;
   if(HowManyBlocks != Blocks) Remainder = (Blocks - HowManyBlocks) * BlockLength;

   for(int i = 0; i < 256; i++) Probes[i] = new int[HOW_MANY_PROBES];
   ClearProbes();

   for(i = 0; i < HowManyBlocks; i++, cout << '\r')
   {
      cout << "Transforming Block [" << i + 1 << "] of " << HowManyBlocks;
      Data.Input.read(Block, BlockLength);
      Transform(Block, BlockLength);
      ClearProbes();
   }
   if(Remainder)
   {
      if(HowManyBlocks) cout << endl;
      Data.Input.read(Block, Remainder);
      cout << "Transforming last block: " << Remainder << " bytes long.";
      Transform(Block, Remainder);
   }
   delete [] Block;
   for(i = 0; i < 256; i++) delete [] Probes[i];
   return 0;
}               

void Transform(char *Block, int BlockLength)
{
   int i, j, Offset = 0, Longest, SearchOffset, UsedOrder = 1;
   char Predicted = 0, Context[CONTEXT_ORDER + 2];
   Data.Output.put(Block[Offset++]);

   while(Offset < BlockLength)
   {
      if(UsedOrder < CONTEXT_ORDER - 1) UsedOrder++;
      for(i = 1; i <= UsedOrder; i++)
         Context[UsedOrder - i] = Block[Offset - i];
      Context[UsedOrder] = '\0';
      char HighestOrderByte = Context[UsedOrder - 1];
      char C = Block[Offset];
      for(Longest = 0, i = 0; i < UsedProbes[HighestOrderByte]; i++)
      {
         SearchOffset = Probes[HighestOrderByte][i];
         if(SearchOffset == Offset - 1) continue;
         char *BlockPtr = Block + SearchOffset;
         char *ContextPtr = Context + UsedOrder - 1;
         for(j = 0; j < UsedOrder; j++)
            if(*BlockPtr-- != *ContextPtr--) break;
         if(j > Longest)
         {
            Longest = j;
            Predicted = Block[SearchOffset + 1];
            if(j == UsedOrder) break;
         }
      }
      Data.Output.put((char) (Predicted - C));
      if(CodingState == 'd')
      {
         C = Predicted - C;
         Block[Offset] = C;
      }
      for(i = UsedProbes[C]; i >= 1; i--) Probes[C][i] = Probes[C][i - 1];
      Probes[C][0] = Offset;
      if(UsedProbes[C] < HOW_MANY_PROBES - 1) UsedProbes[C]++;
      Offset++;
   }
   return;
}
                      
void ClearProbes()
{
   for(int i = 0; i < 256; i++) memset(Probes[i], -1, HOW_MANY_PROBES << 2);
   memset(UsedProbes, 0, 1024);
   return;
}
