
// -*- C++ -*-
//
// $Id: dynamic_linker.cc,v 1.2 2000/03/30 18:15:34 alcibiade Exp $
//
// Copyleft (c) 2000, Brioche/Aspirine <brioche@linuxbe.org>
// 
// A C++ wrapper to Linux dynamic linker programming interface 
//



#include "dynamic_linker.h"



Dynamic_linker::Dynamic_linker() : _handle(0)
{
}



Dynamic_linker::Dynamic_linker(const char* filename)
{
  Dynamic_linker::open(filename); 
}



Dynamic_linker::~Dynamic_linker() 
{
  Dynamic_linker::close();
}



void Dynamic_linker::open(const char* filename)
{
  if ((_handle = dlopen(filename, RTLD_NOW)) == 0)
    throw exception(dlerror());
}



void Dynamic_linker::close()
{
  if (_handle == 0)
    return;
  if (dlclose(_handle))
    throw exception(dlerror());
  _handle = 0;
}



void* Dynamic_linker::resolve(const char* symbol)
{
  void* ref;
  if ((ref = dlsym(_handle, symbol)) == 0)
    throw exception(dlerror());
  return ref;
}



