;
;                                                                             
;           A program for text to morse and morse to text conversion          
;                                   for                                       
;                              HUGI COMPO #8                                  
;                                                                             
;

; For the program specification refer to the rules pack.


        assume  ds:_TEXT,cs:_TEXT
_TEXT   segment
                .386
                org     100h

cmov = 0 ;CMOVcc instruction support ( > 0 - supported, = 0 - not supported )
         ;if supported it helps save a byte

; A morse symbol is called packed if it is encoded in a byte so that:
;  - '.' is coded by 1, '_' by 0;
;  - the data bits are left justified the first being the leftmost;
;  - after the last data bit follows a 1 bit called a stop bit;
;  - the bits to the right of the stop bit are all zero.
;
; Examples:
; 74h = 01110100b is packed morse for CR (_.._)
; 86h = 10000110b is packed morse for ' (.____.)
; B6h = 10110110b is packed morse for ` (._.._.)

; Both in T-M and M-T a separator is output as a prefix to the following
; symbol. The start symbols have no prefix.

BOM = 01010100b         ;packed begin of message _._._
EOM = 10101100b         ;packed end of message ._._.

; Throughout the whole program ch = 0.

        start:  std                     ;reverse lookup
                call    get_ch0         ;read a char from STDIN in al
                je      decode_nxt      ;e, al = '_' - file is a morse (maybe)


; ENCODE TEXT TO MORSE 
; On entry: al = 1st char of text;
;           ah = 0;
;           dh = 5fH ('_');
;           bx = 100h.
;
                mov     cl,BOM          ;output BOM with no prefix
                call    putsym          ;!!! LF encoded as nul at 10Ah

; Main loop point for text to morse encoding.

        encode_nxt:                     ;cx = 0 at that point except after BOM
                                        ;ah = 0, dl = prefix for current symbol
                cmp     al,20h          ;word separator?
                je      getch           ;!!! 'je' (opcode 74h) encodes CR at 10Dh
                xlat                    ;encode next char to packed morse
                xchg    ax,cx           ;cl = packed morse code
                mov     ah,40h-5fh      ;force a symbol prefix for next symbol
        getch:  call    putget0         ;output the prefix + morse symbol
                                        ;and get a char from STDIN
                jcxz    encode_nxt      ;cxz - not EOF yet

; Append EOM to the Morse file and exit to DOS

                mov     dl,0            ;clear dl (so awkward)
                mov     cl,EOM          ;cl = packed EOM ('._._.')
                                        ;fall down to output EOM and exit to DOS
                                        ;will read past EOF on STDIN

; Output a sequence of a prefix and a morse symbol and read a char 
; On entry: ah = prefix for the next symbol-5fh (0 or 40h-5fh);
;           dl = prefix to be output-5fh (0 or 40h-5fh);
;           cl = packed morse symbol (cx = 0 if LF or space was encoded);
;           dh = 5Fh;
; On exit:  get_ch0 is called, so the exit conditions for it apply;
;           in particular dl = prefix for the next symbol;
;
        putget0:jcxz    get_ch0         ;LF or Space in T-M
                add     dl,dh           ;dl = 40h or 5fh, Z flag is cleared

; Output a sequence of a prefix and a symbol and read a char 
; On entry: ah = prefix for the next symbol;
;           dl = prefix to be output, if dl = 0, no prefix is output;
;           cx = ascii code of decoded morse symbol;
;           cx = 0 if morse symbol was not decoded (in particlar BOM or
;            uncomplete). If cx = 0 nothing is output;
;           Z flag is set if morse code decoded (i.e. cx > 0);
;           dh = 40h;
; On exit:  get_ch1 is called, so the exit conditions for it apply;
;           in particular dl = prefix for the next symbol;
;
        putget1:jcxz    get_ch1         ;skip BOM and uncomplete chars in M-T
                push    offset get_ch0  ;thus 'ret' = 'jmp get_ch0'
                jne     putsym          ;ne - coming form T-M
                xchg    dh,cl           ;dh = char, cl = 40h
                                        ;!!! 'xchg' (opcode 86h) encodes '

; Entry for BOM in T-M. !!! Must preserve ax and dx.

        putsym: pusha
                jmp     putc            ;disrupt to accomodate the table

; The actual table start is 100h. The codes LF, CR and ' are encoded as part
; of the instructions.

        db      00110010b       ;,  2c           __..__                 0
        db      01111010b       ;-  2d           _...._                 1
        db      10101010b       ;.  2e           ._._._                 2
        db      01101100b       ;/  2f           _.._.                  3
        db      00000100b       ;0  30           _____                  4
        db      10000100b       ;1  31           .____                  5
        db      11000100b       ;2  32           ..___                  6
        db      11100100b       ;3  33           ...__                  7
        db      11110100b       ;4  34           ...._                  8
        db      11111100b       ;5  35           .....                  9
        db      01111100b       ;6  36           _....                  0
        db      00111100b       ;7  37           __...                  1
        db      00011100b       ;8  38           ___..                  2
        db      00001100b       ;9  39           ____.                  3
        db      00011110b       ;:  3a           ___...                 4
        db      01010110b       ;;  3b           _._._.                 5

; A valuable hole
        cup:    and     al,01011111b ;convert char in al to upper case.` becomes @    6,7
                                ;but is correctly handled both in M-T and T-M
                ret             ;                                       8

        db      11001110b       ;?  3f           ..__..                 9
        db      10110110b       ;decodes `       ._.._.                 0
        db      10100000b       ;A  41   a  61   ._                     1
        db      01111000b       ;B  42   b  62   _...                   2
        db      01011000b       ;C  43   c  63   _._.                   3
        db      01110000b       ;D  44   d  64   _..                    4
        db      11000000b       ;E  45   e  65   .                      5
        db      11011000b       ;F  46   f  66   .._.                   6
        db      00110000b       ;G  47   g  67   __.                    7
        db      11111000b       ;H  48   h  68   ....                   8
        db      11100000b       ;I  49   i  69   ..                     9
        db      10001000b       ;J  4a   j  6a   .___                   0
        db      01010000b       ;K  4b   k  6b   _._                    1
        db      10111000b       ;L  4c   l  6c   ._..                   2
        db      00100000b       ;M  4d   m  6d   __                     3
        db      01100000b       ;N  4e   n  6e   _.                     4
        db      00010000b       ;O  4f   o  6f   ___                    5
        db      10011000b       ;P  50   p  70   .__.                   6
        db      00101000b       ;Q  51   q  71   __._                   7
        db      10110000b       ;R  52   r  72   ._.                    8
        db      11110000b       ;S  53   s  73   ...                    9
        db      01000000b       ;T  54   t  74   _                      0
        db      11010000b       ;U  55   u  75   .._                    1
        db      11101000b       ;V  56   v  76   ..._                   2
        db      10010000b       ;W  57   w  77   .__                    3
        db      01101000b       ;X  58   x  78   _.._                   4
        db      01001000b       ;Y  59   y  79   _.__                   5
        db      00111000b       ;Z  5a   z  7a   __..                   6


; Read a byte from STDIN 
; On entry: ch = 0;
;           ah = prefix for the next symbol;
; On exit:  cx > 0 - EOF on STDIN;
;           cx = 0 - a byte is read form STDIN in al;
;           Z is set if al = 5F;
;           ah = 0;
;           bx = 100h;
;           dh = 5fh ('_');
;           di - tblend (offset 160h).
;
        get_ch0:mov     dl,ah           ;set prefix for the next symbol
                                        ;zero dl on first call
        get_ch1:mov     di,offset tblend+1 ;di - '_' (5F) byte
        tblend: mov     dh,'_'          ;!!! 'mov' (opcode B6) encodes `
                xor     bx,bx           ;STDIN handle = 0
                mov     cl,1            ;cx = 1 to read
                mov     ah,3fh          ;1 char
                int     21h             ;from STDIN
                sub     cl,al           ;cx > 0 if EOF and = 0 if not
                mov     bh,1            ;bx = 100h
                mov     si,dx           ;si - where the data byte is stored
                lodsb                   ;get the byte
                scasb                   ;is it a lower case letter?
                ja      cup             ;a, yes - go convert it to upper
                ret


; DECODE MORSE TO TEXT 
; On entry: al = 1st char of morse file;
;           Z flag is set if the 1st char = '_';
;           ah = 0;
;           bx = 100h.
;-
        decode_nxt:
                mov     dh,40h          ;fake a morse symbol

; At that point: dh = 40h, dl = 0 or 40h, ah = 0,
; al = 10 (LF), 13 (CR), 20h (Space), 2eh ('.'), 2fh ('/'), 5fh ('/').
; A previous scasb (cmp al,5fh) has been executed.

                je      shiftin         ;e, al = '_' - continue assembly
                add     al,-' '         ;set C if al >= 20h
                ja      getcod          ;a, al contains LF or CR - ignore it
                jnp     shiftin         ;np, al = '.' - continue assembly

; The instruction CMOVcc helps to save a byte in that case. However it is not
; supported on all Pentium processors.

if cmov
                db      0fh,45h,0c2h    ;= cmovne ax,dx
else
                je      eosym           ;e, al = ' '
                mov     ax,dx           ;set prefix for the next symbol
endif

; Note that C is set at that point - it ensures the stop bit.

        eosym:  rcl     byte ptr[bx],1  ;left justify - shift until
                jnc     eosym           ;start bit comes out
                xchg    al,[bx]         ;get packed morse symbol

;[100h] is use to assemble the packed morse symbol. After the xchg instruction
;[100h] = 0 or 40h. In case 40h, bit 6 is shifted out before the end of the symbol.

; Decode the packed morse symbol in al. Find the highest ASCII which yields the
; same packed morse code when encoded. When decoding BOM, at that point al = 55h
; which is not found within [100h..160h].
; DI - tblend (160h), std executed.

                mov     cl,61h          ;get in cl the ascii code
                                        ;comes with C set to set initially
                                        ;a bit for left justification tracking

; Continue assembly of the morse symbol

        shiftin:rcl     byte ptr[bx],1  ;shift-in the next bit
                repne   scasb           ;try to locate a matching morse symbol

; Output prefix and symbol. Get a new char from STDIN.
; At that point: dh = 40h. This permits to use the same output routine in both
; directions. Note that Z flag is set if the morse code is decoded;

        getcod: call    putget1         ;output the prefix and symbol
                                        ;and get next char from STDIN
                jcxz    decode_nxt      ;cxz - not EOF yet
                ret                     ;EOM does not terminate legally - it is
                                        ;ignored and preceding '/' also

; Second part of output symbol routine (disrupted just before the bulk of the
; table). cl = packed morse symbol, dh = '_' or the text symbol.

        putc:   shr     dl,1            ;Note that 5fH/2 = 2fH = '/'
                jz      skip            ;skip nul prefices
        puts:   mov     ah,6            ;write to STDOUT code
                int     21h             ;and write
                mov     dl,10           ;assume a CR was output
                cmp     al,13           ;DOS has copied dl in al
                je      puts            ;eq, need to output a LF as well

        skip:   shl     cl,1            ;extract next bit into C
                mov     dl,dh           ;dl = either '_' or the symbol in M-T
                ja      puts            ;a - output what is in dh
                mov     dl,'.'          ;else change to dot
                jne     puts            ;ne, more bits to unpack
                popa
                ret
_TEXT ends
                end     start
