; program for the 8. hugi-size-competition
;
; written July 1999 by Hubsi
;
; 4th entry, 249 bytes


[BITS 16]
[ORG 0x0100]

%define invalid_char 01000000b
; write this morse-code for invalid input text characters "......"


mybegin       equ  ";"+1
myend         equ  ";"+2

[SECTION .text]

    mov       si,write_char

main:
; the main_program
    call      read_char
    cmp       al,"_"
    je        morse2text_gate_1

text2morse:
; encodes the stdinput to morse
; dh holds the state of the encoder: " "=in word, "/"=between words
    push      ax
    mov       al,mybegin
    mov       dh,"/"
    call      write_morse_nosep
    pop       ax
text2morse_1:
    cmp       al," "
    jne       text2morse_2
    mov       dh,"/"
    jmp       short text2morse_4
text2morse_2:
    mov       dl,dh
    mov       dh," "
    call      write_morse_code
text2morse_4:
    call      read_char
    jz        text2morse_ende
    cmp       al,13
    je        text2morse_4
    cmp       al,"a"
    jb        text2morse_1
    and       al,$0df
    jmp       short text2morse_1
text2morse_ende:
    mov       dl,"/"
    mov       al,myend

write_morse_code:
; writes the morse_code of the char in al to stdoutput
; invalid codes may cause large output files
; (65536 points per char), but the program doesn't crash ;-)
    call      si        ; write seperator
write_morse_nosep:
    mov       bx,table_start
    xlatb
    mov       cl,7
write_morse_code_1:
    shl       al,1
    jc        write_morse_code_2
    loop      write_morse_code_1
write_morse_code_2:
    mov       dl,"."
    shl       al,1
    jnc       write_morse_code_3
    mov       dl,"_"
write_morse_code_3:
    call      si
table_start:
    loop      write_morse_code_2  ;2 bytes
    ret                           ;1 byte

write_char:
; writes the char in dl to stdoutput
; 7 bytes
    pusha
    mov       ah,6
    int       $21
    popa
    ret
                db      00110001b       ; <LF>  = "_..._"

read_char:
; returns a character from stdinput in al, ZF->eof
; 24 bytes
    pusha
    mov       ah,$3f
    mov       bx,0
    mov       cx,1
    mov       dx,read_char_1 + 1
    int       $21
    cmp       al,0
    popa
read_char_1:
    mov       al,$33
    jz        read_char_2
    cmp       al,26
read_char_2:
recycled_ret:
    ret
morse2text_gate_1:
    jmp       short morse2text_gate_2
                db      invalid_char
                db      invalid_char
                db      01011110b       ; "'"   = ".____."
                db      invalid_char
                db      invalid_char
                db      invalid_char
                db      invalid_char
		db	01110011b	; ,	= "__..__"
		db	01100001b	; -	= "_...._"
		db	01010101b	; .	= "._._._"
		db	00110010b	; /	= "_.._."
		db	00111111b	; 0	= "_____"
		db	00101111b	; 1	= ".____"
		db	00100111b	; 2	= "..___"
		db	00100011b	; 3	= "...__"
		db	00100001b	; 4	= "...._"
		db	00100000b	; 5	= "....."
		db	00110000b	; 6	= "_...."
		db	00111000b	; 7	= "__..."
		db	00111100b	; 8	= "___.."
		db	00111110b	; 9	= "____."
		db	01111000b	; :	= "___..."
		db	01101010b	; ;	= "_._._."
                db      00110101b       ; <BEGIN> = "_._._"
                db      00101010b       ; <END>   = "._._."
                db      invalid_char
		db	01001100b	; ?	= "..__.."
                db      invalid_char
		db	00000101b	; A	= "._"
		db	00011000b	; B	= "_..."
		db	00011010b	; C	= "_._."
		db	00001100b	; D	= "_.."
		db	00000010b	; E	= "."
		db	00010010b	; F	= ".._."
		db	00001110b	; G	= "__."
		db	00010000b	; H	= "...."
		db	00000100b	; I	= ".."
		db	00010111b	; J	= ".___"
		db	00001101b	; K	= "_._"
		db	00010100b	; L	= "._.."
		db	00000111b	; M	= "__"
		db	00000110b	; N	= "_."
		db	00001111b	; O	= "___"
		db	00010110b	; P	= ".__."
		db	00011101b	; Q	= "__._"
		db	00001010b	; R	= "._."
		db	00001000b	; S	= "..."
		db	00000011b	; T	= "_"
		db	00001001b	; U	= ".._"
		db	00010001b	; V	= "..._"
		db	00001011b	; W	= ".__"
		db	00011001b	; X	= "_.._"
		db	00011011b	; Y	= "_.__"
		db	00011100b	; Z	= "__.."
morse2text_gate_2:
    mov       bl,1
    std
    jmp       short morse2text_1
table_end       db      01010010b       ; `     = "._.._."

morse2text_1:
;decodes the morse-code fom stdinput to stdoutput
; bh ="/" => write " " before writing char
    mov       ah,al
    cmp       al," "
    je        char_fertig
    cmp       al,"/"
    je        char_fertig
    shr       al,1
    adc       bl,bl
next_loop:
    call      read_char
    jz        recycled_ret ; EOF
    cmp       al,13
    jle       next_loop          ; skip CR/LF
    jmp       short morse2text_1 ; continue reading
char_fertig:
    cmp       bl,00110101b       ; <BEGIN>
    je        next_char          ; skip
    cmp       bl,00101010b       ; <END>
    je        recycled_ret       ; exit program
    mov       al,bl
    mov       di,table_end
    mov       cx,table_end-table_start+1
    repne     scasb              ; search for code in table
    cmp       bh,"/"
    jne       char_fertig_2
    mov       dl," "
    call      si
char_fertig_2:
    cmp       cl,10              ; NL
    jne       char_fertig_3
    mov       dl,13
    call      si
char_fertig_3:
    mov       dl,cl
    call      si
    mov       bh,ah
next_char:
    mov       bl,1
    jmp       short next_loop
