;ķ
; Chris Dragan's entry for Hugi Size Coding Competition #8		     
; Version 9 (25.07.99), 187 bytes, intended for compiling with NASM	     
; Chris Dragan's Corner is at http://ams.ampr.org/cdragan/		     
;Ľ

org 100h

%define BOM	 35h
%define EOM	 2Ah
%define EOM_char 12h
%define CR	 0Dh
%define LF	 0Ah

;Encode-text

		; Get character
			xor	ax, 0600h ; opcode 35h - for BOM
_slash: 		mov	dl, '/'
_skip_chara:		call	GetInput
			jz	_not_eof
			mov	al, EOM_char
			mov	dl, '/'
_not_eof:		cmp	al, ' '
			je	_slash
			cmp	al, LF
			je	_skip_chara

		; Convert character to Morse symbol
			cmp	al, '_'
			je	_decode_Morse
			jb	_no_locase    ; ` a b ... z
			sub	al, 'a'-'A'
_no_locase:		mov	bx, MorseTable-','
			xlatb
			xchg	[si], al

		; Display Morse symbol
			mov	cl, al
			bsr	cx, cx
			ror	al, cl
_next_bit_out:		rol	al, 1
			pusha
			mov	dl, '_'
			jc	_dash
			mov	dl, '.'
_dash:			int	21h
			popa
			xor	di, di ; opcode 31h - for CR (1 byte wasted)
			loop	_next_bit_out
			cmp	al, EOM
			je	_return

		; Display separator
			int	21h
			mov	dl, ' '
			jmp	short _skip_chara

;GetInput

		; Get a character from input
GetInput:		pusha
			sub	bx, bx
			mov	cl, 1
			mov	ah, 3Fh
			lea	dx, [bx-6]
			int	21h
			pop	si ; opcode 5Eh - for ' sign
			push	si ; 1 byte wasted
			dec	ax	; zf=0 if EOF
			popa
_return:		ret

;Data

;			 db 31h
;times 25		 db    0
;			 db 5Eh
;times 4		 db    0

			;    ,	  -    .    /	 0    1    2	3
MorseTable		db 73h, 61h, 55h, 32h, 3Fh, 2Fh, 27h, 23h
			db 21h, 20h, 30h, 38h, 3Ch, 3Eh, 78h, 6Ah

_decode_Morse:		std
			jmp	short _next_bit_in ; 2 bytes wasted

;times 3		 db    0

			;    ? (@)`    A    B	 C    D    E	F
			db 4Ch, 52h, 05h, 18h, 1Ah, 0Ch, 02h, 12h
			db 0Eh, 10h, 04h, 17h, 0Dh, 14h, 07h, 06h
			db 0Fh, 16h, 1Dh, 0Ah, 08h, 03h, 09h, 11h
			db 0Bh, 19h, 1Bh, 1Ch
;times 5		 db    0
;			 db 52h

;Decode-Morse

		; Bit-encode symbol
_next_bit_in:		shr	al, 1		; first time al is 5Fh
			rcl	bl, 1		; first time bl is 00h
			mov	dl, 52h ; dummy mov for ` sign (1 byte wasted)
_next_chara:		call	GetInput
			jnz	_return
			cmp	al, 0Eh
			jb	_next_chara	; skip CR and LF
			jnp	_next_bit_in	; for SPC and / pf=1

		; Find symbol in table
			xchg	ax, bx
			mov	di, MorseTable-','+'`'
			mov	cl, '`'+1
		  repnz scasb
			cmp	al, 15h
			xchg	ax, bx
			je	_next_symbol

		; Print space if previous symbol ended with '/'
			xchg	al, bh
			cmp	al, '/'
			jne	_no_separator
			mov	dl, ' '
			int	21h
_no_separator:
		; Print character
			mov	dl, cl
_once_again:		int	21h
_next_symbol:		mov	bl, 01h

		; End of line
			mov	dl, LF
			cmp	al, CR
			je	_once_again
			jmp	short _next_chara

;End-Of-File
; ķ
;ֽStatisticsķ
; Packed table          46 
; Input identification   4 
; Text encoding         64 
; Text decoding         53 
; GetInput()	         15 
; Wasted	          5 
;Ķ
; Total	        187 
;Ľ
