
segment code
assume cs:code,ds:code,es:code,ss:stak
start:
.486
 mov bl,ds:[80h]
 mov bh,0
 add bl,81h
 mov [bx],bh
 mov ax,3d00h
 mov bx,0
 mov cx,0
 mov dx,82h
 int 21h
 jc exitprog
 mov bx,ax
 push cs
 push cs
 pop ds
 pop es
 mov ax,3f00h
 mov cx,768
 mov dx,offset palette
 int 21h
 push ds
 mov ax,video
 mov ds,ax
 mov fs,ax
 mov ax,3f00h
 mov cx,64000
 mov dx,0
 int 21h
 pop ds

 mov si,offset palette+3
 mov di,si
 mov bp,1
 mov cx,100h-1
xform:
 xor eax,eax
 lodsb
 mov ah,[si]
 inc si
 bswap ax
 lodsb
 test eax,eax
 jz emptyentry
 inc bp
 bswap ax
 stosb
 mov [di],ah
 inc di
 bswap ax
 stosb
emptyentry:
 loop xform
 inc bp
 mov ax,bp
;    mov al,0E8h
 mov numcolors,al

 mov bp,offset GREENREG-base+11
 mov GREENFIX_1,bp
 mov bp,offset BLUEREG-base+11
 mov BLUEFIX_1,bp



 mov si,0
 mov di,0

 mov ax,3c00h
 mov bx,0
 mov cx,0
 mov dx,offset outfile
 int 21h
 mov bx,ax
 mov ax,4000h
 mov cx,offset endprog-offset init
 mov dx,offset init
 int 21h
 push bx


 mov di,offset outbuf
 mov curbit,0
 mov bh,9
compressy:
 mov bl,42-42
compressx:
 mov al,160
 mul bh
 shl ax,1
 add al,bl
 adc ah,0
 mov bp,ax
 add bp,42
 mov ah,0

 mov al,fs:[bp-1]
 sub al,fs:[bp-2]
 add al,fs:[bp-1]

 cmp al,fs:[bp]
 jnz outputfull
 mov cl,1
 mov al,80h
 call writebits
 jmp outputtt
outputfull:
 mov cl,1
 mov al,0
 call writebits
 mov al,fs:[bp]
 mov cl,8
 call writebits
outputtt:
 inc bl
 cmp bl,269-42
 jnz compressx
 mov bl,42-42
 inc bh
 cmp bh,145
 jnz compressy

 mov cx,di
 sub cx,offset outbuf
 mov ax,4000h
 pop bx
 mov dx,offset outbuf
 int 21h

 mov ah,3eh
 int 21h

exitprog:
 mov ax,4c00h
 int 21h

writebits:      ; di ->
 push ax
 push bx
 push cx
 cmp curbit,0   ; new byte
 jnz setbit
 mov byte ptr es:[di],0
setbit:
 shl al,1
 setb al
 mov cl,7
 sub cl,curbit
 shl al,cl
 or byte ptr es:[di],al
 inc curbit
 cmp curbit,8
 jnz nonew
 mov curbit,0
 inc di
nonew:
 pop cx
 pop bx
 pop ax
 shl ax,1
 dec cl
 jnz writebits
 ret

curbit db ?



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

base equ offset init-100h

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    init:
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

 mov al,13h
 int 10h

@@makepal:
 mov al,-2
 mov di,offset endprog-base+30000
 mov cl,14
@@m1_1:             ; 0..13
 add al,2
   ; stosb
   ; stosb
     mov ah,al          ; ah=green, al=red
 stosw
 stosb
 loop @@m1_1
    ; mov ah,al          ; ah=green, al=red
 mov bl,al          ; bl=blue
 mov si,offset table2-base
@@m1_2:
 mov cl,17
 call pal_1         ; 14..30

 dec byte ptr [offset GREENREG]     ; self modifying code, swap add regs
  ORG $-2
  GREENFIX_1 dw 1234h
 inc byte ptr [offset BLUEREG]      ; green/blue then blue/green
  ORG $-2
  BLUEFIX_1 dw 1234h
 mov cl,25
 call pal_1         ; 31..55

 mov dh,0
 mov dl,[si]
 mov bp,56
 call do3           ; 56..111

 sub al,10
 sub ah,23          ; not combined in case of half-carry
 add bl,9

 mov bp,223-112+1   ; 112..223
 call do3_a

 sub al,10
 add ah,7
 sub bl,18
 mov cl,1
 call storepal      ; 224
 sub al,6
 mov bp,6
 mov dl,0
@@lastfew:          ; 225..230  ( palette shortened to 0..230 )
 sub ah,8
 add ah,dl
 sub bl,5
 add bl,dl
 not dl             ; alternate between -8/-9 and -5/-6
 mov cl,1
 call storepal
 sub al,7
 dec bp
 jnz @@lastfew


 mov bp,25          ; 25 entries
 call correctpal

 mov ax,1012h
     mov cl,12h
     org $-1
     numcolors db 0
 xor bx,bx
 mov dx,offset endprog-base+30000
 int 10h
donepal:
 mov bh,0a0h
 mov es,bx

; drawer...

 mov si,offset table1-base-1
 mov di,155*320+14
 mov dx,di
 call block1
 add dx,4
 mov bp,[si]
 mov bx,509h
drawblocks:
 dec bl
 jnz db1_1
 inc si
 mov bp,[si]
 mov bl,8
 dec bh
 jz db1_2
db1_1:
 add dx,8
 shl bp,1
 jnc drawblocks
 mov di,dx
 call block1
 jmp drawblocks
db1_2:


 mov di,153*320+24
 mov si,offset table4-base
 mov cx,3
@@tops:
 mov bp,8
 lodsb
@@tops_1:
 shl al,1
 jnc @@notops_1
 pusha
 mov si,offset table5-base
 mov dl,[si]
 mov dh,0
 mov bp,15
@@splining:
 push di
 call spline1
 pop di
 dec bp
 jnz @@splining
 add di,4*320+2
 mov al,0
 stosb
 sub di,320
 stosb
 sub di,320
 mov cl,7
@@dark_top_horiz:
 stosb
 mov al,0E6h
 loop @@dark_top_horiz
 add di,27*320-11
 mov bp,17
@@s2:
 push di
 call spline1
 pop di
 dec bp
 jnz @@s2
 add di,3*320-319
 mov cl,4
 xor ax,ax
@@blacken:
 add di,319
 stosb
 mov es:[di+13],al
 loop @@blacken
 stosw
 stosb
 mov es:[di+8],ax
 mov es:[di+10],al
 sub di,320+3
 stosb
 mov es:[di+11],al
 sub di,320-4
 mov al,0E4h
 stosb
 stosb
 stosb

 popa
 @@notops_1:
 add di,16
 dec bp
 jnz @@tops_1
 loop @@tops

 mov si,offset table6-base
 mov bl,4
@@blackening:
; mov di,[si]
; inc si
; inc si
 lodsw
 xchg ax,di
 mov cl,[si]
 inc si
 call blackbox
 dec bx
 jnz @@blackening

 mov si,offset table7-base
 mov bp,4
bottoming:
 lodsw
 xchg ax,di
 mov bl,[si]
 inc si
 call hline
 dec si
 dec bp
 jnz bottoming

 mov si,offset table8-base
 mov bp,2
bottoming2:
 lodsw
 xchg ax,di
 mov bl,[si]
 inc si
 call hlinew
 dec si
 dec bp
 jnz bottoming2

 mov di,186*320+126
 mov ax,0E4E4h
 call store8
 mov di,186*320+302
 call store8
 mov ax,0E6E6h
 mov di,155*320+10
 call store4
 mov di,155*320+18
 call store4
 mov di,155*320+158
 call store8
 mov di,187*320+126
 mov ax,0E3E3h
 call store8
 mov di,187*320+302
 call store8

 mov cx,10
 mov si,offset tableA-base
 mov di,156*320+120
@@extra:
 mov ax,0E2h
 stosb
 lodsb
 add di,ax
 loop @@extra





 mov si,offset table9-base
 mov cx,numpixs
 call replace

 mov bx,offset table9b-base
 mov bp,numrectcopys
 push es
 pop ds
copying:
 mov si,cs:[bx]
 inc bx
 inc bx
 mov cl,cs:[bx]
 inc bx
 mov di,cs:[bx]
 inc bx
 inc bx
@@copy2:
 push cx
 and cl,0Fh
 mov ax,320
 sub ax,cx
 rep movsb
 pop cx
 add si,ax
 add di,ax
 sub cl,10h
 jnb @@copy2
 dec bp
 jnz copying
 push cs
 pop ds

 mov si,offset table9_2-base
 mov cl,numpixs2
 call replace

; mov di,16*320+68          ; stupid method didn't work as well as I want..
; mov si,offset tableB-base ; need better than 4:1  ;)
; mov dl,[si]
; mov dh,0
; mov al,1
; mov bp,99
; call realspline
;
; mov di,14*320+118
; mov si,offset tableB2-base
; mov dl,[si]
; mov dh,0
; mov al,1
; mov bp,2
; call realspline

 mov si,offset endprog-base
 mov dl,[si]
 mov dh,0

 mov bh,9
compressy2:
 mov bl,42-42
compressx2:
 push bx
 mov al,160
 mul bh
 shl ax,1
 add al,bl
 adc ah,0
 mov di,ax
 add di,42

 mov al,es:[di-1]
 sub al,es:[di-2]
 add al,es:[di-1]

 mov cl,1
 call getbits
 cmp bh,1
 jz match
 mov cl,8
 call getbits
 mov al,bh
match:
 stosb

 pop bx
 inc bl
 cmp bl,269-42
 jnz compressx2
 mov bl,42-42
 inc bh
 cmp bh,145
 jnz compressy2

quit:
 xor ax,ax
 int 16h
 mov ax,3
 int 10h
 ret



;huffman:        ; di, si, bx, cx
; push cx
; xor bp,bp
;@@gethufbits:
; mov cx,1
; call getbits
; shr bh,1
; pushf
; adc bp,0
; popf
; jc @@gethufbits
; shl bp,1
; add bp,bx
; mov al,[bp]
; stosb
; pop cx
; loop huffman
; ret


;realspline:     ; bitstream determines go-on-iness
;                ; si, di, ax=col, bp=numrows
; mov cl,2
; call getbits
; mov bl,bh      ; bl=num in row
; push di
;@@getsplines:
; push bx
; mov cl,5
; call getbits
; mov ah,bh
; mov cl,2
; call getbits
; shr bh,1
; jnc @@nodrawspline
; mov bl,1
; mov al,1
; shr bh,1
; jc @@drawing
; mov al,13
; neg bl
;@@drawing:      ; for ah pixels
; mov cl,1
; call getbits
; shr bh,1
; jc @@gotcolor
; add al,bl
; jmp @@drawing
;@@gotcolor:
; stosb
; dec ah
; jnz @@drawing
;
;@@nodrawspline:
; pop bx
; push ax
; shr ax,8
; add di,ax
; pop ax
; dec bl
; jnz @@getsplines
; pop di
; mov cl,3
; call getbits
; shl bx,5           ; if ya couldn't figure it out by now, this sign extends
; sar bx,13          ;  5 bits of bh into all of bx
; add di,320
; add di,bx
; dec bp
; jnz realspline
; ret

replace:
 lodsw
 xchg ax,di
 lodsb
 stosb
 loop replace
 ret

hlinew:
 mov cl,[si]
 inc si
 mov ax,0E0h
 stosb
 inc ax
 call v2
 stosb
 inc ax
 rep stosb
 inc ax
 stosb
 dec ax
 call v2
 lodsb
 add di,ax
 dec bx
 jnz hlinew
 ret

v2:
 mov byte ptr es:[di+319],al
 mov byte ptr es:[di+639],al
 ret

;drawline:       ; bh=y,bl=x -> ,ah=+y,al=+x, dl=color
; mov cl,al
; mov ch,0
; div al     ; al=dy*256
; xchg al,dh ; dh=
;@@goingdrawline:
; inc bl
; add ch,dh
; adc bh,0
; mov al,160
; mul bh
; shl ax,1
; add al,bl
; adc ah,0
; xchg ax,bp
; mov es:[bp],dl
; dec cl
; jnz @@goingdrawline
; ret

hline:
 mov cl,[si]
 inc si
 mov ax,0E3h
 stosb
 dec ax
 rep stosb
 inc ax
 stosb
 lodsb
 add di,ax
 dec bx
 jnz hline
 ret

pal_1:          ; interpret 3/3/2 packed palette, modifiable, cx
 mov dl,[si]
 inc si
 mov bh,dl
 sar bh,5
 add al,bh
 mov bh,dl
 shl bh,3
 sar bh,5
; add ah,bh
 db 0
;  ORG $-1
  GREENREG db 0FCh      ; FC -> FB = add bl,bh
 and dl,11b
; add bl,dl
 db 0
;  ORG $-1
  BLUEREG db 0D3h       ; D3 -> D4 = add ah,dl
storepal:
 stosb
 mov [di],ah
 inc di
 mov [di],bl
 inc di
 loop pal_1
 ret

do3:
 call do5
 add al,bh
 call do5
 add ah,bh
 call do5
 add bl,bh
 mov cl,1
 call storepal
 dec bp
 jnz do3
 ret

do3_a:
 call do5
 add bh,1
 add al,bh
 call do5
 add ah,bh
 call do5
 add bh,2
 add bl,bh
 mov cl,1
 call storepal
 dec bp
 jnz do3_a
 ret

do5:
 mov cl,3
 call getbits
 shl bh,5
 sar bh,5
 ret

correctpal:     ; si -> buffer, bp=numentries
 mov si,offset table3-base
 mov dh,0
 mov dl,[si]
@@correcting:
 mov cl,8
 call getbits
 shr bx,8

 lea di,[bx+offset endprog-base+30000]
 shl bx,1
 add di,bx

 call do4
 mov al,bh
 call do4
 mov ah,bh
 call do4
 sub bh,3
@@run:
 add [di],al
 inc di
 add [di],ah
 inc di
 add [di],bh
 inc di
 cmp di,offset endprog-base+230*3+30000
 jbe @@run
 dec bp
 jnz @@correcting
 ret

do4:
 mov cl,4
 call getbits
 shl bh,4
 sar bh,4
 ret

getbits proc    ; si -> buffer, dh=bitstart, cx=numbits, ret: bh=bits
 mov bh,0
@@getbits:
 shl dl,1
 rcl bh,1
 inc dh
 and dh,111b
 jnz @@gotbit
 inc si
 mov dl,[si]
@@gotbit:
 loop @@getbits
 ret
endp

    ; table1 : gradient of letters (5 bytes)
table1 db 11110011b,11111000b,10111100b,11111111b,11100000b


    ; table2 : compressed differential palette, 3/3/2 bits (17 bytes)
table2 db 00000010b,01000000b,00001000b,00000010b,00001000b,01011000b
       db 00001000b,11010011b,01001000b,00001000b,01100000b,00001100b
       db 10110010b,00001000b,00010010b,00011111b,00100101b

    ; switch to red/blue/green format now (25 bytes)

       db 11110010b,01101000b,00010010b,10101000b,01100000b,00001000b
       db 10110011b,01100000b,01000000b,10001000b,01100000b,01000000b
       db 11001000b,01000000b,00010010b,11001000b,01000000b,11001000b
       db 01000000b,01000000b,11011010b,01000000b,11001000b,01000000b
       db 01000010b

    ; 3/3/3 bits... eww... (63 bytes)

       db 00010001b,00001000b,10000010b,00000011b,00100010b,10000001b
       db 01011011b,00000100b,00011100b,01011100b,00010000b,10111110b
       db 01000000b,10010000b,01001010b,00011111b,00111000b,00010000b
       db 01011000b,00000100b,00110110b,01000001b,00000101b,10000110b
       db 00001000b,10010000b,01111010b,00001010b,00000000b,10010110b
       db 01000001b,01000000b,00010110b,00001001b,00000001b,00010100b
       db 01000000b,01100000b,10010000b,00011000b,10100110b,00101111b
       db 11101100b,00010010b,00001001b,00001011b,00000000b,10010110b
       db 10000011b,10110100b,01111000b,01011011b,01000110b,00010110b
       db 00100000b,11110101b,01001000b,00100000b,00110110b,10100111b
       db 11101100b,10110010b,10000000b

    ; 3/3/3 bits... weird... -3 to 4, -4 to 3, -2 to 5; (126 bytes)

       db 11100011b,00011100b,11111010b,11011000b,01100010b,01011000b
       db 11101001b,10101011b,11000000b,10101011b,10010011b,01110000b
       db 00000001b,01001110b,00111001b,00010110b,00001100b,00001010b
       db 00111100b,11111010b,10111000b,10000111b,01100000b,10110111b
       db 00001000b,10001101b,11011100b,00011111b,11100111b,01001110b
       db 00000100b,01101110b,00101111b,01111001b,11111011b,01111010b
       db 00000111b,00001100b,01111011b,11001011b,01000000b,10000110b
       db 10100011b,10101101b,11010110b,00111011b,01110101b,10111000b
       db 01000100b,01001110b,00000000b,00110000b,01110001b,01011101b
       db 11100111b,10011101b,00111000b,00011101b,01001110b,00000001b
       db 10011011b,10101001b,11001000b,11000010b,00000000b,01001000b
       db 00110100b,01011111b,01110111b,11101110b,10110000b,00000011b
       db 10101010b,00010001b,10001000b,11010101b,01101100b,11110110b
       db 01000001b,11111101b,01000000b,00100011b,01010101b,00001000b
       db 11010100b,00000010b,00110101b,01010011b,10000000b,00001100b
       db 11000100b,01110101b,01101000b,11100111b,11100110b,00110001b
       db 11000111b,10111101b,01100000b,00100011b,01100101b,10010010b
       db 10010101b,11100000b,00001001b,00111000b,00101101b,11000000b
       db 11101011b,01110101b,10101110b,00111101b,01011110b,00000101b
       db 01011001b,11001101b,10011101b,11000111b,11010101b,00111000b
       db 00000100b,01101010b,10110111b,01011010b,10101100b,01000110b


    ; table3 : fixup for palette (63 bytes)
table3 db 00011010b,00001111b,00110010b,10001111b,00000011b,00111000b
       db 10101001b,00110100b,01100000b,00000010b,01010111b,00000000b
       db 00010110b,00100000b,00000001b,01100110b,00000000b,01100111b
       db 00110000b,01101001b,01110111b,11001001b,00110111b,11100000b
       db 01011000b,10000010b,00000101b,00111000b,01011011b,10110011b
       db 10001100b,10010100b,10001001b,10101010b,10100011b,10101000b
       db 10000101b,10001010b,10110000b,01000011b,10101100b,01010000b
       db 11011010b,11110000b,10110011b,10110110b,00001000b,00111100b
       db 00100000b,01000011b,11000100b,00001010b,10101100b,10110000b
       db 00000000b,11001111b,11001010b,00111101b,00100000b,10000011b
       db 11011101b,01100000b,11110000b


    ; table4 : roundness of letters (3 bytes)
table4 db 11011100b,01001101b,10000000b

    ; table5 : splined horizontal gradient of top of letters (24 bytes)
    ;    y   x   l l  b  r
    ;   000 0100 1 11 01 0
    ;   000 1000 0 10 01 1
    ;   001 0010 1 10 10 1
    ;   001 1001 1 10 01 1
    ;   010 0001 1 01 11 1
    ;   010 1011 1 01 01 1
    ;   011 0001 0 01 10 1
    ;   011 0110 1 01 01 1
    ;   011 1100 1 01 01 0
    ;   100 0000 1 01 10 0
    ;   100 0101 1 01 01 1
    ;   100 1100 1 01 01 1
    ;   101 0000 0 01 10 1
    ;   101 0010 1 00 10 0
    ;   110 0000 0 01 10 0

table5 db 00001001b,11010000b,10000100b,11001001b,01101010b,01100111b
       db 00110100b,00110111b,10101011b,10101101b,10001001b,10101101b
       db 10101011b,01111001b,01010100b,00001011b,00100010b,11010111b
       db 00110010b,10111010b,00000110b,11010010b,10010011b,00000001b
        ; 100b... continued...

    ; splined horizontal gradient of bottom of letters (28 bytes)
    ;    y   x   l l  b  r
    ;   000 1000 0 01 10 0
    ;   001 1000 0 01 10 0
    ;   001 0000 0 01 01 1
    ;   010 0000 1 01 01 0
    ;   010 0110 0 01 10 1
    ;   010 0111 1 01 11 0
    ;   010 1101 0 01 01 1
    ;   011 0001 0 01 01 1
    ;   011 0110 1 01 11 1
    ;   011 1100 1 01 01 0
    ;   100 0001 1 01 01 1
    ;   100 1011 1 01 01 1
    ;   101 0010 1 10 01 1
    ;   101 0101 1 11 00 1
    ;   101 1001 1 10 01 1
    ;   110 0100 1 11 01 0
    ;   110 1000 0 10 01 1

       db 10000010b,00001100b,00110000b,01100001b,00000010b,11010000b
       db 01010100b,10011000b,11010100b,11110111b,00101101b,00101101b
       db 10001001b,01101101b,10101111b,01111001b,01010100b,00011010b
       db 11100101b,11010111b,01001011b,00111010b,10111100b,11011001b
       db 11001111b,00100111b,01011010b,00010011b


    ; table6 : black filled in areas (12 bytes)
table6 dw 163*320+80+3
       db 178-163+1
       dw 163*320+240+3
       db 178-163+1
       dw 163*320+224+3
       db 168-163+1
       dw 173*320+216+3
       db 177-173+1


    ; table7 : fill in [-++++-] lines of letters (40 bytes)
table7 dw 188*320+12
       db 8
       db 5,120-12-5-2,13,152-120-13-2,5,184-152-5-2,5,192-184-5-2
       db 5,248-192-5-2,5,256-248-5-2,5,296-256-5-2,13
       dw 185*320+126
       db 2
       db 7,302-126-7-2,7
       dw 162*320+80
       db 3
       db 5,224-80-5-2,5,240-224-5-2,5
       dw 156*320+8
       db 3
       db 3,18-8-3-2,3,158-18-3-2,7

    ; table8 : fill in [X++++-] lines of letters with subs (24 bytes)
table8 dw 153*320+8
       db 7
       db 12,120-8-12-3,4,152-120-4-3,12,184-152-12-3,8,248-184-8-3,4
       db 256-248-4-3,4,296-256-4-3,4
       dw 178*320+216
       db 3
       db 4,320-216+80-4-3,4,240-80-4-3,4

pix macro x,y,c
 dw y*320+x
 db c
endm

    ; table9 : total replacement of pixels (33 bytes)
table9 label byte
       pix 80,182,0E2h
       pix 240,182,0E2h
       pix 80,184,0E1h
       pix 240,184,0E1h
       pix 229,183,0E4h
       pix 224,184,0E1h
       pix 224,182,0E2h
    numpixs equ ($-offset table9)/3
table9_2 label byte
       pix 190,156,0E3h
       pix 190,172,0E3h
       pix 197,170,0E4h
       pix 254,169,0E3h
       pix 255,169,0E1h
       pix 254,172,0E3h
       pix 222,171,0
    numpixs2 equ ($-offset table9_2)/3


rect macro x,y,w,h
 dw y*320+x
 db h*16+w
endm

    ; table9a : rectangle replacement of pixels
table9a label byte



rectcopy macro x,y,w,h,xx,yy
 dw y*320+x
 db (h-1)*16+w
 dw yy*320+xx
endm

    ; table9b : rectangle copies (10 bytes)
table9b label byte
    rectcopy 152,186,1,2,134,186
    rectcopy 152,186,1,2,310,186
    rectcopy 232,183,7,6,216,167
    rectcopy 240,153,7,5,224,169
    rectcopy 161,153,6,4,158,169
    rectcopy 166,153,1,4,158,169
    rectcopy 154,170,4,2,254,170
    rectcopy 250,170,5,2,158,170
    rectcopy 174,153,9,10,190,153
    rectcopy 190,156,3,3,190,172
    rectcopy 186,169,4,3,190,169
    rectcopy 175,182,2,4,191,166
    rectcopy 176,181,1,2,190,168
    rectcopy 169,184,3,4,196,170
    rectcopy 181,184,2,3,197,169
    rectcopy 272,182,1,3,256,167
    rectcopy 245,179,2,1,255,172
    rectcopy 236,188,4,1,218,167
    rectcopy 228,153,3,3,218,168
    rectcopy 235,168,4,1,219,168
    rectcopy 234,169,3,1,220,169
    rectcopy 234,170,4,1,221,170
    rectcopy 225,153,2,2,222,168
    rectcopy 223,155,4,3,223,171
    rectcopy 242,166,3,6,225,172
    rectcopy 215,183,2,2,228,173

    numrectcopys equ ($-offset table9b)/5

    ; tableA : extra fillings of top of non-curved surfaces (9 bytes)
tableA db 126-120-1,152-126-1,184-152-1,248-184-1,254-248-1,256-254-1
       db 262-256-1,296-262-1,302-296-1


    ; tableB : splines of gradients on HUGI letters aura
    ;
    ; programming the realspline function:
    ;   Start:
    ;       2 number of data streams in row
    ;           5 length of stream
    ;           1 0=reverse, 1=forward
    ;           1 0=skip, 1=draw
    ;               1 0=increment, 1=go
    ;       3 signed horizontal offset
    ;
    ;   hope ya can read binary cause I sure can
    ;
    ;   off nr +len+ f d ____________________data____________________
    ;   ---
    ;       01 01000 1 1 11111111
    ;   101
    ;       10 01010 1 1 110110111111
    ;          00100 0 1 011011
    ;   110
    ;       10 01010 1 1 110101011010111
    ;          00111 0 1 011010101101
    ;   110
    ;       10 01101 1 1 11010101010101011111
    ;          00111 0 1 01010101010101
    ;   111
    ;       10 01110 1 1 110101010010101001101111
    ;          01000 0 1 001010100101010101
    ;   111
    ;       10 01111 1 1 110100101010010100101011111
    ;          01000 0 1 01001001010010100101
    ;   000
    ;       11 01010 1 1 1010010100101001010101
    ;          00101 0 0
    ;          01000 0 1 10100100100101001001
    ;
    ;
    ;
    ;
    ;
    ;



huff macro w,h,x,y
 db w,h
 dw y*320+x
endm

    ; tableC : hugi pic huffmanish rectangles (ick)
tableC label byte
;    huff 16,15,55,16
;    huff 11,26,52,31
;    huff 11,18,49,57
;    huff 12,15,45,75
;    huff 9,25,44,90
;    huff 17,8,53,107
;    huff 12,5,60,84
;    huff 10,12,64,90
;    huff 23,9,71,87
;    huff 9,25,94,87
;    huff 15,8,103,104
;    huff 14,6,108,98
;    huff 10,13,113,85
;    huff 5,9,123,84


;startfill:          ; expect di,al
; mov ah,es:[di]
;fill:               ; expect di,al,ah (and I'm lazy for recursion)
; push di
;; cmp sp,01000h
;; jb @@donefill     ; we'll just assume =)
; cmp es:[di],ah
; jnz @@donefill
; stosb
; call fill
; dec di
; dec di
; call fill
; sub di,319
; call fill
; add di,640
; call fill
;@@donefill:
; pop di
; ret

blackbox:       ; cx
 xor ax,ax
 call store7
 jnz blackbox
 ret

spline1:
 mov cl,3
 call getbits
 mov al,160
 mul bh
 shl ax,1
 add di,ax
 mov cl,4
 call getbits
 shr bx,8
 add di,bx
 call @@tryend
 mov cl,2
 call getbits
 mov bl,bh
 mov cl,2
 call getbits
 mov al,0E3h
 sub al,bh
@@middle:
 cmp bl,0
 jz @@tryend
 dec bl
 stosb
 jmp @@middle
@@tryend:
 mov cl,1
 call getbits
 mov al,0E4h
 shr bh,1
 jnc @@noend
 stosb
@@noend:
 ret

block1:
 pusha
 sub di,320*1+2-3*320
 mov al,0E2h
 mov cx,183-150+1-3
block1_1a:
 stosb
 add di,5
 stosb
 add di,320-7
 loop block1_1a
 popa
 mov ax,0E7E7h
 mov cl,7
b1_1:
 sub ax,101h
 call store4
 jnz b1_1
 mov cl,4
b1_2:
 call store4
 jnz b1_2
 mov cl,6
b1_3:
 add ax,101h
 call store4
 jnz b1_3
 add di,320*12
 mov cl,4
b1_4:
 dec di
 stosb
 call store4
 pushf
 sub ax,101h
 popf
 jnz b1_4
 ret

store8:
 stosw
 stosw
store7:
 sub di,3
 stosb
 stosw
store4:
 stosw
 stosw
 add di,320-4
 dec cx
 ret

endprog:

 outfile db 'ENTRY.COM',0
 hndl1 dw ?
 hndl2 dw ?

 palette db 768 dup(?)
 outbuf db 50000 dup(?)
ends
segment video
 db 64000 dup(?)
ends
segment stak stack
 db 1000h dup(?)
ends
end start
