;
;
; 	           Lame and VERY late LZ packer by TAD 1999
;
; This is a very simple variation on the LZ77 algo.
;
; compile:
;	TASM late
;	TLINK late			<--- an .EXE file !!!
;
; run:
;	late
;

	.386

INT_DOS 	equ 	<int 21h>
INT_VIDEO	equ	<int 10h>
INT_KEYB	equ	<int 16h>

ADJ	= 4096				; adjustment for the BT, BTR, BTS !!

NULLBYTE	equ	00h
HUGISIZE	equ	64768-(320*10)
BITMAPSIZE	equ	(HUGISIZE/8)

;** LZ stuff **

MIN_MATCH	equ	2
MAX_MATCH	equ	16384

MIN_OFFSET	equ	1
MAX_OFFSET	equ	16384

COUNT_TAIL	equ	00102h			; 00102h
OFFSET_TAIL	equ	0FF05h			; 0FF05h

;

imageseg SEGMENT PARA USE16
	db	64000 dup (?)
	db	768 dup (?)
imageseg ENDS

;

entryseg SEGMENT PARA USE16
	assume CS:entryseg, DS:entryseg, SS:entryseg
	org	100h

depackstart:
	mov	al, 13h			; VGA mode 13h
	INT_VIDEO

	sub	ebp,ebp			; bitstream pos

	;; decode palette ;;

	mov	ax,0A000h
	mov	ES,ax
	mov	di,(10*320)		; [ES:DI] --> screen

	jmp	short dp_next
dp_raw1:
	mov	cl,6
	cmp	di,64000		; 6 bits for palette...
	jae	short dp_SLY
	mov	cl,3			; 3 bits for TOO COOL...
	cmp	di,(153*320)
	jae	short dp_SLY
	mov	cl,8			; 8 bits for HUGI part
dp_SLY:
	mov	al,(248 SHR 3)
	call	getbits_AL
	stosb
dp_next:
	cmp	di,(64768)
	jae	short dp_done

	call	nextbit
	jc	short dp_raw1		; '1' prefix ?

	mov	bx,COUNT_TAIL
	call	decodetail
	add	ax,MIN_MATCH
	push	ax			; get <length> field

	mov	bx,OFFSET_TAIL
	call	decodetail
	add	ax,MIN_OFFSET
	neg	ax
	xchg	ax,bx
	pop	cx
dp_COPY:
	mov	al,ES:[di+bx]
	stosb
	loop	dp_COPY
	jmp	short dp_next
dp_done:

	;; set palette ;;

	mov	dx,3C8h
	sub	ax,ax
	out	dx,al
	inc	dx
	push	ES
	pop	DS
	mov	si,64000
	mov	cx,768
	rep	outsb

	;; reuse TOO COOL letters ;;

	mov	bp,(8*4)
dp_REP:
	mov	si,coollist-4[bp]
	mov	di,coollist-2[bp]
	mov	ax,36
dp_CLET:
	mov	cx,15
	rep	movsb
	add	si,320-15
	add	di,320-15
	dec	ax
	jnz	short dp_CLET

	sub	bp,4
	jnz	short dp_REP

	INT_KEYB			; wait for key

	mov	ax, 0003h
	INT_VIDEO			; text mode 3 
	ret

decodetail:
	mov	cl,bl
dp_extend:
	call	nextbit
	jnc	short getbits
	add	bl,bh
	add	cl,bl			; extend...
	jmp	short dp_extend
getbits:
	sub	ax,ax
getbits_AL:
	call	nextbit
	adc	ax,ax
	dec	cl
	jnz	short getbits_AL
	ret

nextbit:
	bt	dword ptr cs:[bitstream],ebp
	inc	ebp
	ret

coollist	dw	24+(153*320),	40+(153*320)	; 'O'
		dw	24+(153*320),	88+(153*320)	; 'O'
		dw	24+(153*320),	104+(153*320)	; 'O'
		dw	24+(153*320),	168+(153*320)	; 'O'
		dw	24+(153*320),	264+(153*320)	; 'O'
		dw	24+(153*320),	280+(153*320)	; 'O'
		dw	72+(153*320),	232+(153*320)	; 'C'
		dw	120+(153*320),	296+(153*320)	; 'L'

bitstream	dd	?
		db	50000 dup (?)		; ** room for bitstream !! **

entryseg ENDS


;

packer SEGMENT PARA USE16
	ASSUME CS:packer, DS:packer, SS:packer
	.386
start:
	mov	ax,entryseg
	mov	FS,ax			; [FS:xxxx] --> "ENTRY.COM"
	mov	ax,imageseg
	mov	GS,ax			; [GS:xxxx] --> "HUGI.RAW" image

	mov	ax,packer
	mov	DS,ax
	mov	SS,ax
	mov	sp,offset stacktop

	lea	dx,titletxt
	mov	ah,9
	int	21h

	lea	dx,rawfilename
	mov	ax,3D00h
	INT_DOS
	jc	quit2    		; open file   ** NOTE: nice far JC **
	xchg	ax,bx

	push	DS
	mov	dx,imageseg
	mov	DS,dx
	mov	dx,64000
	mov	cx,768
	mov	ah,3Fh
	INT_DOS				; read palette

	sub	dx,dx
	mov	cx,64000
	mov	ah,3Fh
	INT_DOS				; read image
	pop	DS
	cmp	ax,cx
	jnz	quit

	mov	ah,3Eh
	INT_DOS				; close file

;---------------------------- remap the image -------------------------------

;;	call	remapit

	call	clearlets

;---------------------- pack the entire image + palette ---------------------

	sub	ebp,ebp			; bitstream pos.

	push	DS
	push	ES
	mov	ax,imageseg
	mov	DS,ax
	mov	si,(10*320)		; [DS:SI] --> src
	mov	ES,ax			; [ES:xxx] --> src

	sub	dx,dx			; Num of bytes already packed.
	mov	cx,64768-(10*320)	; remaining

	mov	dx,320			; pretend we've already done 1 line
packlp:
	call	findlz
	add	dx,ax
	add	si,ax
	sub	cx,ax
	jnz	short packlp  		; advance by (AX) bytes
	pop	ES
	pop	DS

	add	ebp,7
	shr	ebp,3
	add	bp,(offset bitstream)-100h
	mov	SS:[entrysize],bp



;------------------------- create the ENTRY.COM file ------------------------

	lea	dx,entryfilename
	sub	cx,cx
	mov	ah,3Ch
	INT_DOS		  		; create file
quit2:	jc	short quit
	xchg	ax,bx

	push	DS
	mov	ax,entryseg
	mov	DS,ax
	mov	dx,100h
	mov	cx,SS:[entrysize]
	mov	ah,40h
	INT_DOS		  		; save "ENTRY.COM"
	pop	DS
	jc	short quit
	cmp	ax,cx
	jnz	short quit

	mov	ah,3Eh
	INT_DOS	      			; close file
	jc	short quit

	lea	dx,okaytxt
	mov	ah,9
	INT_DOS
	mov	ax,4C00h
	INT_DOS
quit:
	lea	dx,errortxt
	mov	ah,9
	INT_DOS
	mov	ax,4CFFh
	INT_DOS

;---------------------- Find & encode longest LZ match ----------------------
findlz:
	sub	ax,ax
	mov	SS:[bestcount],ax

	mov	bx,dx
	cmp	bx,MAX_OFFSET
	jb	short @@clipoff
	mov	bx,MAX_OFFSET		; clip max search offset backwards
@@clipoff:
	neg	bx

	mov	ax,[si]
@@find:
	cmp	ax,[si+bx]
	jnz	short @@next		; no 2-byte match ?

	push	si
	push	di
	push	cx
	cmp	cx,MAX_MATCH
	jbe	short @@cliplen
	mov	cx,MAX_MATCH		; clip max match-length
@@cliplen:
	lea	di,[si+bx]
	repz	cmpsb
	mov	ax,si
	pop	cx
	pop	di
	pop	si
	sub	ax,si
	dec	ax			; (AX) = match count

	cmp	ax,SS:[bestcount]
	jb	short @@worse
	mov	SS:[bestcount],ax	; keep best count
	mov	SS:[bestoffset],bx	; keep best offset
@@worse:
	mov	ax,[si]
@@next:
	inc	bx
	jnz	short @@find		; check each & every offset value

	push	cx
	mov	bx,SS:[bestcount]
	test	bx,bx
	jz	short @@raw1		; no match found ?

	call	output_0		; "0"	prefix

	mov	ax,bx
	sub	ax,MIN_MATCH
	mov	bx,COUNT_TAIL		; BX = 0102h
	call	encodetail		; encode <length> field

	mov	ax,SS:[bestoffset]
	neg	ax
	sub	ax,MIN_OFFSET
	mov	bx,OFFSET_TAIL		; BX = FF05h
	call	encodetail		; encode <offset> field

	mov	ax,SS:[bestcount]	; advance by best count
	jmp	short @@done		


@@raw1:
	call	output_1		; "1"	prefix

	mov	cl,6
	cmp	si,64000
	jae	short @@slyraw
	mov	cl,3
	cmp	si,(153*320)
	jae	short @@slyraw
	mov	cl,8
@@slyraw:
	mov	al,[si]
	call	putbits			; xxxxxxxx	raw byte

	mov	ax,1			; advance by 1 byte
@@done:
	pop	cx
	ret

;* Encode(AX) using 0-tail *
encodetail:
	push	bx
	push	dx
	mov	cl,bl
@@extend:
	mov	dx,1
	shl	dx,cl
	cmp	ax,dx
	jb	short @@fits		; will(AX) fit in (BL) bits ?
	call	output_1
	add	bl,bh			; nope, increment (BL) by (BH)
	add	cl,bl
	jmp	short @@extend
@@fits:
	call	output_0		; signal end of tail ('0' bit)

	call	putbits			; encode(AX)
	pop	dx
	pop	bx
	ret

output_0:
	btr	FS:[bitstream],ebp
	inc	ebp
	ret

output_1:
	bts	FS:[bitstream],ebp
	inc	ebp
	ret
	

;* Put(AX) bits(CL) into bitstream[FS].(edi) *
putbits:
	ror	ax,cl
putnextbit:
	btr	FS:[bitstream],ebp	; assume bit = 0
	add	ax,ax
	jnc	short putzero
	bts	FS:[bitstream],ebp	; else bit = 1
putzero:
	inc	ebp
	dec	cl
	jnz	short putnextbit
	ret

;---------------- remap the image to save a few more bits... ----------------
remapit:
	mov	si,768
	mov	cx,64000
remap1:
	mov	al,GS:[si]
	cmp	al,0
	jz	short @@wrt
	add	al,8
@@wrt:
	mov	GS:[si],al
	inc	si
	loop	remap1

	;; build the new palette ;;

	mov	di,64768
	mov	word ptr GS:[di],0
	mov	byte ptr GS:[di+2],0
	add	di,3

	mov	si,(249*3)
	mov	cx,(8*3)
remap2:
	mov	al,GS:[si]
	inc	si
	mov	GS:[di],al
	inc	di
	loop	remap2

	mov	si,(1*3)
	mov	cx,(247*3)
remap3:
	mov	al,GS:[si]
	inc	si
	mov	GS:[di],al
	inc	di
	loop	remap3
	ret

;---------------- clear reused TOO COOL letter ----------------
clearlets:
	lea	bp,clearlist
	mov	dx,8
cl_LET:
	mov	bx,[bp+2]
	mov	ax,36
cl_ZAPO:
	push	bx
	mov	cx,15
cl_ZERO:
	mov	byte ptr GS:[bx],0
	inc	bx
	loop	cl_ZERO
	pop	bx
	add	bx,320
	dec	ax
	jnz	short cl_ZAPO

	add	bp,4
	dec	dx
	jnz	short cl_LET
	ret

clearlist	dw	24+(153*320),	40+(153*320)	; 'O'
		dw	24+(153*320),	88+(153*320)	; 'O'
		dw	24+(153*320),	104+(153*320)	; 'O'
		dw	24+(153*320),	168+(153*320)	; 'O'
		dw	24+(153*320),	264+(153*320)	; 'O'
		dw	24+(153*320),	280+(153*320)	; 'O'
		dw	72+(153*320),	232+(153*320)	; 'C'
		dw	120+(153*320),	296+(153*320)	; 'L'


entrysize	dw	?

bestcount	dw	?
bestoffset	dw	?

titletxt	db	13,10,'Very lame & late LZ packer for Hugi Compo #7'
		db	13,10,"by TAD, (damn that deadline... )"
		db	13,10
		db	13,10,'Packing: HUGI.RAW'
		db	13,10,'$'

rawfilename	db	'HUGI.RAW',0
okaytxt		db	13,10,'Okay!$'
errortxt	db	'**ERROR** ',13,10,'$'

entryfilename	db	'ENTRY.COM',0


newpalt		db	768 dup (?)

		dw	400 dup (?)
stacktop	dw	?

packer ENDS

;
	end	start

