{
  Stefan's Entry for Hugi Size Coding Competition #7 - Image Compression

  Compressor. Splits the image into regions and compresses these
  individually. Invoke as `pack hugi.raw'. This program spits out
  `entryd.asm' and `entryh.asm' which are INCLUDEd by `entry.asm'. So
  first compress, then assemble.

  Compile with Turbo Pascal 6.0.

  Have fun,
    Stefan <Streu@gmx.de>
}

{
  Implementation Note: During compression, the image is stored in video
  RAM as 64000 bytes image plus 768 bytes palette (invisible in lines
  200..202). I originally planned to compress the image this way...
}

TYPE TRegion = RECORD
           XX, YY : WORD;
           Wi, He : WORD;
     END;

     TByteArray = ARRAY[0..MaxInt] OF BYTE;
     PByteArray = ^TByteArray;

CONST MaxR = 100;

VAR nRegions : INTEGER;
    Regions  : ARRAY[1..MaxR] OF TRegion;

    nColors  : INTEGER;
    maxref   : WORD;

{ Load image into video memory }
PROCEDURE Load;
VAR F:FILE;
    i:WORD;
BEGIN
  IF Paramcount<>1 THEN BEGIN
    Writeln('Invoke as ',ParamStr(0),' path\to\hugi.raw');
    Halt(1);
  END;
  INLINE($B8/>$13/$10CD);
  Assign(F, ParamStr(1));
  Reset(F, 1);
  Blockread(F, Mem[$A000:64000], 768);
  Blockread(F, Mem[$A000:0], 64000);
  Close(F);
END;

PROCEDURE Swap(VAR a,b:BYTE);
VAR p:BYTE;
BEGIN
  p:=a; a:=b; b:=p;
END;

{ sort colors according to frequency }
PROCEDURE Sort;
VAR map,map1:ARRAY[BYTE] OF BYTE;
    stat:ARRAY[BYTE] OF WORD;
    i,j,k:INTEGER;
    w:WORD;
    a:BYTE;
BEGIN
  Fillchar(stat, Sizeof(stat), 0);
  FOR w:=0 TO 63999 DO Inc(stat[Mem[$A000:w]]);

  FOR i:=0 TO 255 DO map[i]:=i;
  i:=1;
  WHILE i<255 DO BEGIN
    IF Stat[i]<Stat[i+1] THEN BEGIN
      w:=Stat[i]; Stat[i]:=Stat[i+1]; Stat[i+1]:=w;
      Swap(map[i], map[i+1]);
      Swap(Mem[$A000:64000 + 3*i], Mem[$A000:64003 + 3*i]);
      Swap(Mem[$A000:64001 + 3*i], Mem[$A000:64004 + 3*i]);
      Swap(Mem[$A000:64002 + 3*i], Mem[$A000:64005 + 3*i]);
      IF i>0 THEN Dec(i);
    END ELSE Inc(i);
  END;
  FOR i:=0 TO 255 DO map1[map[i]]:=i;
  FOR w:=0 TO 63999 DO Mem[$A000:w] := map1[Mem[$A000:w]];

  nColors := 0;
  FOR i:=0 TO 255 DO IF Stat[i]>0 THEN nColors := i+1;

  ASM
        mov     ax,1012h
        mov     bx,0
        mov     cx,100h
        mov     dx,64000
        push    0A000h
        pop     es
        int     10h
  END;
END;

{ get pixel }
FUNCTION Get(X,Y:WORD):BYTE;
BEGIN
  Get:=Mem[$A000:320*Y+X];
END;

{ put pixel }
PROCEDURE Put(X,Y:WORD; c:BYTE);
BEGIN
  Mem[$A000:320*Y+X] := c;
END;

{ return true iff line /Y/ is completely black }
FUNCTION LineIsEmpty(Y:WORD):BOOLEAN;
VAR i:INTEGER;
BEGIN
  FOR i:=0 TO 319 DO IF Get(i,Y)<>0 THEN BEGIN
    LineIsEmpty:=FALSE;
    Exit;
  END;
  LineIsEmpty:=TRUE;
END;

{ true, iff all pixels between /X1,Y1/ and /X2,Y2/ are black }
FUNCTION IsEmpty(X1, Y1, X2, Y2:WORD):BOOLEAN;
VAR X,Y:INTEGER;
BEGIN
  FOR X:=X1 TO X2 DO
  FOR Y:=Y1 TO Y2 DO IF Get(X,Y)<>0 THEN BEGIN
    IsEmpty:=FALSE;
    Exit;
  END;
  IsEmpty:=TRUE;
END;

{ add region to the list of interesting places }
PROCEDURE AddRegion(X0, Y0, X1, Y1:WORD);
VAR i:INTEGER;
BEGIN
 { reduce region size }
  WHILE IsEmpty(X0, Y0, X1, Y0) AND (Y0<=Y1) DO Inc(Y0);
  WHILE IsEmpty(X0, Y1, X1, Y1) AND (Y0<=Y1) DO Dec(Y1);
  IF Y0>Y1 THEN Exit; { can't happen }
 { add to list }
  Inc(nRegions);
  IF nRegions > MaxR THEN BEGIN
    Writeln('Too many regions in this picture');
    Halt(1);
  END;

  WITH Regions[nRegions] DO BEGIN
    XX    := X0;
    YY    := Y0;
    Wi    := X1-X0+1;
    He    := Y1-Y0+1;
  END;
END;

{ get `interesting' regions between the given coordinates }
PROCEDURE GetRegions(X0, Y0, X1, Y1:WORD);
VAR X:WORD;
BEGIN
  WHILE (LineIsEmpty(Y0)) AND (Y0<200) DO Inc(Y0);
  WHILE (LineIsEmpty(Y1)) AND (Y1>=Y0) DO Dec(Y1);
  IF Y1<Y0 THEN Exit;

  WHILE IsEmpty(X0, Y0, X0, Y1) AND (X0<=X1) DO Inc(X0);
  WHILE IsEmpty(X1, Y0, X1, Y1) AND (X0<=X1) DO Dec(X1);
  IF X1>=X0 THEN AddRegion(X0, Y0, X1, Y1);
{ WHILE X0<=X1 DO BEGIN
    WHILE IsEmpty(X0, Y0, X0, Y1) AND (X0<=X1) DO Inc(X0);
    X := X0;
    WHILE NOT IsEmpty(X0, Y0, X0, Y1) AND (X0<=X1) DO Inc(X0);
    IF X0>X THEN AddRegion(X, Y0, X0-1, Y1);
  END; }
END;

VAR Head, Data : TEXT;
    i          : INTEGER;

{ return pixel at position /ix/ in region /R/, interpreted as
  continguous data stream }
FUNCTION GetI(R:TRegion; ix:WORD):BYTE;
BEGIN
  GetI := Get(R.XX + ix MOD R.Wi, R.YY + ix DIV R.Wi);
END;

{ write out compressed version of region /R/ (/i/=number of region) }
PROCEDURE CompressRegion(i:INTEGER; R:TRegion);
VAR c,c1:BYTE;
    index, len, lmax, bmax, back, total, min, z:WORD;
    p: PByteArray;
    tripletok : BOOLEAN;
BEGIN
 {... header for decompressor ...}
  Writeln(Head, 'dw ', R.He*R.Wi+1);
  Writeln(Head, 'dw offset Region',i);
 {... and for display ...}
  Writeln(Head, 'dw ',320*R.YY + R.XX);
  Writeln(Head, 'db ', R.He);
  Writeln(Head, 'dw ', R.Wi);

  Writeln(Data, 'Region',i,':');
  index := 1;
  total := R.Wi * R.He;
  GetMem(p, total);
  FOR z:=0 TO total-1 DO p^[z] := GetI(R,z);

  Writeln(Data, 'db ',p^[0]);       { first character always verbatim }
  tripletok := TRUE;
  WHILE index < total DO BEGIN
   {... try finding a backreference ...}
    lmax := 1;
    back := index-1;
    bmax := back;
    min := 0;
    IF index>maxref THEN min:=index-maxref;
    WHILE (back>min) AND (lmax<255) DO BEGIN
      IF p^[back] = p^[index] THEN BEGIN
        len := 0;
        WHILE (len < total - index) AND (p^[back+len]=p^[index+len]) DO
         Inc(len);
        IF len>lmax THEN BEGIN
          bmax := back;
          lmax := len;
        END;
      END;
      Dec(back);
    END;
    IF lmax>256 THEN lmax:=256;
   {... ok, write out ...}
    IF lmax>3 THEN BEGIN
      Writeln(Data,'db ', Hi(bmax-index), ', ', lo(bmax-index),
                   ', ', lmax-1);
      Inc(index,lmax);
      tripletok := FALSE;
    END ELSE
    IF (tripletok) AND (p^[index]=p^[index-1]) AND (p^[index]=p^[index+1]) THEN BEGIN
     { no successful backreference, but a sequence of 3 equal characters }
      Writeln(Data, 'org $-1');
      Writeln(Data, 'db ',ncolors, ', ' ,p^[index]);
      Inc(index,2);
      tripletok := FALSE;
    END ELSE
    BEGIN
      Writeln(Data,'db ',p^[index]);
      Inc(Index);
      tripletok := TRUE;
    END;
    Put(0, R.YY + index DIV R.Wi, i);
  END;

  FreeMem(p, total);

  FOR i:=0 TO R.Wi-1 DO Put(R.XX+i, R.YY, 7);
  FOR i:=0 TO R.Wi-1 DO Put(R.XX+i, R.YY+R.He-1, 7);
  FOR i:=0 TO R.He-1 DO Put(R.XX, R.YY+i, 7);
  FOR i:=0 TO R.He-1 DO Put(R.XX+R.Wi-1, R.YY+i, 7);
END;

VAR bitcnt:BYTE;
    bits:BYTE;

PROCEDURE Bit(i:BYTE);
BEGIN
  IF bitcnt=8 THEN BEGIN
    Writeln(Head, 'db ',bits);
    bitcnt:=0;
    bits:=0;
  END;
  IF i<>0 THEN bits := bits OR (1 SHL bitcnt);
  Inc(bitcnt);
END;

{ `compress' palette by encoding it as sequence of 6-bit values }
PROCEDURE CompressPalette;
VAR c:BYTE;
    i,j:WORD;
BEGIN
  bitcnt:=0;
  bits:=0;
  Writeln(Head, 'db 1');
  FOR i:=64003 TO 63999+3*nColors DO
   FOR j:=0 TO 5 DO Bit(Mem[$A000:i] AND (32 SHR j));
  FOR j:=0 TO 6 DO Bit(0);
END;

BEGIN
  nRegions := 0;
  Load;
  Sort;
  GetRegions(0,   0, 319, 149);
  GetRegions(0, 150, 319, 199);
  Assign(Head, 'entryh.asm');
  Assign(Data, 'entryd.asm');
  Rewrite(Head);
  Rewrite(Data);
  maxref := 256 * (255-ncolors);
  FOR i:=1 TO nRegions DO CompressRegion(i, Regions[i]);
  Writeln(Head, 'dw 1');
  Writeln(Head, 'nColors = ', nColors);
  CompressPalette;
  Close(Head);
  Close(Data);
  Writeln('Ready. Press [ENTER]');
  Readln;
  INLINE($B8/>3/$10CD);
END.
