; METALBRAIN's entry for Hugi Size Compo #7
;
;4th step code: The 8 bits to 6 bits palette encoder
;
;Compile with NASM:
;nasm step4.nas -o step4.com

                org     256

                mov     dx,infile
                mov     ax,3d00h
                int     33              ;Open HUGI.ST1
                jc      doserror
                xchg    ax,bx
                mov     cx,630
                mov     dx,pal8
                mov     si,dx
                mov     di,pal6
                mov     ah,3fh
                int     33              ;Read file
                jc      doserror
                mov     dl,1
                mov     bx,630
getonebyte      lodsb
                mov     cx,6
                shl     al,1            ;Ignore first 2 zeros
                shl     al,1            ;
putonebit       shl     al,1            ;Take bit
                call    putbit          ;Put bit
                loop    putonebit
                dec     bx
                jnz     getonebyte
                mov     dx,outfile
                mov     ah,3ch
                int     33              ;Create PALETTE.ST2
                jc      doserror
                xchg    ax,bx
                mov     ah,40h
                mov     dx,pal6         ;CX=0
                mov     cx,di
                sub     cx,dx
                int     33              ;Write file
                jc      doserror
                int     32              ;Exit to DOS
doserror        mov     ah,9
                push    cs
                pop     ds
                mov     dx,ERRMSG
                int     33
                mov     ax,4c01h
                int     33              ;Exit with error flag
putbit          adc     dl,dl
                jnc     nonextbyte
                mov     [di],dl
                inc     di
                mov     dl,1
nonextbyte      ret
infile          db "PALETTE",0
outfile         db "PALETTE2",0
ERRMSG          db "Error in step 4",13,10,"$"
                SECTION .bss align=1
pal8            resb    640
pal6            resb    470
