.model tiny
.386
.code
.startup

; *> move to front decoder
; decode one byte to al, requires cx=0, returns with cx=0
; needs bp, destroys si,di,bx,dx
; a character is encoded by the number of different characters that occured
; since the last occurence of the character. given a table "abcde" the
; character "c" is encoded by 3 and the table is updated to "cabde"
GETMTF  MACRO
        GETRLE                          ; get next index in cx
        mov     si,offset mtftab+255
        sub     si,cx                   ; point to encoded byte
        mov     di,si                   ; same
        lodsb                           ; get encoded byte
        rep     movsb                   ; and rotate it
        stosb                           ; to the end of the table
        ENDM

; *> run length decoder
; decodes one byte to cx, requires cx=0, needs bp
; destroys si,di,bx,dx
; this is a special run length code because only runs of zeros are encoded;
; the length of the run is encoded binary with two special characters - 0101h
; and 0100h. note that the character preceding the run of zeros is coded
; _after_ the encoded length of the run, to have an end-of-run-length-marker,
; and to simplify the code.
GETRLE  MACRO
LOCAL   @rlel,@rlee
;       xor     cx,cx                   ; cx is already zero
        dec     bp                      ; more pending zeros?
        jns     @rlee                   ; yes -> return immediately
        stc
@rlel:  adc     bp,bp
        inc     bp                      ; bp=0 (1st loop) or bp+=1 (obvious)
        GETARI
        cmp     cl,ch                   ; cx==0 is forbidden, cl<=ch for
        jbe     @rlel                   ; cx==0101h (-> bp=bp*2+1) and
                                        ; cx==0100h (-> bp=bp*2+2) only
@rlee:  ENDM

; *> arithmetic decoder
; get encoded word (range 1..101h) in cx, destroys si,di,dx,bx,ax
; the packed data is treated as a large integer number
; [more about this later]
GETARI  MACRO
LOCAL   @divl,@scanl,@mull
        mov     si,offset pdata         ; point to packed data
        mov     di,si
        cwd                             ; dx=0
        mov     cx,LEN/2
        push    cx
@divl:  lodsw
        div     word ptr total
        stosw                           ; this is a long divide
        loop    @divl                   ; by total, remainder -> dx.

        mov     si,offset aritab
        xor     bx,bx
@scanl: lodsw
        sub     dx,ax
        inc     bx
        cmp     [si],dx
        jbe     @scanl                  ; cx is the encoded character
                                        ; cf==0 here (!)
        pop     cx
        push    bx
@mull:  mov     bx,dx
        dec     di
        dec     di
        mov     ax,[di]
        pushf
        mul     word ptr [si]
        popf
        adc     ax,bx
        mov     [di],ax
        loop    @mull                   ; long multiply by [si]

        inc     word ptr total
        inc     word ptr [si]           ; update model
        pop     cx
        ENDM

INCLUDE PACK.INC

; *> actual code (!)
start:  mov     di,offset mtftab
@mtfini:dec     al
        stosb
        jnz     @mtfini
        mov     cx,255+128
org	$-2
total:	dw	255+128
        rep     stosw                   ; zero all bwt values
        mov     cl,255
        inc     ax
        rep     stosw                   ; set ari values to 1, cx=0
	mov	al,64
	stosw
	stosw
        mov     al,13h
        int     10h                     ; init video
        xor     bp,bp                   ; bp=0 (needed for GETRLE)
        xor     di,di                   ; di=0 (fill fs from bottom)
        add     dh,10h
        push    dx
; *> PASS 1: decode block-sorted data
@p1_l:  push    di                      ; save di
        GETMTF                          ; get one byte
        imul    bx,ax,2
        inc     word ptr bwttab[2+bx]   ; update bwt tab (character count)
        pop     di                      ; restore di
        pop     es
        push    es                      ; es=0A000h
        stosb                           ; store byte
        push    ds
        pop     es                      ; es=ds

        cmp     di,BLOCKL               ; if block is not done
        jnz     @p1_l

        xchg    cx,di                   ; cx=BLOCKL; di=0
        mov     di,offset pdata
        pop     ds
        mov     bx,LAST
; *> PASS 2: reverse BWT
@p2_l:  mov     al,byte ptr [bx]
        stosb

        mov     si,-1
@scanl: cmp     byte ptr [bx],al
        jne     @skip
        inc     si
@skip:  sub     bx,1
        jnc     @scanl

        imul    bp,ax,2
@addl:  add     si,word ptr bwttab[bp]  ; note that this uses ss=cs
        dec     bp
        dec     bp
        jns     @addl
        mov     bx,si
        loop    @p2_l

pdata:  ; packed data and resulting program here

org     60000
mtftab: db      256     dup (?)
bwttab: dw      255     dup (?)
        dw      127     dup (?)
aritab: dw      258     dup (?)

end

