;
;  ENTRY.ASM (Pong)
;
;  Coded by Boo Khan Ming (Wu)
;  for Hugi Size Coding Compo 3 (August 1998)
;
;
;  Size Distribution                    178
;  
;  Ball (clear+draw)                      8
;  Ball (move+reflect+check for end)     41
;  Bars (clear+draw)                     27
;  Bars (move+kb handler)                38
;  Misc (init+exit+delay)                46
;  Text                                  18
;
;
;  This is my first game written in Assembly language.
;  Please do not expect much from me.
;  Anyway, I've put great effort in finding the most suitable algorithm,
;  and this is being my third algorithm.
;
;  
;
;  There are mainly two unique technique or algorithm employed here and
;  should be outlined to make you easier to follow the code.
;
;  For keystroke checking, the most essential part is the conversion
;  performed by AAA (or DAA) instruction.
;  The player side and the left or right keys are then determined from
;  bit 0 and bit 1 in accumulator (AL) respectively.
;
;  For ball movement, the horizontal and vertical edge detection are
;  determined from two counters respectively.
;  This is concluded from that the number of movement from left edge to
;  right edge and vice versa are equal. Similarly, the number of movement
;  from top edge to bottom edge and vice versa are equal too.
;  Therefore, when the counter are decremented to zero, an edge collision
;  should be encountered logically.
; 
;
;  Credit should goes to
;   Maxx for CLI instruction (4 bytes saving)
;   Picard for VR routine (3 bytes saving)
;
;  Contact e-mail: bookm@tm.net.my
;  Homepage URL  : http://www.geocities.com/SiliconValley/Horizon/3409/
  

        .MODEL tiny
        .286

        .DATA
        Table           DW      0,0
        Message         DB      "Player 2 has won.$"

        .CODE
        .STARTUP

        mov     al, 03h                 ; set text mode        
        int     10h
        push    0b800h                  ; startup initialization
        pop     es
        cli
        lea     si, Table               ; data table starting offset
        mov     di, 324                 ; ball parameters
        mov     bp, 320
        mov     bl, 162
        mov     cl, 77
        mov     al, 22
        
Start:
        pusha

        mov     ax, 09dch               ; draw new ball
        stosw

        mov     cl, 75                  ; perform vertical retrace
        mov     dx, 03dah               
Delay:
        in      al, dx
        xor     al, cl
        and     al, 8
        jnz     Delay
        loop    Delay

        call    Draw                    ; clear old paddles

        in      al, 60h                 ; check keystroke
        test    al, 80h
        jnz     Key2
        cmp     al, 1                   ; (required) to set AF?
        aaa
        mov     cl, 10
        mov     bl, al
        and     bx, 0001h               ; determine player side
        shl     bl, 1
        test    al, 02h                 ; determine left or right keys
        jnz     Key1
        neg     cl
Key1:
        mov     ax, [si+bx]             ; move paddle
        add     al, cl
        cmp     al, 90h                 ; left and right edge check
        jae     Key2
        mov     [si+bx], ax
Key2:
        mov     ax, 0adbh               ; draw new paddles
        call    Draw

        popa

        stosw                           ; clear old ball

        dec     di                      ; move ball
        dec     di
        add     di, bx
        dec     cx                      ; horizontal edges check
        jnz     Move1
        neg     bx                      ; horizontal reflection
        add     bx, bp
        mov     cl, 79
Move1:
        dec     ax                      ; vertical edges check
        jnz     Move3
Move2:
        neg     bp                      ; vertical reflection
        add     bx, bp
        mov     al, 0dbh                ; vertical collision check
        scasb
        jnz     Stop
        mov     al, 22
        dec     di
        add     di, bp                  ; vertical reflection correction
Move3:
        jmp     SHORT Start

Stop:
        shr     di, 11                  ; update player ID
        sub     [si+11], di
        mov     al, 03h                 ; reset text mode
        int     10h
        mov     ah, 09h                 ; display message
        lea     dx, Message
        int     21h
        ret
Draw:
        mov     cl, 10                  ; draw paddles (procedure)
        push    cx
        mov     di, [si+2]
        rep     stosw
        pop     cx
        mov     di, [si]
        add     di, 0f00h
        rep     stosw
        ret

        END
