.Model TiNY
.586

.CODE
 ORG 100h
PROGRAM_STARTS_HERE:

;        MOV   SI, 100h

        PUSH  0B800h
        POP   ES

        MOV   BL, 160
        MOV   DI, BX  ; ball's X,Y
        STOSW
        PUSH  78

        MOV   BYTE PTR [SI-1], 0Fh
        mov   [si],ax

				MOV 	AX, 0003h 	 ; Set video mode 3h and mask many interrupts
        OUT   21h, AL
        INT   10h

	; { MAIN LOOP

MAINLOOP:

        MOV   CL, 0Ah
        MOV   DX, 3DAh
      DELAY:
        IN    AL, DX
        XOR   AL, BL
        TEST  AL, 08h
        JE    DELAY
        NOT   BL
        LOOP  DELAY

        XCHG  AX, CX         ; Remove Ball from Screen
        STOSW

                             ; Move ball and check events
        ADD   DI, BX         ; READ UNDERLYING CHAR
        CMP   byte ptr ES:[DI],0DBh
				JNE 	BarNotHit
        SUB   DI,BX
        SUB   DI,BX
        NEG   BX
			BarNotHit:

        CMP   DI, 25*160
				JNA 	NothingExpecial

			;GameOver:
        MOV   AL, 03h       ; Re-init mode 3h
        ADD   BX, BX
				ADC 	byte ptr WINPLYR, AL
				INT 	10h
				Mov 	dx, offset Results
				MOV 	AX, 09B8h 			; Write results
				OUT 	21h, AL 				; Restore PIC status
				INT 	21h
        INT   20h             ; quit

NothingExpecial:
        POP   CX              ; Userful Counter (.... :-| ....)
        LOOP  NoXCollision
      XCollision:
        STD
        XOR   byte ptr [SI+(offset XCollision - 100h)], 1    ; Correct thiz!
        MOV   CL, 79
			NoXCollision:
				PUSH	CX
        PUSH  DI
        CALL  CLEAR_BARS

        IN    AL, 60h
				TEST	AL,0B0h
				JS		SHORT NO_KEY_WAS_HIT

        PUSH  SI
        MOV   DX, 8C0Ah

        JZ    Letter
        DEC   SI
        DEC   SI
			Letter:
				AAM
				AND 	AL, 2
				JNZ 	MoveLeft
      UNDO:
        NEG   DL
      MoveLeft:
        ADD   [SI], DL
        CMP   [SI], DH
				JA		UNDO

        POP   SI

			NO_KEY_WAS_HIT:

				CALL	UPDATE_BARS

        MOV   AX, 09DCh      ; Draw Ball
        POP   DI
        PUSH  DI
        STOSW
        POP   DI
        JMP   MainLoop

	; }

		UPDATE_BARS:
        MOV   AX, 0ADBh      ; Draw Bar1
    CLEAR_BARS:
        MOV   DI, [SI]
        CALL  VRAIT          ; WRITE

        MOV   DI, [SI-2]     ; Draw Bar2

    VRAIT:
        MOV   CL, 10
        PUSHF
        CLD
        REP   STOSW
        POPF
        RET


		Results db 'Player '
		WinPlyr db '. has won.$'

END PROGRAM_STARTS_HERE
