; PONG.COM   by Chess Knight
; 143 bytes
;
; This program is a size optimized implementation of the classic pong game.
; Created for size optimized code contest at
;   http://home.pages.de/~hugi-compo
;
; '4' and '6' control the top paddle.
; 'A' and 'D' control the bottom paddle.
; Status of Num Lock and Caps Lock does not matter.
;
; User must press a key before the ball reaches the bottom of the screen.
;
;  Assembled with Turbo Assembler V3.1
;    tasm /m read
;    tlink /t read
;  /m enables multiple passes so that jumps are optimized
;  /t tells the linker to make a COM file.
;
;=======================================================
;
.386
BALL_DIR        EQU     BX
;
_COM    SEGMENT WORD PUBLIC 'CODE' USE16
        ORG     100H
_PONG   PROC    NEAR
        ASSUME  CS:_COM,DS:_COM
;
        PUSH    0B800H
        POP     ES
        CMPSW                   ;DI=0FFFEH at start; now DI = 0 ;ball location
; Change to 80X25 text video (also prints garbage until opcode of AND AL,8)
        CALL    JVIDEO
;
        MOV     BL,158          ;Starting ball direction

;-------------------------------------------------------
; main loop
JMAIN:
; vertical retrace delay loop.  (Thanks, Picard)
        mov     cl,79
        mov     dx,3dah
JDELAY:
        in      al,dx
        xor     al,cl
        and     al,8
        je      JDELAY
        loop    JDELAY

        XCHG    BP,AX

; Get keypress
        cli                     ;Stop the beeping (Thanks, Maxx)
        IN      AL,60H

        MOV     SI,OFFSET PADL1
; Update Paddle Positions
JUPADL:
        TEST    AL,0AAH         ;1F, 5, 4B not 21, 7, 4D
        BTC     AX,CX           ;Tell if paddle 1 or 2 (CX=0 from vert. retr.)
        PUSHA
        MOV     AX,0A20H

; Erase old ball
        STOSB

        JS      JNRITE          ;Jump if no key press
        JNC     JNRITE          ;Jump if wrong paddle
        JPO     JNLEFT          ; e  e   e      o  o   o  parity of AH & 0AAH
        SUB     BYTE PTR [SI],AH        ;move paddle left 10 spaces
        JAE     JNRITE
JNLEFT:
        CMP     BYTE PTR [SI],140
        JE      JNRITE
        ADD     BYTE PTR [SI],AH        ;move paddle right 10 spaces
JNRITE:

; Draw paddles
        MOV     DI,[SI]         ;get paddle location
JDRAWP:
        MOV     CL,20           ;20 = number of words to draw
        SUB     DI,CX           ;back up 10 words (20 bytes)
        REP     STOSW
        XOR     AL,0FBH         ; 0FBH = 20H XOR 0DBH.  0DBH = 219 = ''
        INC     BP
        JPE     JDRAWP          ;do draw loop 3 times (spaces, blocks, spaces)
        POPA
        CMPSW
        DEC     DX
        JPO     JUPADL          ;do Update Paddle Positions exactly twice

; Test for ball hitting paddle
        CMP     BYTE PTR ES:[BX+DI],DL
        JB      JNPADL
        XOR     BALL_DIR,-64    ; 162 <-> -158, 158 <-> -162
JNPADL:                         ; 158 <-> -162, 154 <-> -166 (DI+=4 from CMPSW)
; Update ball position
        ADD     DI,BALL_DIR

        MOV     AX,DI
; Draw new ball
        MOVSW                   ;SI = OFFSET PADL2 + 2. [SI] = ball color/char

; Test for edges
        XCHG    AX,DI           ;AX = ball position + 2
        DIV     BYTE PTR [SI]
        SUB     AH,DH           ;DH=3
        JAE     JNEDGE          ;left and right edge
        XOR     BALL_DIR,04H    ;158 <-> 154, -162 <-> -166
JNEDGE:
        NEG     AL              ;Test for victory (AL=0 or AL=25)
        AND     AX,018h
        JNZ     JMAIN

;-------------------------------------------------------
; exit program
        SUB     [SI+BP],BH       ;Set x in "Player x has won."
JVIDEO:
; Change to 80X25 text video
        MOV     AL,3
        INT     10H
; Print victory message.
        MOV     DX,SI           ;SI=OFFSET VMESG-1 (Cheesy way to save 1 byte)
        MOV     AH,09H
        INT     21H
;  terminate
        RETN
_PONG   ENDP
;=======================================================
; data
PADL1   DB      0, 0
PADL2   DB      0, 0FH          ;24*160
        DW      09DCH           ;Ball color and character
        DB      160
VMESG   DB      'Player 1 has won.'
;CHEESY  DB      '$'             ;Save 1 byte by not stopping DOS int 21H, AH=9

_COM    ENDS
        END     _PONG

;=======================================================
;Parity
;  This program uses the parity flag.  Parity refers to the number of
;  bits set in a byte or word.  Parity is even if an even number of
;  bits are set as in 0, 3, 5, 6, 9, A, C, F, etc. and odd otherwise.
;  Given 3 adjacent numbers, exactly 2 of them will have the same parity.
;  So parity is a great way to do loops 2 or 3 times without wasting
;  2 or more bytes loading a register with a 2 or 3, as long as there
;  is a register with an appropriate known value that may be changed.
;
;BP
;  In 144 byte version, BP register was not used.  In this one, BP
;  gets 0908H during the 1st iteration because AH is 9 to use INT 21H,
;  service 9.  At the end of the main loop, AH becomes 0 and BP gets
;  0008H from then on.  In either case parity of BP+1 and BP+2 is even.
;  The game cannot end after 1 iteration, so BP+SI will point to the
;  correct memory location when setting the victory message.
;
;'$'
;  INT 21H service 9 stops printing text when it encounters a '$'.
;  The rules of this compo say only that you must switch to video
;  mode 3 and print a victory message.  The rules do NOT say that
;  extra text cannot be printed to the screen.  This loophole
;  has been shamelessly exploited to save 2 bytes, one by leaving
;  out the terminating '$' and the other by printing one extra
;  character in front of the victory message.  At the start of the
;  program, SI=100, so "text" is printed until the opcode of
;  AND AL,8 which is '$'.  The first time the top paddle is drawn,
;  this "text" is completely covered.
;
;victory test
;  The position of the ball is compared to 0 and 25, not 0 and 24.
;  Comparing with 24 worked in all cases except when the ball
;  was in the rightmost column.  Since the ball does not reach row
;  24, column 80 until the players have hit it 61 times, comparing
;  with 24 seemed to work.
