;---- Pong Entry by PaP / The ApocalypsE -------------
;------------ APC_PAP@gmx.net ------------------------
;------- should compile to 176 Bytes ----------------------
.286             
.model tiny      
code segment public         
        assume  cs:code,ds:code                  
        org     100h                             
start:                                           
.386                                             
P386N                                            
;---- Clear Screen ----                          
        push    0B800h                           
        pop     es                               
        mov     bl,4                    ;Ball - X - Position
        mov     si,2*160                ;Ball - Y - Position
        mov     bp,160                  ;Ball - Y - Speed
        mov     [si+bp],eax
        call    ProgEnd                          
        cli                             
;---- Mainloop ----                                         
mainloop:                               
;------ Wait for Retrace ----------------
        mov     cl,5    ;5 Retraces      
RetraceLoop:                             
        mov dx,3dah                      
delay_l1:                                        
        in al,dx                         
        test al,8                        
        jne delay_l1                     
delay_l2:                                
        in al,dx                         
        test al,8                                     
        je delay_l2                                   
        loop RetraceLoop                              
;-----------------------------------------                                
        
        xchg    ax,cx                      ;AX => 0     
        mov     es:[si+bx],ax              ;Delete the Ball
        call    DrawPaddle                 ;Delete the old Paddle  
;----- Keyboard stuff -----
        in      al,60h
        mov     di,OffSet P1X                        
        test    al,80h+01h
        js      SkipKeys
        jnz     ItsPlayer1
        scasw                           ;advance di by 2
ItsPlayer1:                                                          
        aam             
        mov     al,[di]
        jnp     Right
        sub     al,20
Right:                
        add     al,10 
        cmp     al,150                  ;avoid paddle - border - crossing
        jnc     SkipKeys
        mov     [di],al                              
SkipKeys:                                            
                                                     
        mov     ax,219+10*256   ;2779
        call    DrawPaddle     
                                          
RepY:
        add     si,bp                    ;Advance ball-pos by Ball - YSpeed
       
        cmp     es:[si+bx],ax
        jne     NoYClip           
        neg     bp                
        add     si,bp             
        jmp     RepY
NoYClip:                          
        add     bl,bxs                   ;Advance ball-pos by Ball - XSpeed
        jz      Clip
        cmp     bl,158
        jne     NoClip
Clip:
        neg     bxs                              
NoClip:                                          
        mov     word ptr es:[si+bx],220+9*256      ;Draw the Ball
;---- Floor & Ceiling Hit ----------------           
        cmp     si,25*160      
        jc      MainLoop       
        js      ProgEnd        
;---- Deinitializing stuff ----                  
        dec     PN             
ProgEnd:                                         
        mov     al,3                             
        cbw                                      
        int     10h
                                                     
        mov     dx,Offset Mess1                      
        mov     ah,09h                               
        int     21h                                  
                                                     
        ret                                          

DrawPaddle:                                          
        mov     di,P1X                               
        mov     cx,10
        rep     stosw                   ;Draw or delete Paddle
        mov     cl,10
        mov     di,P2X
        add     di,24*160
        rep     stosw                   ;Draw or delete Paddle
        ret                                          
                                                     
Mess1   DB      "Player "                            
PN      DB      "2"                                  
Mess2   DB      " has won.","$"                      
BXS     DB      2            
Buffer:          
        DB      Start-Buffer+2*160+160-256      DUP (?)
P1X     DW      ?               ;Player 1 X-Pobystion
P2X     DW      ?               ;Player 2 X-Pobystion
code    ends                                     
        end     start                            