 ;"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""";
 ;  tinyPONG for the HUGI competition :)  --  by Jibz '98                   ;
 ;                                                                          ;
 ;   - One of the bars is drawn multiple times to avoid calls.              ;
 ;   - Uses DI as ball x-direction (since it's -2 at startup).              ;
 ;   - Uses CLI to stop the keyboard-buffer from filling.                   ;
 ;   - Uses Picard's vretrace code.                                         ;
 ;..........................................................................;

    .MODEL TINY
    .386
    CODESEG
    LOCALS
    ORG 100h

START:
    call    exit_pl2_won  ; saves 1b, but write something on screen..

    push    0b800h        ; segm of video mem
    pop     es

    lea     si, [si+68]   ; same size as mov, but more fun 8)
    mov     bp, 160       ; starting ball y-dir

    cli                   ; disable keyboard

mainloop:
; check for keypress
    in      al, 60h
    test    al, 81h       ; get low- and high order bits
    js      kb_done
    mov     bx, offset (pl1_pos + 1)
    jpo     player_1
    mov     bl, 51h       ; distance to (pl2_pos + 1)
player_1:

; evaluate keypress
    test    al, 1bh       ; '4' -> odd, '6' -> even, 'a' -> odd, 'd' -> even
    mov     al, [bx]      ; get bar position
    jpe     its_6_or_d
its_4_or_a:
    cmp     al, 0ffh      ; subtract 2 if al > -1, and 1 if al = -1
    sbb     al, 1
its_6_or_d:
    cmp     al, 13
    jge     kb_done
    inc     ax
    mov     [bx], al      ; store bar position
kb_done:

    mov     dx, 03dah     ; for the vretrace (dl is used later)
    mov     bl, 0ah       ; bl = 10 for the imul's
    mov     cl, 05h       ; cl = 05 loop-counter

pl1_pos:
    mov     al, -1        ; -1 = starting pos for bar1
    imul    bl            ; ax = bar1 offset

; do 5 vertical retraces, and erase+draw the bars
retraces:
    pusha                 ; save di (ball x-dir) and cx

    xchg    di, ax        ; get bar pos from ax

VRT:
    mov     ah, 09fh      ; picard's brilliant vretrace-code
    in      al, dx
    and     ax, 0408h
    jnz     (VRT+1)

; write bar at es:di (di = ax from above)
    mov     cl, 25
    rep     stosw         ; erase old bar (ax = 0 from the vretrace)
    sub     di, 40
    mov     cl, 10
    mov     ax, 0adbh
    rep     stosw         ; write new bar

    popa                  ; restore di (ball x-dir) and cx

pl2_pos:
    mov     al, -1        ; -1 = starting pos for bar2
    imul    bl
    add     ax, 24*160    ; ax = bar2 offset

    loop    retraces

; remove ball at es:si
    mov     word ptr es:[si], cx  ; cx = 0 from above

; calculate new ball position
    cmp     byte ptr es:[si+bp], dl  ; bat above or below ball? (dl = 0dah)
    jbe     nobat
    neg     bp            ; change y direction
nobat:
    lea     si, [si+bp]   ; add y-dir
    sub     si, di        ; add x-dir

; draw ball at es:si
    mov     word ptr es:[si], 09dch

; check for wall-colission
    lea     ax, [si+2]    ; AX = SI + correction
    mov     bl, 160
    div     bl            ; divide by 160
    shr     ah, 2         ; check modulo for colission against both sides
    jne     noborder

    neg     di            ; change x direction

noborder:
; check ball against top and bottom
    dec     al            ; al is the modulo from the above division :)
    js      exit_pl2_won
    cmp     al, 24
    jb      mainloop

exit:
    dec     byte ptr [endmessage_pl]  ; Player _1_ has won.

exit_pl2_won:
    mov     ax, 03h
    int     10h
    mov     dx, offset (endmessage)  ; write message
    mov     ah, 09h
    int     21h
    ret

endmessage:
       db 'Player '
endmessage_pl:
       db '2'
       db ' has won.$'

END START
