; *** Hugi-compo #3 ***
; Name:         Guillermo Sais
; Country:      Mexico
; E-mail:       gsais@iname.com

Ideal
p486

BAR_CHAR        EQU ''
BAR_COLOR       EQU 10
BAR_LEN         EQU 10
BAR_MOVE        EQU 5
BALL_CHAR       EQU ''
BALL_COLOR      EQU 9
BACK_CHAR       EQU ' '
BACK_COLOR      EQU 7

BAR_SPRITE      = ((BAR_CHAR)or(BAR_COLOR shl 8))
BALL_SPRITE     = ((BALL_CHAR)or(BALL_COLOR shl 8))
BACK_SPRITE     = ((BACK_CHAR)or(BACK_COLOR shl 8))

segment         CodeSegment use16
assume          cs:CodeSegment,ds:CodeSegment,ss:CodeSegment
org             100h
Start:
;assert         ah=0
mov             al,3                            ; ax=3
int             10h                             ; int10.SetVideoMode(3)
xchg            bp,ax                           ; bp=3
cli
mov             si,(1*2)+(1*160)                ; si->Ball.Pos=(1,1)
;assert         bh=0
mov             bl,160                          ; bx->Ball.DeltaY=160
RowSize         = byte $-1                      ; const RowSize:byte=160
push            0b800h                          ; video segment
pop             es                              ; es=0b800h
MainLoop:
mov             di,offset Bar1                  ; di=&Bar1.Pos
lea             si,[si+bx+2]                    ; Ball.PosX+=Ball.DeltaX
                                                ; Ball.PosY+=Ball.DeltaY
DeltaX          = byte $-1                      ; var DeltaX:byte=2
lea             ax,[si+bp]                      ; ax=Ball.Pos+3
div             [RowSize+di-offset Bar1]        ; al=Ball.PosY {+1}
                                                ; ah=(Ball.PosX+1)mod 160
cmp             ah,4                            ; Ball.PosX in [0,79]?
ja              NoWall                          ; no: skip
neg             [DeltaX+di-offset Bar1]         ; yes: Ball.DeltaX=-Ball.DeltaX
NoWall:
aam             25                              ; Ball.PosX in [0,25 {-1}]?
jnz             Continue                        ; no: skip
                                                ; yes: game over
sub             [Winner+di-offset Bar1],bh      ; if(Ball.DeltaY>0) Winner=1
                                                ; else Winner=2
xchg            bp,ax                           ; ax=3
int             10h                             ; int10.SetVideoMode(3)
mov             ah,9
mov             dx,offset Message
int             21h                             ; int10.WriteStr(Message)
ret                                             ; exit

Message         db 'Player '
Winner          db '1 has won.$'                ; the '$' can be removed safely
                                                ; for saving an extra byte...
                                                ; (cheap trick!)
Continue:
in              al,60h                          ; al=last key pressed/released
test            al,81h                          ; key released?
js              NoKey                           ; yes: skip
jnz             Player1                         ; player2 key?
scasw                                           ; yes: di=Bar2.Pos
Player1:
aam             5                               ; left/right key?
mov             al,-BAR_MOVE*2                  ; left key
jz              Left
mov             al,BAR_MOVE*2                   ; right key
Left:
add             al,[di]                         ; Bar.NewPos=Bar.Pos (+/-) 5
cmp             al,(80-BAR_LEN)*2               ; (Bar.NewPos<0)or(Bar.NewPos>70)?
ja              NoKey                           ; yes: skip
mov             [di],al                         ; Bar.Pos=Bar.NewPos
NoKey:
mov             ax,BAR_SPRITE                   ; ax=Bar.Sprite
DrawLoop:
cwd                                             ; dh=0
mov             dl,0                            ; dx=Bar1.Pos
Bar1            = byte $-1                      ; var Bar1:byte=0
mov             di,24*160                       ; di=Bar2.Pos
Bar2            = word $-2                      ; var Bar2:word=24*160
;assert         ch=0
mov             cl,BAR_LEN*2                    ; cx=Bar.Len*2
DrawBarsLoop:
stosw                                           ; Mem[es:di]=ax, di+=2
xchg            dx,di                           ; dx <-> di
loop            DrawBarsLoop                    ; repeat
xor             [word es:si],BALL_SPRITE xor BACK_SPRITE ; draw/erase ball
dec             ax                              ; draw/erase?
jp              MainLoop                        ; draw: goto MainLoop
cmp             [es:si+bx],al                   ; ball collides with bar?
jna             NoBar                           ; no: skip
neg             bx                              ; yes: Ball.DeltaY=-Ball.DeltaY
NoBar:
;assert         ch=0
mov             cl,(10*8)-1                     ; cx=79
mov             dx,3dah                         ; dx=VGA_STATUS_PORT
DelayLoop:
in              al,dx                           ; al=vga.status
xor             ax,cx                           ; xor bit 3
and             al,8                            ; isolate bit 3
jnp             DelayLoop                       ; wait for transition
loop            DelayLoop                       ; repeat 10 times
jmp             short DrawLoop                  ; erase sprites

ends            CodeSegment
end             Start
