;Ŀ
;
;
;   Our Entry To The 3rd Hugi Size Compo  By Sudden Impact & Epitaph / Dark
;Ŀ
;
;

	    .model  tiny
	    .586

;
; CODE Segment - Main code low
;
CODE	    SEGMENT para public use16 'CODE'
	    assume  cs: code, ds: code, ss: code

org	    100h    			    ; #bytes of code down this column

;
; MACROS
;

SETALC	    MACRO
	    db	    0D6h		    ; 1
	    endm

;
; CODE START
;

START	    PROC    near

;--- initialization
	    mov	    si, ballstart	    ; 3
	    mov	    bp, balldxstart	    ; 3

	    mov	    al, 3		    ; 2
	    push    ax			    ; 1
	    int	    10h			    ; 2

	    cli	    			    ; 1

	    push    0B800h		    ; 3
	    pop	    es			    ; 1

@mainloop:  lea	    bx, [barpos]	    ; 3

;--- draw bars
            call    drawplrs0               ; 3

;--- draw ball
	    mov	    word PTR es: [si], ballchar + ballcolor shl 8 ; 5

;--- vertical retrace (I think this was Picard's!  Thanks for posting this!)
	    mov	    dx, 03DAh		    ; 3
	    mov	    cl, 72		    ; 2
@delay:	    in	    al, dx		    ; 1
	    xor	    al, cl		    ; 2
	    and	    al, 8		    ; 2
	    jne	    @delay		    ; 2
	    loop    @delay		    ; 2

;--- erase ball
	    cwd	    			    ; 1
	    mov	    es: [si], dx	    ; 3

;--- update ball location
	    mov	    cl, 160		    ; 2

	    mov	    di, si		    ; 2
	    sub	    di, cx		    ; 2
	    jl	    @quit		    ; 2

	    mov	    al, es: [di]	    ; 3
	    cmp	    si, 160*24		    ; 4
	    jge	    @quit		    ; 2

	    add	    al, es: [di+320]	    ; 4
	    jns	    @uunext		    ; 2

	    xor	    bp, ymod		    ; 3

@uunext:    xchg    ax, di                  ; 1
	    div	    cx			    ; 2
	    dec	    dx			    ; 1
	    cmp	    dl, 157		    ; 3 - 0 or 158 = bail
	    jb	    @unoxflip		    ; 2
	    xor	    bp, xmod		    ; 3

@unoxflip:  add	    si, bp		    ; 2

;--- get key
	    in	    al, 60h		    ; 2
	    test    al, 128		    ; 2
	    jnz	    @mainloop		    ; 2

;--- erase bars
	    push    ax			    ; 1
	    setalc  			    ; 1
	    call    drawplrs		    ; 3
	    pop	    ax			    ; 1

;--- process keys
	    cmp	    al, 1		    ; 2 - set AF
	    aas	    			    ; 1
	    test    al, 1		    ; 2
	    jnz	    @player1		    ; 2
	    sub	    al, 3		    ; 2
	    inc	    bx			    ; 1
@player1:   add	    al, 250		    ; 2
	    add	    al, [bx]		    ; 2
	    cmp	    al, maxbarlimit	    ; 2
	    ja	    @bbq		    ; 2
	    mov	    [bx], al		    ; 2
@bbq:       jmp     @mainloop               ; 2

barpos:	    db	    0, 0
msg         db      "Player 2 has won.$"

@quit:
;--- update final message and return to mode 3h
            adc     byte ptr [bx+9], -1     ; 4
	    pop	    ax			    ; 1
	    int	    10h			    ; 2

;--- print final message
            lea     dx, [msg]               ; 3
	    mov	    ah, 9		    ; 2
	    int	    21h			    ; 2

	    ret	    			    ; 1

;
; PROCEDURES
;

drawplrs0:  mov	    ax, barchar + barcolor shl 8 ; 3
drawplrs:   movzx   di, byte PTR [bx]	    ; 3
	    call    drawplr		    ; 3
	    movzx   di, byte PTR [bx+1]	    ; 4
	    add	    di, 24*16		    ; 4
drawplr:    mov	    cl, 10		    ; 2
	    imul    di, cx		    ; 3
	    rep	    stosw		    ; 2
	    ret	    			    ; 1
	    	    			    ;---
	    	    			    ; 25

;
; INFORMATION TABLES
;

;-----------------------
; ASCII values
;-----------------------
; '4' = 34h = 00110100b
; '6' = 36h = 00110110b
; 'a' = 61h = 01100001b
; 'd' = 64h = 01100100b
;-----------------------

;-----------------------
; Scan codes
;-----------------------
; '4' = 4Bh = 01001011b
;     = 05h = 00000101b
; '6' = 4Dh = 01001101b
;     = 07h = 00000111b
;
; 'a' = 1Eh = 00011110b
; 'd' = 20h = 00100000b
;-----------------------

;---------------------------------------------------------------------
;       n        |    n - 6       |     n - 76      |     n - 31
;---------------------------------------------------------------------
; '4' = 05h      | -1 = 11111111b | -71 = 10111001b | -26 = 11100110b
; '4' = 4Bh = 75 | 69 = 01000101b |  -1 = 11111111b |  44 = 00101100b
; '6' = 07h      |  1 = 00000001b | -69 = 10111011b | -24 = 11101000b
; '6' = 4Dh = 77 | 71 = 01000111b |   1 = 00000001b |  46 = 00101110b
; 'a' = 1Eh = 30 | 24 = 00011000b | -46 = 11010010b |  -1 = 11111111b
; 'd' = 20h = 32 | 26 = 00011010b | -44 = 11010100b |   1 = 00000001b
;---------------------------------------------------------------------

;-----------------------------------------
; Direction tables (UDRL= Up/Dn/Rght/Lft)
;-----------------------------------------
; DR = +160+2 = +162 = 00000000 10100010b
; DL = +160-2 = +158 = 00000000 10011110b
; UR = -160+2 = -158 = 11111111 01100010b
; UL = -160-2 = -162 = 11111111 01011110b
;-----------------------------------------

START	    ENDP

;
; VARIABLES/DATA/EQUATES
;

playeridx   equ	    7

ballstart   equ	    160 * 2 + 2 * 2
balldxstart equ	    162

ballchar    equ	    220
ballcolor   equ	    9
barchar	    equ	    219
barcolor    equ	    10
maxbarlimit equ	    14

xmod	    equ	    4 + 8 + 16 + 32
ymod	    equ	    128 + 64 + 255 shl 8

vrdelay	    equ	    5

CODE	    ENDS
	    end	    start
