;--------------------------------------
;        Pong 199 byte version
;                10/8/98
;         Code by Carsten & Klaus
;
; Compiled with Tasm 3.2 and /m9 option
; Linked with Tlink 2.0
;--------------------------------------


.model tiny
.code
.386
org 100h

Start:
         mov   al,3
         int   10h

         cli

         push  0B800h
         pop   es
         xor   si,si                 ; ofs bar 1
         xor   bp,bp                 ; ofs bar 2
         mov   bx,0404h              ; bx  = ball position * 2
         mov   dx,0202h              ; dx  = ball adder * 2

Looping:
         push  dx
         push  bx

         mov   cl,5
        delay_l0:
         mov   dx,3dah
        delay_l1:
         in    al,dx
         and   al,8
         je    delay_l1
        delay_l2:
         in    al,dx
         and   al,8
         jne   delay_l2
         loop  delay_l0                ; 5x WaitVRT

         xor   dx,dx
         dec   di
         dec   di
         stosw

         mov   bh,1
         in    al,60h                  ; check keyboard
         test  al,1
         sete  bl                      ; bl = 1 (bar 2) = 0 (bar 1)
         cmp   al,80h
         jae   Again
         aam
         org   $-1
         db    05h
         setne dl
         jne   Plus
         dec   dx
Plus:
         imul  dx,10
Again:
         mov   ax,00DBh
PrintNew:
         mov   di,si
         or    bh,bh
         jne   DontAdd
         add   di,24 * 160
DontAdd:
         mov   cl,10
         rep   stosw
         or    ah,ah
         jne   NextBar
         mov   ah,0Ah
         cmp   bl,bh
         je    PrintNew
         add   si,dx
         cmp   si,75 * 2
         jb    PrintNew
         sub   si,dx
         jmp   PrintNew
NextBar:
         xchg  si,bp
         dec   bh
         jns   Again
         pop   bx
         pop   dx

         push  bx
         call  Calc
         scasw
         jne   NoPaddle
         neg   dh
NoPaddle:
         add   bl,dl
         cmp   bl,80 * 2
         jnae  NoWall
         neg   dl

NoWall:
         pop   bx
         add   bl,dl
         call  Calc
         mov   ax,09DCh
         stosw
         cmp   bh,25 * 2
         jae   P2
         jmp   Looping

P2:
         jns   P1
         inc   byte ptr msg + 7
P1:
         mov   ax,3
         int   10h
         mov   dx,offset msg
         mov   ah,9
         int   21h
;         ret

;--------------------------------
; Calc - calculates screen offset
; input:  dx = y/x coordinates
; output: di = offset
;--------------------------------
Calc     proc  near
         add   bh,dh
         movzx di,bh
         mov   cl,bl
         imul  di,80
         add   di,cx
         ret
Calc     endp

; data
msg      db    "Player 1 has won.$"

end Start