TYPE HugeNum = ARRAY[1..1000] OF BYTE;          { A 8000-bit number }

VAR Chars:STRING;                               { the translation table (37-alphabet) }
    a,b:HugeNum;
    x:HugeNum;
    factor:INTEGER;
    Index,Code:ARRAY[0..1000] OF INTEGER;
    Data:ARRAY[0..1000] OF CHAR;
    Size,CodeSize:INTEGER;
    Probab:ARRAY[CHAR] OF INTEGER;

{ adds two 8000-bit numbers }
PROCEDURE Add(VAR a,b:HugeNum); ASSEMBLER;
ASM
                push    ds
                les     di,a
                lds     si,b
                clc
                cld
                mov     cx,1000
@@Loop:         lodsb
                adc     es:[di],al
                inc     di
                loop    @@Loop
                pop     ds
END;

{ multiply a 8000-bit number with a (small!) integer }
PROCEDURE Multiply(VAR a:HugeNum; i:INTEGER);
VAR b:HugeNum;
BEGIN
  FillChar(b,Sizeof(b),0);
  WHILE i>0 DO BEGIN
    Add(b,a);
    Dec(i);
  END;
  a:=b;
END;

{ reads the file and makes the data stream. Two spaces are combined to a #0, }
{ LF is ignored (CR+LF -> LF) }
PROCEDURE ReadFile;
VAR F:FILE OF CHAR;
    C:CHAR;
    i:INTEGER;
BEGIN
  Assign(F,'text.txt');
  Reset(F);
  Size:=0;
  Seek(F,2);
  WHILE NOT EOF(F) DO BEGIN
    IF Size>=Sizeof(Data) THEN BEGIN
      Writeln('Sorry, wrong compo.');
      Halt;
    END;
    Read(F,C);
    IF (C=' ') AND (Size>0) AND (Data[Size-1]=' ') THEN Data[Size-1]:=#0 ELSE
    IF (C<>#10) THEN BEGIN
      Data[Size]:=C;
      Inc(Size);
    END;
  END;
  Close(F);
  FillChar(Probab,Sizeof(Probab),0);
  FOR i:=0 TO Size-1 DO Inc(Probab[Data[i]]);
END;

{ Analyzes the character stream and builds the translation table in Chars }
{ Index[] keeps track of the current base of the number, Code[] contains }
{ the digits }
PROCEDURE GetChars;
VAR i:INTEGER;
    C:CHAR;
BEGIN
  Chars:='';
  FOR i:=0 TO Size-1 DO BEGIN
    C := Data[i];
    Index[i] := Length(Chars)+1;
    Code[i] := Pos(C,Chars);
    IF (Pos(C,Chars)=0) AND (Probab[C]>2) THEN BEGIN
      Chars:=C+Chars;
    END;
  END;
END;

{ Calculate the number }
PROCEDURE MakeNumber;
VAR i,j:INTEGER;
    q:INTEGER;
BEGIN
  FillChar(a,Sizeof(a),0);
  Writeln('TextSize equ ',Size);
  FOR i:=Size-1 DOWNTO 0 DO BEGIN
    FillChar(b,Sizeof(b),0);
    IF Pos(Data[i],Chars)=0 THEN BEGIN          { characters not in alphabet }
      FOR j:=999 DOWNTO 1 DO a[j+1] := a[j];    { are encoded using an "escape" }
      a[1] := Ord(Data[i]);
      Multiply(a,Index[i]+1);
    END ELSE BEGIN
      Multiply(a,Index[i]+1);
      b[1] := Code[i];
      Inc(b[1]);
      Add(a,b);
    END;
  END;
END;

{ print the TASM-includable encrypted text }
PROCEDURE Output;
VAR i,j:INTEGER;
BEGIN
  Writeln('TransLen equ ',Length(Chars));
  Write('TransTab db ');
  FOR i:=1 TO Length(Chars) DO BEGIN
    IF i>1 THEN Write(',');
    Write(Ord(Chars[i]));
  END;
  Writeln;
  j:=1000;
  WHILE a[j]=0 DO Dec(j);
  Writeln('HugeNumLen equ ',j);
  Write('HugeNum ');
  FOR i:=j DOWNTO 1 DO Writeln('db ',a[i]);
  Writeln('; ',j,' bytes number (',8*j,' bits), ',Length(Chars),' transtab');
  Writeln('; ',j+Length(Chars),' total');
  {Write(';');
  FOR i:=j DOWNTO 2 DO Write(' ',a[i]-a[i-1]);}
END;

BEGIN
  ReadFile;
  GetChars;
  MakeNumber;
  Output;
END.
