/***************************************************************
 *       TXT-Pack v0.52b  -  the smaller the better :)         *
 *                                                             *
 *    Entry for HUGI-size-coding-compo 2, by  Jibz  '98    *
 ***************************************************************/

#include <string.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <conio.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>

#define MAXMATCHLEN 4090
#define MAXMATCHPOS 511

// File-stuff
int pl = -1, pl2 = -1;   // pl - source file, pl2 - destination file

// HANDLER array will contain assembled handler
unsigned char handler[128] = {
  0xbe, 0x45, 0x01, 0xbd, 0x3c, 0x01, 0xd1, 0xef, 0x57, 0xb2,
  0x80, 0x33, 0xdb, 0xb1, 0x07, 0xff, 0xd5, 0x13, 0xdb, 0xe2,
  0xfa, 0x93, 0xaa, 0xff, 0xd5, 0x73, 0xf0, 0x33, 0xc0, 0xac,
  0x93, 0xff, 0xd5, 0x13, 0xdb, 0x74, 0x12, 0x41, 0xff, 0xd5,
  0x13, 0xc9, 0xff, 0xd5, 0x72, 0xf8, 0xf7, 0xdb, 0x8a, 0x01,
  0xaa, 0xe2, 0xfb, 0xeb, 0xe0, 0x5a, 0xb4, 0x09, 0xcd, 0x21,
  0x02, 0xd2, 0x75, 0x04, 0xac, 0x92, 0x12, 0xd2, 0xc3
};
unsigned int handler_size = 69;

struct MATCH {
        int pos;
        int len;
} match, nextmatch;

// Global variables used
unsigned int plsize, pl2size;
unsigned int packedsize;
unsigned char *outbuffer = NULL, *inbuffer = NULL;
unsigned char *output = NULL, *input = NULL, *tagbyte = NULL;
unsigned int tagpos = 0;

// FUNCTIONS................................

// Well, actually 2*log2(n)-2 8)
inline int log2x(int n)
{
  if (n < 4) return (2);
  if (n < 8) return (4);
  if (n < 16) return (6);
  if (n < 32) return (8);
  if (n < 64) return (10);
  if (n < 128) return (12);
  if (n < 256) return (14);
  if (n < 512) return (16);
  if (n < 1024) return (18);
  if (n < 2048) return (20);
  if (n < 4096) return (22);
  if (n < 8192) return (24);
  if (n < 16384) return (26);
  if (n < 32768) return (28);
  if (n < 65536) return (30);
return (32);
}

// Returns the number of bits it would take to encode antal literals
int getLITERALlength(unsigned int antal)
{
        return (antal*8);
}

// Returns the number of bits it would take to encode the match
int getCODEPAIRlength(unsigned int pos, unsigned int len)
{
        unsigned int worklen;
        unsigned int workpos;
        int testing = 0;

        if (pos == 0) return(200);
        if (len < 2) return(200);

        // To code that a match follows
        testing = 1;

        // Coding of position
        workpos = (pos >> 8) + 2;
        testing += 1;
        testing += 8;

        // Coding of length
        worklen = len;
        testing += log2x(worklen);

        return (testing);
}

void advancetagbyte(int bit)
{
        if (tagpos == 8)
        {
                tagpos = 0;
                tagbyte = output;
                output++;
        }

        *tagbyte = ((*tagbyte) << 1) + bit;
        tagpos++;
}

// Output Gamma-code for val in range [2..?] ...
void outputGAMMA(unsigned int val)
{
        unsigned int invert = 0;
        int invertlen = 0;

        while (val > 1)
        {
                invert = (invert << 1) | (val & 0x0001);
                invertlen++;
                val >>= 1;
        }

        while (invertlen > 1)
        {
                advancetagbyte(invert & 0x0001);
                advancetagbyte(1);
                invert >>= 1;
                invertlen--;
        }

        advancetagbyte(invert & 0x0001);
        advancetagbyte(0);
}

void outputLITERAL(unsigned char lit)
{
        advancetagbyte(0);
        advancetagbyte((lit >> 6) & 0x01);
        advancetagbyte((lit >> 5) & 0x01);
        advancetagbyte((lit >> 4) & 0x01);
        advancetagbyte((lit >> 3) & 0x01);
        advancetagbyte((lit >> 2) & 0x01);
        advancetagbyte((lit >> 1) & 0x01);
        advancetagbyte((lit     ) & 0x01);
}

void outputCODEPAIR(unsigned int pos, unsigned int len)
{
        unsigned int worklen;
        unsigned int workpos;

        advancetagbyte(1);

        *output = (pos >> 1) & 0x00ff;
        output++;

        advancetagbyte(pos & 0x01);

        worklen = len;

        outputGAMMA(worklen);
}

void findmatch(MATCH *thematch, unsigned char *buffer, int lookback, int lookforward)
{
        int matchlen = 0;
        int matchpos = 0;
        int i;

        thematch->pos = 0; thematch->len = 0;

        for (i = lookback; i > 1; i--)
        {
           matchlen = 0;
           while ((*(buffer - i + matchlen) == *(buffer + matchlen)) && (matchlen < lookforward))
           {
                matchlen++;
           }
           if (matchlen >= thematch->len)
           {
                thematch->len = matchlen;
                thematch->pos = i;
           }
        }
}

void outputEOD()
{
        // MATCH
        advancetagbyte(1);

        // lo-nibble of pos = 0
        *output = 0;
        output++;

        // hi-nibble of pos = 0
        advancetagbyte(0);

        // Shift into position
        *tagbyte = (*tagbyte) << (8-tagpos);
}

// Some I/O error handler :)
void error(int n)
{
        printf("\n\n\007ERR: ");
        switch (n)
        {
                case 1: printf("Unable to open input-file!\n"); break;
                case 2: printf("Unable to create 'TEXTTMP.$$$'!\n"); break;
                case 3: printf("Not enough memory!\n"); break;
                case 4: printf("Unable to write to output-file!\n"); break;
                case 5: printf("Input-file is too big!\n"); break;
                default: printf("An unknown error occured!\n");
        }
        if (outbuffer != NULL) free(outbuffer);
        if (inbuffer != NULL) free(inbuffer);
        if (pl != -1) close(pl);
        if (pl2 != -1) close(pl2);
        remove("TEXTTMP.$$$");
        exit(n);
}

// Print syntax
void syntax()
{
                printf("  Syntax:   TXTPack <input file> [output file]\n\n");
}

// Here main code begins!
int main(int argc, char *argv[])
{
        unsigned int i, j, ile, lasti;
        unsigned char ch;
        int infilearg = 0, outfilearg = 0;

        pl = -1;

        printf("\n");
        printf("TXT-Pack v0.52                                                by  Jibz  '98\n");
        printf("\n\n");

        // Write syntax when not enough parameters
        if (argc < 2)
        {
                syntax();
                return(1);
        }

        // Parse command line
        for (i = 1; i < argc; i++)
        {
                if (infilearg != 0)
                {
                        if (outfilearg == 0) outfilearg = i;
                } else infilearg = i;
        }

        // print syntax if no in-file
        if (infilearg == 0)
        {
                syntax();
                return(1);
        }

        printf(" Opening files\n");

        // Open source file
        if ((pl = open(argv[infilearg], O_RDONLY | O_BINARY)) == -1) error(1);

        lseek(pl, 0, SEEK_SET);
        plsize = filelength(pl);

        printf("   - Text size    : %lu bytes\n", plsize);

        // Error if too big
        if (plsize > 1024) error(5);

        // Create tmp file
        if ((pl2 = open("TEXTTMP.$$$", O_WRONLY | O_CREAT | O_BINARY | O_TRUNC, S_IREAD | S_IWRITE)) == -1) error(2);

        printf(" Allocating memory\n");
        // Allocate memory for compression buffers
        if ((inbuffer = input = (unsigned char *) malloc(plsize+512)) == NULL) error(3);
        if ((outbuffer = output = (unsigned char *) malloc(((plsize*9)/8)+512)) == NULL) error(3);

        // Read text
        lseek(pl, 0, SEEK_SET);
        read(pl, inbuffer, plsize);

        // Add a '$' for the print-function
        inbuffer[plsize] = '$';
        plsize++;

        // The first input byte has to be packed as a literal
        tagpos = 8;
        advancetagbyte(((*input) >> 6) & 0x01);
        advancetagbyte(((*input) >> 5) & 0x01);
        advancetagbyte(((*input) >> 4) & 0x01);
        advancetagbyte(((*input) >> 3) & 0x01);
        advancetagbyte(((*input) >> 2) & 0x01);
        advancetagbyte(((*input) >> 1) & 0x01);
        advancetagbyte(((*input)     ) & 0x01);
        input++;


        // Pack it (input -> output)...
        for (i = 1; i < plsize; )
        {
          findmatch(&match, input, ((i > MAXMATCHPOS) ? MAXMATCHPOS : i), (((plsize - i) > MAXMATCHLEN) ? MAXMATCHLEN : (plsize - i)));

          if ((match.len >= 2) && (getCODEPAIRlength(match.pos, match.len) <= getLITERALlength(match.len)))
          {
              findmatch(&nextmatch, input + 1, ((i + 1 > MAXMATCHPOS) ? MAXMATCHPOS : i + 1), (((plsize - (i + 1)) > MAXMATCHLEN) ? MAXMATCHLEN : (plsize - (i + 1))));

              ile = 0;
              if (match.len <
                  (nextmatch.len +
                   (
                    (
                     (getCODEPAIRlength(match.pos, match.len) -
                      getCODEPAIRlength(nextmatch.pos, nextmatch.len))
                    ) / 2
                   )
                  )
                 ) ile = 1;

              if (ile == 0)
              {
                outputCODEPAIR(match.pos, match.len);
                input += match.len;
                i += match.len;
              } else {
                outputLITERAL(*input);
                input++;
                i++;
              }
          } else {
              outputLITERAL(*input);
              input++;
              i++;
          }
        }

        // Output EOD-marker
        outputEOD();

        // Save unpacker
        write(pl2, handler, handler_size);
        printf(" Unpacker added               -> %u bytes\n", handler_size);

        // Save packed data
        write(pl2, outbuffer, output - outbuffer);
        pl2size = filelength(pl2);
        printf(" Packed text added            -> %u bytes\n", output - outbuffer);

    // Free memory for compression buffers
    printf(" Freeing memory\n");
    if (outbuffer != NULL) free(outbuffer);
    if (inbuffer != NULL) free(inbuffer);

    // close in and out files
    printf(" Closing files\n");
    if (pl != -1) close(pl);
    if (pl2 != -1) close(pl2);

    // Rename temp-file to output-file
    if (outfilearg != 0)
    {
            if (remove(argv[outfilearg]) != 0) if (errno == EACCES) error(4);
            if (rename("TEXTTMP.$$$", argv[outfilearg]) != 0) error(4);
    } else {
              printf("   - No output file specified ... writing to 'TEXTOUT.COM'\n");
              if (remove("TEXTOUT.COM") != 0) if (errno == EACCES) error(4);
              if (rename("TEXTTMP.$$$", "TEXTOUT.COM") != 0) error(4);
    }

    // Output ratio
    printf("\nDone ... compression ratio: %d%% ", 100 - ((pl2size * 100) / plsize));
    printf("(%lu bytes -> %lu bytes)\n", plsize, pl2size);

    return (0);
}
