;***************************************************************
;*   TXT-Pack v0.52b unpacker  -  the smaller the better :)    *
;*                                                             *
;*    Entry for HUGI-size-coding-compo 2, by  Jibz  '98    *
;***************************************************************

SEGM   segment byte public use16
ASSUME cs:segm, ds:segm

.386

ORG 100h

start:
    mov     si, offset (packeddata)
    mov     bp, offset (getbit)
    shr     di, 1             ; unpack to middle of segment
    push    di                ; save for printing
    mov     dl, 80h           ; init getbit

literal:
    xor     bx, bx            ; get 7 bits, and output
    mov     cl, 7
getbits:
    call    bp
    adc     bx, bx
    loop    getbits
    xchg    ax, bx
    stosb
nexttag:
decode:
    call    bp                ; get a tagbit
    jnc     literal

    xor     ax, ax            ; get 9 bit pos
    lodsb
    xchg    ax, bx
    call    bp
    adc     bx, bx
    jz      donedepacking

    inc     cx                ; cx=0, since 1st char is a literal
getgammaloop:
    call    bp                ; get gamma2-encoded len
    adc     cx, cx
    call    bp
    jc      getgammaloop

domatch:
    neg     bx                ; copy match
copydata:
    mov     al, ds:[di+bx]
domatch_continue:
    stosb
    loop    copydata
    jmp     short nexttag

donedepacking:
    pop     dx                ; print text and exit
    mov     ah, 09h
    int     21h

getbit:
    add     dl, dl            ; get a bit in carry
    jnz     stillbitsleft
    lodsb
    xchg    ax, dx
    adc     dl, dl            ; carry is set from above
stillbitsleft:
    ret

packeddata:                                     ;here the packed data
                                                ;will be saved
segm ENDS;
END start;
