PROGRAM Packer;
CONST Max_Size = 1024;
VAR Com_File, Txt_File, Dst_File : File;
    Com_FileSize, Txt_FileSize, Packed_Size : Word;
    Com_FileName, Txt_FileName, Dst_FileName : String;
    Com_Buffer : ARRAY[0..Max_Size] OF Byte;
    Txt_Buffer : ARRAY[0..Max_Size] OF Byte;
    Dst_Buffer : ARRAY[0..Max_Size] OF Byte;
    String_Buffer : ARRAY[0..Max_Size] OF Byte;
    String_Size : Byte;

PROCEDURE Check_CommandLine;
BEGIN
     IF ParamCount >= 3 THEN BEGIN
        Com_FileName := ParamStr(1);
        Txt_FileName := ParamStr(2);
        Dst_FileName := ParamStr(3);
            Writeln(Com_FileName,' + ', Txt_FileName,' = ', Dst_FileName);
     END
     ELSE BEGIN
          Writeln('Error in CommandLine');
          Writeln('Usage: PACK-IT.EXE IN.COM IN.TXT OUT.COM');  
          Halt(1);
     END;
END;

PROCEDURE Open_Files;
BEGIN
     Assign(Com_File, Com_FileName); ReSet(Com_File,1); BlockRead(Com_File, Com_Buffer, Max_Size, Com_FileSize);
     Assign(Txt_File, Txt_FileName); ReSet(Txt_File,1); BlockRead(Txt_File, Txt_Buffer, Max_Size, Txt_FileSize);
     Assign(Dst_File, Dst_FileName); ReWrite(Dst_File,1);
END;

PROCEDURE Close_Files;
BEGIN
     Close(Com_File);
     Close(Txt_File);
     Close(Dst_File);
END;

FUNCTION Find_String(Kohta : Word; Etsittava : String; Mista : ARRAY OF Byte) : Boolean;
VAR Laskuri : Word;
BEGIN
FOR Laskuri := Kohta TO Kohta+Length(Etsittava)-1 DO BEGIN
    IF Byte(Etsittava[Laskuri-Kohta+1]) = Byte(Mista[Laskuri]+32) THEN Find_String := True
    ELSE BEGIN
        Find_String := False;
        Exit;
    END;
END;
END;

PROCEDURE Delete_Chars(Paikka, Pituus : Word);
VAR Laskuri : Word;
BEGIN
FOR Laskuri := Paikka TO Txt_FileSize-Pituus DO BEGIN
    Txt_Buffer[Laskuri] := Txt_Buffer[Laskuri+Pituus];
END;
Txt_FileSize := Txt_FileSize-Pituus;
END;

PROCEDURE Pack_Data;
VAR Strings : Text;
    Jonot : ARRAY[0..50] OF String;
    Offsetit : ARRAY[0..50] OF Byte;
    Count : Byte;
    Count2 : Byte;
    Place : Word;
    Laskuri : Word;
    Monta_Etsittavaa : Byte;
    Temp : Word;

BEGIN
Assign(Strings,'strings.txt');
ReSet(Strings);
Jonot[0] := Chr(13) + Chr(10); { Ensimminen vaihdettava on CR+LF }
Count := 0;
WHILE NOT Eof(Strings) DO BEGIN
    Inc(Count);
    Readln(Strings, Jonot[Count]);
END;
Monta_Etsittavaa := Count;
Count := 0;
Count2 := 0;
FOR Place := 0 TO Monta_Etsittavaa DO BEGIN
    Offsetit[Count2] := Count;
    String_Buffer[Count] := Length(Jonot[Place]);
    Inc(Count);
    FOR Laskuri := 1 TO Length(Jonot[Place]) DO BEGIN
        String_Buffer[Count] := Byte(Jonot[Place,Laskuri]);
        Inc(Count);    
    END;
    Inc(Count2);
END;
String_Size := Count;
{Write('Viimeinen offset: ',String_Size-Length(Jonot[Place])); Writeln(' MAX: ', 128+6+32);}

Temp := String_Size + (Com_Buffer[2] SHL 8) + Com_Buffer[1];
Com_Buffer[2] := Hi(Temp);
Com_Buffer[1] := Lo(Temp);

FOR Place := 0 TO Txt_FileSize DO Txt_Buffer[Place] := Txt_Buffer[Place] - 32;
FOR Count := 0 TO Monta_Etsittavaa DO BEGIN
    FOR Place := 0 TO Txt_FileSize DO BEGIN
        IF Find_String(Place, Jonot[Count], Txt_Buffer) = True THEN BEGIN        
            Txt_Buffer[Place] := Offsetit[Count] + 90;        
            Delete_Chars(Place+1, Length(Jonot[Count])-1);    
        END
    END;
END;


        Txt_Buffer[Txt_FileSize] := Ord('$')-32; { Let's replace EOF with $ }
        Packed_Size := Txt_FileSize+1;
        Move(Txt_Buffer, Dst_Buffer, Packed_Size);
END;

PROCEDURE Write_to_Disk;
VAR Test : Word;
BEGIN
     BlockWrite(Dst_File, Com_Buffer, Com_FileSize);
     BlockWrite(Dst_File, String_Buffer, String_Size);
     BlockWrite(Dst_File, Dst_Buffer, Packed_Size);
END;


BEGIN
Writeln('Miracle Packer for Hugi-compo #2. Copyright (c) 1998 Taneli Riihonen (Iustus)');

Check_CommandLine;
Open_Files;
Pack_Data;
Write_to_Disk;

Close_Files;
END.
