/******************************************************************
  WHAT:
    Io Paq
    Entry for Hugi size compo 2
    String compression program
  WHO:
    Io Development entry (iodevelopment@angelfire.com)
    Just browsed the pre-results and most entries have a handle.
    So my handle (just thought of it) is BY ECK CHOOK
    (Real name: Carl S. Morris)
  WHERE:
    Cardiff, United Kingdom
  HOW:
    Written in Borland C, should also compile with other C compilers
    Squeezes ASCII bytes into nibble offsets into character arrays
  SIZE:
    Compressed text size is 466 bytes, but my lack of size optimisation
    knowledge lets me down (code is 250 bytes).  Total size is 716 bytes,
    which won't get me very far judging by the pre-results
  FILES:
    code.asm    - assembly source code for uncompressor
    code.dat    - object code for use by iopaq
    iopaq.c     - this source code for main compressor
    iopaq.exe   - main compressor program
    iounpaq.com - uncompressor program, generated by iopaq.exe
    makedat.bat - batch file to make code.dat from code.asm
    text.txt    - infant book quote for compression
  WHY:
    Fun fun fun - you don't honestly think I expected to win, did you?
  WHEN:
    Late June 1998 - World Cup fever has just ended as far as I'm
    concerned because England are now out (Scotland also)
  PLUG:
    Check out the Io Development web site
    http://www.angelfire.com/biz/iodevelopment
******************************************************************/


#include <stdio.h>
#include <string.h>

void storenibble(char data);   /* writes a nibble to string */
int testcommon(char c);        /* tests if c is in the common char array */
int testrare(char c);          /* tests if c is in the rare char array */

/* common and rare characters contained in text.txt */
char common[15] = " eaoltnrishpfm";
char rare[16]   = "dycu.wvg,Sk?PTq";
/* very rare "B-INOY" are stored as ascii codes */

/* nibble compression codes for next nibble type */
#define COMPRARE 15
#define COMPSTR  14

/* number of common strings */
#define STRCOUNT 9

/* common strings for storage as single bytes */
char comstr[STRCOUNT][10] = {
  "different",
  "people ",
  "places",
  "earth",
  "Some",
  "the",
  "are",
  ".  ",
  "\n"   /* fgetc reads it as '\n' but it is actually 13, 10 */
};

/* lengths of strings */
char comlen[STRCOUNT] = { 9, 7, 6, 5, 4, 3, 3, 3, 1 };

/* final compressed string */
unsigned char outstr[750];

/* which nibble to write to in current byte */
enum { HI, LO };


int main(void)
{
  FILE *text, *code, *out;
  int i, off, try;
  char mainstr[904], trystr[7];
  unsigned char shl;

  /**************************load files************************************/

  text = fopen("text.txt", "rt");   /* attempt to open text.txt */
  /* if the file could not be opened, give error message */
  if(text == NULL) {
    puts("Could not open text.txt");
    return 1;
  }

  code = fopen("code.dat", "rb");   /* attempt to open code.dat */
  /* if the file could not be opened, give error message */
  if(text == NULL) {
    puts("Could not open code.dat");
    return 1;
  }
  
  /* read text from file */
  for(i = 0; i < 903; i++)
    mainstr[i] = fgetc(text);

  /* read unpaq code from file (250 bytes - could probably cut this
     in half but I don't know much about size optimisation yet) */
  for(i = 0; i < 250; i++)
    outstr[i] = fgetc(code);

  /**************************compression***********************************/

  /* compress into nibbles */
  for(i = 0; i < 903; i++) {

    /* go through all the common strings */
    for(try = 0; try < STRCOUNT; try++) {

      /* prepare strings for comparison */
      strncpy(trystr, mainstr + i, comlen[try]);
      *(trystr + comlen[try]) = '\0';      /* pesky strncpy doesn't do this */

      /* try current position for match with current comstr string */
      if(!strcmp(trystr, comstr[try])) {
        /* yes we have match */
        storenibble(COMPSTR);
        storenibble(try);
        i += comlen[try];
        continue;
      }
    }

    /* get offset of char in common characters array */
    off = testcommon(mainstr[i]);
    if(off != -1) {
      /* its a common character so store it as a nibble (4 bits)
         representing the offset of the char in the common array */
      storenibble(off);
      continue;
    }

    /* get offset of char in rare characters array */
    off = testrare(mainstr[i]);
    if(off != -1) {
      /* it is a rare character - store it as 1111 (binary) followed by
         the offset of the char in the rare array.  no space saving but
         don't worry because this is a rare character */
      storenibble(COMPRARE);
      storenibble(off);
    }
    else {
      /* character is very rare, one of these: "-BINOY"
         store as 1111, followed by 1111, followed by the char itself
         This takes 2 bytes but this is a very rare character */
      storenibble(COMPRARE);
      storenibble(COMPRARE);
      storenibble(mainstr[i] >> 4);
      shl = mainstr[i] << 4;
      storenibble(shl >> 4);
    }
  }

  /**************************com file**************************************/

  out = fopen("iounpaq.com", "wb");
  /* if the file could not be opened, give error message */
  if(out == NULL) {
    puts("Could not create iounpaq.com");
    return 1;
  }

  /* write the com file */
  for(i = 0; i < 716; i++)
    fputc(outstr[i], out);

  puts("Success - iounpaq.com created");

  fcloseall();
  return 0;
}


int testcommon(char c)
{
  int j;

  /* test character against all common characters */
  for(j = 0; j < 14; j++)
    if(c == common[j])
      return j;         /* yes, we have a match */

  /* not a common character */
  return -1;
}


int testrare(char c)
{
  int j;

  /* test character against all rare characters */
  for(j = 0; j < 16; j++)
    if(c == rare[j])
      return j;         /* yes, we have a match */

  /* not a rare character */
  return -1;
}


void storenibble(char data)
{
  static byteoff = 250, where = HI;

  if(where == HI) {                     /* if we're storing a hi nibble */
    outstr[byteoff] = data << 4;        /* store in the high nibble */
    where = LO;                         /* write a lo nibble next time */
  }
  else {                                /* if we're storing a lo nibble */
    outstr[byteoff] += data;            /* add the lo nibble to the byte */
    byteoff++;                          /* new byte next time */
    where = HI;                         /* hi nibble next time */
  }
}
