; Carl Morris, Io Development
;     http://www.angelfire.com/biz/iodevelopment
; This is the code required to unpaq the compressed text
; Compile to code.dat for iopaq.exe to open and use when
; creating iounpaq.com.  Use the following commands:
;     tasm /m5 /c /la code.asm > errors.asm
;     tlink /t /l /m code.obj
;     ren code.com code.dat
; Used rename command because code.com is not to be executed
; directly.  It will just read junk underneath it in memory
; and unpaq it and spout lots of garbage.


.model tiny
.386

.data

comstr db 'different$'
       db 'people $  '
       db 'places$   '
       db 'earth$    '
       db 'Some$'

       ; this is code to fill up the array padding
       lonibble:
       add dl, cl     ; put the lo nibble in the lo part of dl
       jmp nextpchar  ; go and print the char

       db 'the$      '
       db 'are$      '
       db '.  $      '
       db 13, 10, '$'

common db ' eaoltnrishpfm'
rare   db 'dycu.wvg,Sk?PTq'

mainstr db          ; we will tack the compressed data on here (end of file)
                    ; this produces a warning because there is no data here
                    ; don't worry about it

.code
org 100h

start:

mov bx, offset mainstr          ; pointer to string to be unpaqed
do1:
  mov cl, [bx]                  ; get byte
  test ch, 1                    ; are we on the lo nibble?
  jz sright                     ; if no do 1 shift to isolate the hi nibble
  shl cl, 4                     ; if yes do 2 shifts to isolate the lo nibble
sright:                      
  shr cl, 4                    

  push bx                       ; save bx (use it for pointing and restore later)

  test ch, 8                    ; was the last nibble a string indicator?
  jnz stringprint               ; yes, print string

  test ch, 2                    ; no, was the last nibble a rare indicator?
  jz checkforrare               ; no, check the current nibble

  test ch, 4                    ; yes, was the one before that a vrare indicator?
  jnz veryrare                  ; yes, print the very rare character
  cmp cl, 15                    ; no, check the current nibble
  jne rareprint                 ; no, print the rare
  xor ch, 4                     ; yes, set vrare flag
  jmp nextnorm                  ; go to the next nibble

checkforrare:
  cmp cl, 15                    ; are we on a rare or vrare char indicator?
  jne checkforstr               ; no, go to check for string
  or ch, 2                      ; yes, set rare flag
  jmp nextnorm                  ; go to the next nibble

checkforstr:
  cmp cl, 14                    ; have we hit a string indicator?
  jne commonprint               ; no, must be a common char
  or ch, 8                      ; yes, set string flag
  jmp nextnorm                  ; go to the next nibble

  ;********************************************************************

stringprint:
  mov al, 10                    ; 10 chars per string
  mul cl                        ; work out byte offset in string array
  add ax, offset comstr         ; work out actual byte offset in memory
  mov dx, ax                    ; pointer must be in dx for print str func
  mov ah, 9                     ; function 9
  jmp nextint                   ; go and print string from end of file table

  ;********************************************************************

veryrare:
  cmp dl, 0                     ; have we already loaded the ascii hi nibble?
  jne cs:lonibble               ; yes, load the lo nibble and print

  mov dl, cl                     ; no, get hi nibble
  shl dl, 4                      ; put it in the hi nibble part of dl
  jmp nextnoccl                  ; loop but don't clear our hi nibble

;lonibble:                        ; this has been put in the array padding, above
;  add dl, cl                     ; put the lo nibble in the lo part of dl
;  jmp nextpchar                  ; go and print the char

  ;********************************************************************

rareprint:
  xor bh, bh                    ; use bx as pointer (orig bx pushed)
  mov bl, cl                    ; get array offset of rare character
  add bx, offset rare           ; calculate mem address of char
  jmp nextpchar                 ; go print the char

  ;********************************************************************

commonprint:
  xor bh, bh                    ; use bx as pointer (orig bx pushed)
  mov bl, cl                    ; get array offset of rare character
  add bx, offset common         ; calculate mem address of char

  ;********************************************************************

nextpchar:
  mov ah, 2                     ; function 2
  mov dl, [bx]                  ; put char in dl for print char function
nextint:
  int 21h                       ; print character
  and ch, 1                     ; clear all indicators except hi/lo (bit 1)
nextnorm:
  xor dl, dl                    ; clear character
nextnoccl:
  xor ch, 1                     ; toggle nibble (hi/lo)
  pop bx                        ; restore bx (has been used for pointing)
  test ch, 1                    ; if we just did a hi nibble
  jnz do1                       ; then loop and do the lo nibble
  inc bx                        ; we just did a lo nibble, go to next char
  cmp bx, [offset mainstr+466]  ; have we done the whole string?
  jb do1                        ; no - do the next character
ret                             ; yes - exit

end start

