// Contribution to hugicompo #2
// Coded by Mikael Klasson aka Fluff
// fluff@geocities.com
// http://fluff.home.ml.org

#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE	2000

#define TRUE		-1
#define FALSE		0


FILE	*gout;
FILE    *goutdata;
char	gubuf[MAX_SIZE];
char	gpbuf[MAX_SIZE];
int 	gulen = 0;
int 	gplen = 0;
int 	gcnt[256];
int 	gorder[256];
int 	gibits = 0;
int 	gioutput = 0;


int main( void )
{
	add_com();

	read_data();

	dist();

	pack_data();

	add_table();

	add_data();

	fclose( gout );

	return 0;
}


void add_data( void )
{
	int 	i;

	for( i = 0; i < gplen; i++ ) {
		fputc( gpbuf[i], gout );
        fputc( gpbuf[i], goutdata );
	}
}


void add_table( void )
{
	int 	i;

	for( i = 0; i < 256; i++ ) {
		if( gcnt[gorder[i]] > 0 ) {
			fputc( gorder[i], gout );
            fputc( gorder[i], goutdata );
        }
	}
}


void pack_data( void )
{
	int 	i;
	int 	iorder;

	for( i = 0; i < gulen; i++ ) {
		if( ( iorder = order( gubuf[i] ) ) < 15 ) {
//            output( iorder, 4, FALSE );
            output( iorder + 1, 4, FALSE );
		} else {
//            output( 15, 4, FALSE );
            output( 0, 4, FALSE );
//            output( iorder - 15, 4, FALSE );
            output( iorder - 14, 4, FALSE );
		}
	}
//    output( ( 15 << 4 ) + 15, 8, TRUE );
    output( 0, 8, TRUE );
}


/*
 * returns the priority of c based on the number of times it occures in
 * text.txt
 */
int order( char c )
{
	int 	i;

	for( i = 0; i < 256; i++ ) {
		if( gorder[i] == c ) {
			return i;
		}
	}

	return -1;
}


/*
 * outputs ibits bits of ival to the compressed data section
 */
void output( int ival, int ibits, int iforce )
{
	gioutput = ( gioutput << ibits ) + ( ival & ( ( 2 << ibits ) - 1 ) );
	gibits += ibits;

	if( gibits >= 8 ) {
		gpbuf[gplen++] = gioutput >> ( gibits - 8 );
		gibits -= 8;
		gioutput &= ( 2 << gibits ) - 1;
	}
	if( iforce && ( gibits > 0 ) ) {
		gpbuf[gplen++] = gioutput << ( 8 - gibits );
		gibits = 0;
		gioutput = 0;
	}
}


void read_data( void )
{
	FILE	*in;

    if( !( in = fopen( "words.txt", "rb" ) ) ) {
		printf( "ERROR: Couldn't read text.txt!\n" );
		exit( 1 );
	}

	fseek( in, 0, SEEK_END );
	gulen = ftell( in );
	fseek( in, 0, SEEK_SET );

	fread( gubuf, gulen, 1, in );

	fclose( in );
}


void add_com( void )
{
	FILE	*in;
	int 	c;

	if( !( in = fopen( "base.com", "rb" ) ) ) {
		printf( "ERROR: Couldn't read base.com!\n" );
		exit( 1 );
	}

	if( !( gout = fopen( "fluff.com", "wb" ) ) ) {
		printf( "ERROR: Couldn't write fluff.com!\n" );
		exit( 1 );
	}

    if( !( goutdata = fopen( "words.pak", "wb" ) ) ) {
        printf( "ERROR: Couldn't write words.pak!\n" );
		exit( 1 );
	}

    while( ( c = getc( in ) ) != EOF ) {
		fputc( c, gout );
	}

	fclose( in );
}


void dist( void )
{
	FILE	*out;
	int 	i, i2, i3;

	if( !( out = fopen( "dist.txt", "wb" ) ) ) {
		printf( "ERROR: Couldn't write dist.txt!\n" );
		exit( 1 );
	}

	for( i = 0; i < 256; i++ ) {
		gcnt[i] = 0;
		gorder[i] = -1;
	}

	for( i = 0; i < gulen; i++ ) {
		gcnt[gubuf[i]]++;
	}

	for( i = 0; i < 256; i++ ) {
		for( i2 = 0; i2 < 256; i2++ ) {
			if( ( gorder[i2] == -1 ) || ( gcnt[i] > gcnt[gorder[i2]] ) ) {
				for( i3 = 255; i3 > i2; i3-- ) {
					gorder[i3] = gorder[i3 - 1];
				}
				gorder[i2] = i;
				break;
			}
		}
	}

	for( i = 0; i < 256; i++ ) {
		if( gcnt[gorder[i]] > 0 ) {
			fprintf( out, "%.2d  0x%.2X  '%c'  : %d\r\n", i, gorder[i], gorder[i], gcnt[gorder[i]] );
		}
	}

	fclose( out );
}
