{
 
	Huge Text Compressor

	Contribution to the Hugi Size Coding Competition #2

	Copyright (c) 1998 Anders Sandvig

 
}
program Text_Compressor;

uses
  CRT;

const
{
  Compression codes:

  5Bit ASCII

  0..25 - Letters

  Letters used:

  ABCDEFGHIJKLMNOPQRSTUVWXYZ
  xxxxxxxxx!xxxxxxxxxxxxx!x!
           9             2 2
                         3 5


  25    - "  "
  26    - " "
  27    - ","
  28    - "-"
  29    - "."
  30    - "?"
  31    - End of Text

  Other notes:
  Every line is 44 characters.
  All "blocks" end with "?"

}
  Append  = True;
  LineLen = 44;
  MaxLen  = 4096;

  DSpace  = 25;
  Space   = 26;
  Comma   = 27;
  Strike  = 28;
  Dot     = 29;
  QMark   = 30;
  EOT     = 31;

var
  F          : file;
  Source     : array[0..MaxLen] of Byte;
  Remapped   : array[0..MaxLen] of Byte;
  Compressed : array[0..MaxLen] of Byte;
  TextLen    : Word;
  PackLen    : Word;
  LineCount  : Word;

procedure PackText;
var
  tPos  : Word;
  rPos  : Word;
  pPos  : Word;
  A,B,C : Byte;
  W     : Word;

begin
  tPos := 0;
  rPos := 0;
  repeat
    B := Source[tPos];
    case UpCase(Char(B)) of
    #10,#13  : begin
                 Dec(rPos);
                 Inc(tPos);
               end;
    ' '      : begin
                 if Source[tPos + 1] = 32 then
		 begin
                   Remapped[rPos] := DSpace;
                   Inc(tPos);
                 end
                 else Remapped[rPos] := Space;
               end;
    '.'      : Remapped[rPos] := Dot;
    ','      : Remapped[rPos] := Comma;
    '?'      : Remapped[rPos] := QMark;
    '-'      : Remapped[rPos] := Strike;
    'A'..'Z' : begin
                 Remapped[rPos] := Ord(UpCase(Char(B))) - Ord('A');
               end;
    end;
    Inc(rPos);
    Inc(tPos);
    if tPos >= TextLen - 1 then
    begin
      Remapped[rPos] := EOT;
      Inc(rPos);
    end;
  until tPos >= TextLen - 1;

  FillChar(Compressed,MaxLen,'A');

  tPos := 0;
  rPos := 0;
  repeat
    A := Remapped[rPos + 0];
    B := Remapped[rPos + 1];
    C := Remapped[rPos + 2];
    Inc(rPos,3);
    W := A + B shl 5 + C shl 10;
    Compressed[tPos + 0] := Lo(W);
    Compressed[tPos + 1] := Hi(W);
    Inc(tPos,2);
  until (A = EOT) or (B = EOT) or (C = EOT);
  PackLen := tPos;
end;

procedure UnPackText;
const
  Cap : Byte = 32;

var
  rPos  : Word;
  tPos  : Word;
  pPos  : Word;
  A,B,C : Byte;
  W     : Word;

begin
  FillChar(Remapped,MaxLen,EOT);

  tPos := 0;
  rPos := 0;
  repeat
    W := Compressed[tPos + 0] + Compressed[tPos + 1] shl 8;
    Inc(tPos,2);
    A := W and 31;
    B := W shr 5 and 31;
    C := W shr 10 and 31;
    Remapped[rPos + 0] := A;
    Remapped[rPos + 1] := B;
    Remapped[rPos + 2] := C;
    Inc(rPos,3);
  until (A = EOT) or (B = EOT) or (C = EOT);

  rPos := 0;
  LineCount := 0;
  repeat
    B := Remapped[rPos];
    case B of
    Space   : Write(' ');
    DSpace  : begin
                Write('  ');
                Inc(LineCount);
              end;
    Dot     : begin
                Write('.');
                Cap := 32;
              end;
    Comma   : Write(',');
    QMark   : begin
                WriteLn('?');
                LineCount := 65535;
                Cap := 32;
              end;
    Strike  : Write('-');
    0..24   : begin
                Write(Char(B + - Cap + Ord('a')));
                Cap := 0;
              end;
    EOT     : begin
                WriteLn;
                Exit;
              end;
    end;
    Inc(rPos);
    Inc(LineCount);
    if LineCount = 44 then
    begin
      WriteLn;
      LineCount := 0;
    end;
  until False;
end;

begin
  Assign(F,'TEXT.TXT');
  ReSet(F,1);
  TextLen := FileSize(F);
  BlockRead(F,Source,TextLen);
  Close(F);

  ClrScr;
  PackText;
  WriteLn('Source text size  : ',TextLen : 5,' bytes');
  WriteLn('Packed text size  : ',PackLen : 5,' bytes');
  WriteLn('Compression ratio : ',100 - PackLen * 100 / TextLen : 5 : 0,' %');
  UnPackText;

  if Append then
  begin
    Assign(F,'WRITER.COM');
    ReSet(F,1);
    Seek(F,FileSize(F));
    BlockWrite(F,Compressed,PackLen);
  end
  else
  begin
    Assign(F,'TEXT.CMP');
    ReWrite(F,1);
    BlockWrite(F,Compressed,PackLen);
  end;
  Close(F);
  ReadKey;
end .