/* Hugi compo #2 - compressor by VectoR/DataKrackers (ilppis@freenet.hut.fi)
 *
 * Platform:
 *			It's designed to run/compile at least on Linux (GCC 2.7.2.1) but 
 *			the code is pretty "standard" and should compile at least in any 
 *			*nix and maybe with some DOS/WIN C/C++ compiler too... 
 *			All Linux specific functions are inside #ifdef...
 *			DOS/WIN require some header files, if you want to compile, figure
 *			them out... Filenames might require some tweaking too...
 *
 * Limitations:
 *			memmove() must be capable of moving overlapping data!!!
 *
 * In:
 *		  	text.txt..... (fixed input, even though nonfixed inputs should 
 *						   work too)
 *
 * Out:
 *		 	streamN.N.... Created Huffman stream
 *			usedN.N...... Used list for individual stream
 *			infoN.N...... "Critical" info required for stream processing
 *			single.0..... Chars mapped with 4-bit entry
 *			single.1..... Chars mapped with 8-bit entry
 *			ucase.lst.... Uppercase list
 *
 * Important notes:
 *			IT DOESN'T CREATE COM-FILE!!! Use docom instead!
 *
 * Description:
 *			It reads input data and counts characters in it, the most frequent
 *			characters do get 4-bit mapping whereas others get 8-bit mapping.
 *			any string longer than 1 char get 16-bit mapping. (CRLF gets 4-bit
 *			mapping, which it will be dealt on code level) Then it creates
 *			"stream of data" in which there is instead of byte boundaries
 *			nibble (4-bit) boundaries. If it's possible the 16-bit mappings are
 *			changed to 12-bit ones... comp is actually derived from "analyzer"
 *			I used to search the smallest Huffman like encoding. That's why
 *			it's still very complex :-( . I rewrote about 95% in it and still
 *			it look "generic encoder" which could handle different kinda
 *			input texts...
 */


#include <stdio.h>
#include <stdlib.h>

#ifdef __linux__
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>
#endif /* __linux__ */

#define	MAX_MULTI	32
#define MIN_MULTI	3
#define MAX_S		1024
#define USETOTAL	0x8
#define SORTUSELESS	0x10
#define ITERATE		1

#define LCASE
/* we have one free single char mapping left... lets fill it... */
#define SAVEUCASE	'S'
#define	CRLF2LF
//#define KILLLF
//#define NOTOK

#define DEBUGFLOW( x ) //printf( "FLOW; " x "\n" );fflush( NULL );

#define	calculatesaveptr(x) ((x->size - x->newsize) * (x->total) - (x->size) - 4)
#define calculateusedptr(x) ((x->size - x->newsize) * (x->used) - (x->size) - 4)

typedef struct{
	char	orig[ MAX_MULTI ];
	int		origsize;
	int		data;				/* stream data...*/
	char	packed[ MAX_MULTI ];
	int		size;				/* packed with singles size...*/
	int		newsize;			/* 4, 8, 16... */
	int		total;				/* up to this many */
	int		used;				/* we used this many */
	int		useless;
}STREAM;

typedef struct {
	int	stream;
	int	single0;
	int	single1;
	int	multisize;
	int	multicount;
	int	chars;
	int	bit12;
	int	ucases;
}CRIT;

/* Global data */
CRIT critical;
STREAM s[ MAX_S ];
STREAM **table;

char	buffer[ 1024 ];

int		last_s;
int		last_simple;
int		legal;
int		size, orig;
int		sortuseless = 0;
int		shortest = 0xffff;
int		iterations = ITERATE;

/* percentage which still gets saved... */
#define MAXSIZE 	999
#define	GOODTHRE	10

/* Protos... */
void	saveucase();
void	readbuffer();
int		output( int i );
int		outputbin( int i );
int		sorttotal( STREAM *a, STREAM *b );
void	calculate();
int		sortused( STREAM *a, STREAM *b );
int		nextfree( int a );
void	buildencodings( int method, int first, int last, int starting );
void	findmultiple();
int		printdata( STREAM *a );
void	printmappings( int last );
void	printtable( int last );
void	addmulti( int a, int c );
int		findmulti( char *src, int c );
void	encodesimple( int e );
int		sortordersize( STREAM *a, STREAM *b );
void	finduseless();
int		isuseless( int i );
void	saveconstant();
void	swapwithlast( int which );
int		huffstartsort( STREAM *a, STREAM *b );
void	dohuff( char *buff, int buffsize );
int		buildstream( char *to, int maxsize );
void	savestate( char *stream, int ssize, CRIT *crit );


char	*infile = "text.txt";

void	main()
{
	int i, a;
	char	*new;

	printf( "Reading text file...\n" );
	readbuffer();

	saveucase();	/* have to save now since they get changed in calculate() */

	printf( "Calculating amounts & adding to s[]...\n" );
	calculate();

	printf( "Mapping simple characters...\n" );
	buildencodings( USETOTAL, 0, last_simple, -1 );

	printf( "Searching multi-chars...\n" );
	findmultiple();

	buildencodings( USETOTAL, last_simple, last_s, 0xff );

	finduseless();

	sortuseless = 1;
	qsort( &(s[ last_simple ]), last_s - last_simple, sizeof( STREAM ), sorttotal );

	printf( "Saving all data...\n" );
	saveconstant();

	printf( "Preparing for Huffman...\n" );

#ifdef __linux__
	sync();
	srand( (int) time((time_t *)0) );		/* random seeding */
	setpriority( PRIO_PROCESS, 0, -20 );	/* Get some CPU time... ;-) */
#endif

	printf( "Starting...\n" );

	new = (char *) malloc( 1024 );
	if( new == NULL ) 
	{
/* should this ever happend in linux unless you have _REALLY_ little amount 
 * of mem, however, dos/win can fail???
 */
		printf( "Alloc failed, Get A LINUX!\n" );
		exit( 1 );
	}

	dohuff( new, 1024 );	/* godda do some kinda recursion */
							/* I just couldn't figure out other way :-( */

	printf( "We're done...\n" );
	printf( "Found smallest: %i\n", shortest );
}

void	readbuffer()
{
	FILE *in;
	int i;
	in = fopen( infile, "rb" );
	if( in == NULL )
	{
		printf( "error!\n" );
		exit( 1 );
	}
	size = fread( buffer, 1, 4096, in );
	orig = size;
	fclose( in );
}

int	output( int i )
{
	if( (i == 0xd) || (i == 0xa) )
	{
		printf( "\\n" );
		return( 2 );
	}
	else if( i == ' ' )
	{
		printf( "\\s" );
		return( 2 );
	}
	else if( i < 0x20 )
	{
		printf( "#" );
	}
	else
		printf( "%c", i );
	return( 1 );
}

/* Used by ancient analysing tool - OBSOLETE!!! 
int		outputbin( int i )
{
	int	a;
	for( a = 7; a >= 0; a-- )
	{
		printf( "%i", (i >> a) & 0x1 );
	}
	return( 8 );
}
//*/

void	calculate()
{
	int		count[ 256 ];
	int		i;

	for( i = 0; i < 256; i++ )
		count[ i ] = 0;

	for( i = 0; i < size; i++ )
	{
#ifdef	LCASE
#ifdef	SAVEUCASE
		if( buffer[ i ] != SAVEUCASE )
#endif
		buffer[ i ] = tolower( buffer[ i ] );
#endif
#ifdef	CRLF2LF
		if( buffer[ i ] == 0xd )
			memmove( buffer + i, buffer + i + 1, --size - i );
#endif
#ifdef	KILLLF
		if( buffer[ i ] == 0xa )
			memmove( buffer + i, buffer + i + 1, --size - i );
#endif
		count[ buffer[ i ] ]++;
	}

	for( i = 0; i < 256; i++ )
	{
		if( !count[ i ] ) continue;

		s[ last_s ].total = count[ i ];
		s[ last_s ].origsize = 1;
		s[ last_s ].orig[ 0 ] = i;
		s[ last_s ].orig[ 1 ] = 0;		/* null terminate */
		last_s++;

	}
	last_simple = last_s;
	return;
}


int	hufflen = 0;

void	buildencodings( int method, int first, int last, int starting )
{
	int	(*sortroutine)( STREAM *a, STREAM *b );
	int	i, mapto = starting, temp, temp2;

	DEBUGFLOW( "buildencodings" );

	if( method & USETOTAL )
		sortroutine = sorttotal;
	else
		sortroutine = sortused;
	if( method & SORTUSELESS )
		sortuseless = 1;
	else
		sortuseless = 0;

	qsort( &(s[ first ]), last - first, sizeof( STREAM ), sortroutine );

	i = first;
	while( i < last ){
		mapto = nextfree( mapto );

		do{
			temp = s[ i ].newsize;
			s[ i ].newsize = hufflen;
			temp2 = isuseless( i );
			s[ i ].newsize = temp;
		}while( (s[ i ].origsize > 1) && temp2 && (i++ < last) );

		s[ i ].data = mapto;
		s[ i ].newsize = hufflen;
		i++;
	}

	for( i = first; i < last; i++ )
	{
		if( s[ i ].newsize != 0 ) continue;
		s[ i ].data = 0;
		s[ i ].newsize = 16;
	}

	qsort( &(s[ first ]), last - first, sizeof( STREAM ), sortroutine );

	DEBUGFLOW( "end:buildencodings" );
}

int	nextfree( int a )
{
	if( a <= 0 )
	{
		hufflen = 4;
		return( 1 );
	}
	else if( a >= 0x100 )
	{
		hufflen = 16;
		a = ((a>>8) + 1 << 8);
		if( a >= 0x10000 )
		{
			printf( "HUFF: warning! out of mappings!\n" );
			return( 0x0100 );
		}
	}
	else if( a >= 0x10 )
	{
		hufflen = 8;
		a = ((a>>4) + 1 << 4);
		if( a >= 0x100 )
			hufflen = 16;
	}
	else
	{
		hufflen = 4;
		a++;
		if( a == 0x10 )
			hufflen = 8;
	}
	return( a );
}

int	sortorderuseless( STREAM *a, STREAM *b )
{
	if( a->useless )
		return( 1 );
	if( b->useless )
		return( -1 );
	if( a->newsize >= a->size )
		return( 1 );
	if( b->newsize >= b->size )
		return( -1 );

	return( 0 );
}

int	sorttotal( STREAM *a, STREAM *b )
{
	int	t = 0;
	if( sortuseless )
		t = sortorderuseless( a, b );
	if( t ) return( t );

	if( a->total > b->total )
		return( -1 );
	if( a->total < b->total )
		return( 1 );
	return( 0 );
}


int	sortused( STREAM *a, STREAM *b )
{
	int	t = 0;
	if( sortuseless )
		t = sortorderuseless( a, b );
	if( t ) return( t );

	if( a->used > b->used )
		return( -1 );
	if( a->used < b->used )
		return( 1 );
	return( 0 );
}

int		printdata( STREAM *a )
{
	int	i, temp=0;
	for( i = 0; i < a->origsize; i++ )
		temp += output( a->orig[i] );
	return( temp );
}

void	doprint( STREAM *i )
{
	int	temp = 0;

	printf( "data: " );
	temp = printdata( i );
	printf( "; " );
	printf( "\t" );
	if( temp < 8 )
		printf( "\t" );
/*	printf( "len: %i; ", i->origsize ); /* screen too crowded */
	printf( "siz: %i; ", i->size );
	printf( "new: %i; ", i->newsize );
	printf( "huf: %x; ", i->data );
	printf( "u/t: %i/%i; ", i->used, i->total );
	printf( "sav: %i;", calculateusedptr( i ) );
	printf( "\n" );

}

void	printmappings( int last )
{
	int	i;
	printf( "%i Mappings:\n", last );
	for( i = 0; i < last; i++ )
	{
		doprint( &(s[ i ]) );
	}
}
void	printtable( int last )
{
	int	i;
	printf( "%i Table:\n", last );
	for( i = 0; i < last; i++ )
	{
		doprint( table[ i ] );
	}
}


void	findmultiple()
{
	int	i, j, c;

	DEBUGFLOW( "findmultiple" );

	for( i = 0; i < size; i++ )
	{
		for( j = 0; j < size; j++ )
		{
			if( i == j ) continue;
			for( c = MIN_MULTI; c < MAX_MULTI; c++)
			{
				if( (i + c >= size) || (j + c >= size) ) break;
				if( memcmp( buffer + i, buffer + j, c ) ) break;

				if( findmulti( buffer + i, c ) >= 0 ) break;
				addmulti( i, c );
			}
		}		
	}
	DEBUGFLOW( "end:findmultiple" );
}

int	findmulti( char *src, int c )
{
	int	i;
//	DEBUGFLOW( "findmulti" );			/* Spam removed */
	for( i = 0; i < last_s; i++ )
	{
		if( s[ i ].origsize == c )
			if( !memcmp( src, &(s[ i ].orig), c ) )
			{
//				DEBUGFLOW( "end1:findmulti" );
				return( i );
			}
	}
//	DEBUGFLOW( "end0:findmulti" );
	return( -1 );
}

void	addmulti( int a, int c )
{
	int i;

	s[ last_s ].total = 0;
	memcpy( &(s[ last_s ].orig), buffer + a, c );
	s[ last_s ].origsize = c;
	for( i = 0; i < size - c; i++ )
	{
		if( memcmp( buffer + i, buffer + a, c ) ) continue;
		s[ last_s ].total++;
	}
	s[ last_s ].used = s[ last_s ].total;
	last_s++;
	encodesimple( last_s - 1 );
}

void	encodesimple( int e )
{
	int i, a;
	int	index, temp, dest;

//	DEBUGFLOW( "encodesimple" );		/* KIll the SpAM */

	s[ e ].size = 0;
	dest = temp = index = 0;

	for( i = 0; i < s[ e ].origsize; i++ )
	{
		a = findmulti( &(s[ e ].orig[ i ]), 1 );
		if( a < 0 )
		{
			printf( "HUFF: warning! single char list invalid!\n" );
			s[ e ].size = -1;
			return;
		}
		s[ e ].size += s[ a ].newsize;
		temp += (s[ a ].data << index);
		index += s[ a ].newsize;
		while( index >= 8 )
		{
			s[ e ].packed[ dest++ ] = temp & 0xff;
			temp >>= 8;
			index -= 8;
		}
	}
	while( index > 0 )
	{
		s[ e ].packed[ dest++ ] = temp & 0xff;
		temp >>= 8;
		index -= 8;
	}
//	DEBUGFLOW( "end:encodesimple" );
}

int	isuseless( int i )
{
	int	temp;

	if( s[ i ].origsize == 1 ) return( 0 );
	
	temp = (s[ i ].size - s[ i ].newsize) * s[ i ].total;
	if( temp > s[ i ].size ) return( 0 );

	return( 1 );
}

/* too simple routine??? not in high speed part so I don't care... */
void	finduseless()
{
	int	i;
	for( i = 0; i < last_s; i++ )
	{
		if( isuseless( i ) )
			s[ i ].useless = 1;
		else
			s[ i ].useless = 0;
	}
	
}


void	saveconstant()
{
	FILE	*out;
	int		a, i, dest;
	char	data[ 1024 ];

	DEBUGFLOW( "saveconstant" );

	out = fopen( "single.0", "wb" );
	if( out == NULL )
	{
		printf( "Error!\n" );
		return;
	}
	dest = 0;
	for( i = 0; i < last_simple; i++ )
	{
		if( s[i].newsize == 4 )
			data[ dest++ ] = s[i].orig[0];
	}
	if( dest > 16 ) 
	{
		printf( "Error!\n" );
		return;
	}
	fwrite( data, 1, 16, out );
	fclose( out );

	out = fopen( "single.1", "wb" );
	if( out == NULL )
	{
		printf( "Error!\n" );
		return;
	}
	dest = 0;
	for( i = 0; i < last_simple; i++ )
	{
		if( s[i].newsize == 8 )
			data[ dest++ ] = s[i].orig[0];
	}
	if( dest > 16 )
	{
		printf( "Error!\n" );
		return;
	}
	fwrite( data, 1, 16, out );
	fclose( out );

	DEBUGFLOW( "end:saveconstant" );
}

char	*huffbuff;
int		huffbuffsize;

void	dohuff( char *buff, int buffsize )
{
	int i, a, b, c;

	legal = last_simple;

	for( i = last_simple; i < last_s; i++ )
	{
		if( s[i].data )
			legal++;
	}

	huffbuff = buff;
	huffbuffsize = buffsize;

	qsort( &(s[ 0 ]), legal, sizeof( STREAM ), huffstartsort );

	printmappings( legal ); 	/* SpAm removed */

/*  build pointer table!!! - No need...*/
	table = (STREAM **) malloc( MAX_S * sizeof( STREAM * ) );

	for( i = 0; i < legal; i++ )
		table[ i ] = &s[ i ];

	while( iterations-- )
	{
		i = buildstream( huffbuff, huffbuffsize );
		if( i < shortest ) 
		{
			printf( "*save it*\n" );
			savestate( huffbuff, i, &critical );
		}
		if( i < shortest ) shortest = i;

//#ifdef NOTOK
		printtable( legal );
//#endif
/*
		for( i = 0; i < legal - last_simple; i++ )
		{
#ifdef __linux__
			b = rand() % (legal - last_simple);
#else
#error	get random number here...
#endif
			for( a = 0; a < i; )
			{
				if( table[ a ] == &s[ b ] ) break;
				a++;
			}
			if( (table[ a ] == &s[ b ]) && ( i != a ) ) continue;
			table[ i ] = &(s[ b ]);

		}
//*/
		if( !(iterations % 100) ) printf( "Iterations togo: %i\n", iterations );
	}
	free( table );
}

int	huffstartsort( STREAM *a, STREAM *b )
{
	int		t1, t2;

	t1 = (a->size - a->newsize) * (a->total) - a->size;
	t2 = (b->size - b->newsize) * (b->total) - b->size;

	if( t1 > t2 )
	{
		return( -1 );
	}
	if( t2 > t1 )
	{
		return( 1 );
	}
	return( 0 );
}

typedef	struct	{
	int	len;
	int	data;
	STREAM	*ptr;
}MAPPING;

MAPPING	map[ 1024 ];

int	buildstream( char *to, int maxsize )
{
	int	i, j, dest, index, temp, total;

	size++;

	DEBUGFLOW( "buildstream" );
/* empty map table */
	for( i = 0; i < size; i++) 
		map[ i ].len = 0;
	for( i = 0; i < legal; i++ )
		table[ i ]->used = 0;

/* Precalculate to map-table */
	for( i = 0; i < legal; i++)
	{
		for( j = 0; j < size - table[ i ]->origsize; )
		{
			for( index = 0; index < table[ i ]->origsize; index++ )
			{
				if( !map[ j + index ].len ) continue;
				j += (map[ j + index ].ptr->origsize + index); /* cryptic */
				break;
			}
			if( index < table[ i ]->origsize )
				continue;
			if( !memcmp( &(table[ i ]->orig), &(buffer[j]), table[ i ]->origsize ) )
			{
				map[ j ].len = table[ i ]->newsize;
				map[ j ].data = table[ i ]->data;
				map[ j ].ptr = table[ i ];
				table[ i ]->used++;				/* more... */
				j += table[ i ]->origsize;
			}else
			{
				j++;
			}
		}
#ifdef NOTOK
		printf( "Added: " );
		doprint( table[ i ] );
#endif
	}

#ifdef SANITYCHECKS
	DEBUGFLOW( "Testing..." );		/* ensure map[] sanity */
	for( i = 0; i < size; i++)
	{

		if( !map[ i ].len )
		{
			if( !j )
			{
				printf( "Illegal STREAM!!!\n" );
			}else
				j--;
			continue;
		}

		j += map[ i ].ptr->origsize;
		if( j ) j--;
	}
#endif

	DEBUGFLOW( "Killing useless" );
	for( i = 0; i < legal; i++ )
	{
#ifdef NOTOK
		printf( "Removing? " );
		doprint( table[ i ] );
#endif
		
		if( table[ i ]->origsize == 1 ) continue;	/* don't play with singles */
		if( !(table[ i ]->used) ) continue;
		if( calculateusedptr( table[ i ] ) > 0 ) continue;	/* just ignore "usefull" ones */

#ifdef NOTOK
		printf( "DONE!\n" );
#endif
		table[ i ]->used = 0;
		for( j = 0; j < size; j++ )				/* search any occurance */
		{
			if( map[ j ].ptr != table[ i ] ) continue;	/* not here */

			for( temp = 0; temp < table[ i ]->origsize; temp++ )
			{
/* we should search starting with --origsize until 1 reach when there will be
 * no place for failures 
 */
				map[ j + temp ].ptr = &s[ findmulti( &(buffer[ j + temp ]), 1 ) ];
				if( map[ j + temp ].ptr->origsize != 1 )
				{
					printf( "What a hell is this??? Can't be!!! findmulti() can't fail!!!\n" );
				}
				map[ j + temp ].len = map[ temp + j ].ptr->newsize;
				map[ j + temp ].data = map[ temp + j ].ptr->data;
			}	
	/* we don't need to fix j since loop will "fail" in first if() anyway */
		}
	}
//*/	
#ifdef SANITYCHECKS
	DEBUGFLOW( "Testing..." );		/* ensure map[] sanity */
	for( i = 0; i < size; i++)
	{

		if( !map[ i ].len )
		{
			if( !j )
			{
				printf( "Illegal STREAM!!!\n" );
			}else
				j--;
			continue;
		}

		j += map[ i ].ptr->origsize;
		if( j ) j--;
	}
#endif
	DEBUGFLOW( "cutting & fixing..." );
/* remove something useless */
	index = 0;
	for( i = 0; i < legal; i++ )
	{
		if( table[ i ]->origsize == 1 ) continue;
		if( !(table[ i ]->used) ) continue;

		index++;
	}
/* check if we can do 15-bit mapping */
	if( index <= 15 )
	{
		temp = 0x100;
		for( i = 0; i < legal; i++ )
		{
			if( table[ i ]->origsize == 1 ) continue;
			if( !(table[ i ]->used) ) continue;

			for( index = 0; index < size; index++ )
			{
				if( table[ i ] != map[ index ].ptr ) continue;
				map[ index ].data = temp;
				map[ index ].len = 12;
			}
			table[ i ]->data = temp;			/* WARNING!!! */
			table[ i ]->newsize = 12;			/* WARNING!!! */

/* We can't ITERATE anymore since we change data in s[] table!!! :-( */
			temp += 0x100;

		}
	}

	DEBUGFLOW( "building stream" );
/* build stream */
	dest = 0;
	index = temp = 0;
	total = 0;
	for( i = 0; i < size; i++ )
	{
		if( !map[ i ].len ) continue;
/* use "tweaked" calculation (docom needs) */
		if( map[ i ].len <= 8 )
			total++;
		temp += (map[ i ].data << index);
		index += map[ i ].len;
		while( index >= 8 )
		{
			to[ dest++ ] = temp & 0xff;
			if( dest >= maxsize ) 		/* don't dump core */
				return( 0xffff );
			temp >>= 8;
			index -= 8;
		}
	}
	while( index > 0 )
	{
		to[ dest++ ] = temp & 0xff;
		if( dest >= maxsize ) 
			return( 0xffff );
		temp >>= 8;
		index -= 8;
	}

	DEBUGFLOW( "calculating size" );
/* calculate all used STREAMs */
	temp = index = 0;
	for( i = 0; i < legal; i++ )
	{
		if( table[ i ]->origsize == 1 ) continue;
		if( table[ i ]->used )
		{
			index++;
 			temp += (table[ i ]->size+4+7)/8;	/* add count too then do byte fix */
		}
	}

	critical.bit12 = 0;

	if( index < 15 )
	{
		temp += index;
		critical.bit12 = 1;
	}

	critical.stream = dest;
	critical.single0 = 15;
	critical.single1 = 15;
	critical.multisize = temp;
	critical.multicount = index;
	critical.chars = total;

	printf( "Calc: str: %i; chrs: %i; simp: %i; data: %i; tot: %i\n", dest, total, 15+15, temp, dest+30+temp );

//	printmappings( legal );

/* stream + singles + singles + used STREAMs */

	return( dest + 15 + 15 + temp );

}


void	savestate( char *stream, int ssize, CRIT *crit )
{
	char	data[ 1024 ];
	int		i = 0;

	FILE	*out;
	char	fname[ 32 ];
	int		dest;

	do{
		sprintf( fname, "stream%3i.%i", ssize, i);
		out = fopen( fname, "r" );
		if( out == NULL ) break;
		fclose( out );
	}while( ++i );
	out = fopen( fname, "wb" );
	if( out == NULL )
	{
		printf( "Error!\n" );
		return;
	}
	fwrite( stream, 1, crit->stream, out );
	fclose( out );

	sprintf( fname, "info%3i.%i", ssize, i );
	out = fopen( fname, "wb" );
	if( out == NULL )
	{
		printf( "error\n" );
		return;
	}
	fwrite( crit, sizeof( CRIT ), 1, out );
	fclose( out );


	sprintf( fname, "used%3i.%i", ssize, i );

	dest = 0;

	for( i = 0; i < legal; i++ )
	{
		if( s[ i ].used == 0 ) continue;
		if( s[ i ].origsize <= 1 ) continue;
		data[ dest++ ] = s[ i ].used;
		data[ dest++ ] = (s[ i ].data >> 8) & 0xff;
		data[ dest++ ] = s[ i ].origsize;
		data[ dest++ ] = s[ i ].size;
		memcpy( &(data[ dest ]), &(s[ i ].packed), (s[i].size+7)/8 );
		dest += (s[i].size+7)/8;
	}
	out = fopen( fname, "wb" );
	if( out == NULL )
	{
		printf( "error\n" );
		return;
	}
	fwrite( data, 1, dest, out );
	fclose( out ); 

	printf( "\t%i bytes written!\n", dest );	
}


void	saveucase()
{
	char	data[ 1024 ];
	FILE *out;
	int	i, dest, last;
	
	dest = 0;
	last = 0;

	for( i = 0; i < size; i++ )
	{
		if( (isupper( buffer[ i ] ) )
#ifdef SAVEUCASE
		&& ( buffer[ i ] != SAVEUCASE )
#endif
		)
		{
			data[ dest++ ] = i - last;
			last = i;
		}
	}
	out = fopen( "ucase.lst", "wb" );
	if( out == NULL ){ printf( "error!\n" ); exit( 1 ); }
	fwrite( data, 1, dest, out );
	fclose( out );
	critical.ucases = dest;
}
