; nasmw 
; code mainly that of io_x, translated to English

; 169 bytes

%define   Cols  25
%define   Rows  10
%define   BytesMemory    ((Cols+1)*(Rows+2)*6)
%define   Height         (2*Rows+1)
%define   Onerow         (Cols+1)*3
%define   Tworows        2*Onerow
%define   Topleft        arr+Onerow
pghost equ 02
phouse equ 07Fh
eol equ '$'
 
          org     100h
Start:

;  *******************************************
;  *** zero array, to include border area
;  *******************************************

          mov     di,  arr
          mov     ch,  (BytesMemory>>8)
          rep     stosb     
                  
;  ****************************
;  ***  get and set seed
;  ****************************
         
          mov     si,  05Dh   ; FCB1 is num followed by spaces
 gnpsp:    
          aad
          mov     ah,  al
          lodsb
          sub     al,'0'
          jge     gnpsp          
          mov     bl,  ah              ; set seed in bx
          
;  *******************************************
;  *** setup fullmaze
;  *******************************************

          mov     di,  Topleft  
          mov     si,  Height
          mov     ax,  "+-"
          mov     dx,  "|N"
          push    di                   ; save for print
fillrow:       
          mov     cl,  Cols    
fillcell: 
          stosw
          mov     byte[di],  ah
          inc     di
          loop    fillcell
          stosb                        ; add last corner/wall
          mov word [di],0A0Dh          ; add crlf
          scasw    ; add di,2
          xchg    ax,  dx
          dec     si
          jnz     fillrow              ; each line 
          mov     byte[di],  eol       ; add end print char here
         
          mov     byte[di-Onerow-3],  phouse ; house
          mov    di,  Topleft+Onerow   ; also start pos-1
          mov    al,  pghost
          stosb                        ; and inc to 1st cell
          
;   **************************************
;   *** set random start cell
;   **************************************
;  P(x,y)=start+r*(Cols+1)*6+c*3
 
          mov     cl, Cols
          call    ran
          imul    bp,  dx,  byte  3    ; x*3
          add     di,  bp
          mov     cl, Rows
          call    ran
          imul    bp,  dx,   Tworows   ; y*(Cols+1)*6
          add     di,  bp       ; start cell 
       
;   ******************************
;   *** walk the maze
;   ****************************** 

Markcell:      
          mov     word[di],  "  "      ; mark as visited
          mov     cl,  4
          call   ran                   ; dl=0[Right],1[Down],2[Left],3[Up]
nextdir:
          mov     bp,  3          
          and     dx,  bp   ;  dx was inc'd - could be too much
          test    dl,  1
          jz      .horiz
          mov     bp,  Tworows    
.horiz:                        
          cmp     dl,  1
          jbe     .fwd
          neg     bp
.fwd:                                  ; bp = 3      ,Tworows ,-3     ,-Tworows
          cmp     byte[di+bp],  'N'    ; not visited yet?
          je      removewall
Backdir:       
          inc     dx
          loop    nextdir              ; try next dircn
                                  
          cmp     sp,  0FFFCh          ; done all cells?
          jae     printmaze       
          pop     dx
          pop     di           
          mov     cl,  4               ; no, go back and try again  
          jmp     short  Backdir

removewall:       
          push    di ; save old
          push    dx
          mov     ax,bp                ; save move amount
          sar     bp,1 
          mov     word[di+bp],  "  "   ; delete 'N' and wall, or floor
          add     di,  ax             ; move to this cell
          jmp     short  Markcell
          
printmaze:
;   ******************************
;   *** Print maze
;   ******************************
          pop     dx
          mov     ah,  09h
          int     21h
          ret
          
ran: 
;   ******************************
;   *** Random Number Generator
;   ******************************
          mov     ax,  04e35h
          imul    bx
          inc     ax
          xchg    ax,  bx
          movzx   ax,  bh
          cwd
          idiv    cx
          ret
          
          Section   .bss
arr resb BytesMemory
