;----------------------------------------------------+--+--+--+--+--+--+--+--+
; Hugi Compo #29                                             |  |           |
; Random maze generator                              +--+  +--+  +  +--+  +--+
; by Aphex - september-october 2009                  |                 |     
;----------------------------------------------------+--+--+--+--+--+--+--+--+

                               
; History:
;       Sep. 16         -   189 bytes: first working version 
;       Sep. 17-28      -   163-135 bytes: obvious improvements
;       Oct.  7         -   132 bytes: why use DTA and not FCB 1?
;       Oct. 11         -   128 bytes: 5 bytes memory fill, AAM for modulo
;       Oct. 12         -   127 bytes: 1 byte jump ;)
;       Oct. 15         -   126 bytes: improving move in DFS with CMP/LOOPNZ
;       Oct. 17         -   124 bytes: draw more grids and no memory fill,
;                                      no more 1 byte jump :(
;       Oct. 27         -   122 bytes: jumps instead of calls,
;                                      dummy DOS function
                            
 
; Compile: tasm /m entry
; Link: tlink /t/x entry
                         
; Assumes: AX=0, BH=0, [SP]=0                 


                .386
                cseg    segment para public use16 'code'
                assume  cs:cseg, ds:cseg, es:cseg, ss:cseg
                                                          

                org     100h
start:

                pop     bp                     ;bp=seed=0
                mov     si, 5Dh                ;si->command line
                mov     di, 205Dh              ;di->grids buffer
getdigit:
                imul    bp, 10d
                add     bp, ax                 ;add digit to seed
                lodsb                          ;read char from command line
                sub     al, 30h                ;ASCII to digit
                jnb     getdigit               ;loop for all digits

                xchg    bp, [si]               ;si->seed, bp=2020

                mov     al, 7Ch                ;even rows draw: | and char 0
                mov     dx, 2D2Bh              ;odd rows draw: +-
                                                
gridloop:

                mov     cl, 15h                ;2*rows+1
gridrows:

                pusha                          ;we only care about last push 
                                               ;ah=0, cx=1, di->border cells
                                               ;last DFS loop will do nothing
                 
                xchg    dx, ax                 ;alternative draw
                mov     bl, 1Ah                ;cols+1 (for rightmost wall)

gridcols:
                stosw                          ;draw
                mov     word ptr [di], 242Dh   ;draw -$
                inc     di                     ;prepare for next wall
                dec     bx
                jnz     gridcols               ;loop for cols
                mov     word ptr [di-2], 0A0Dh ;draw \r\n
                loop    gridrows               ;loop for rows

                                               ;grid format:
                                               ;+--+--+--+\r\n
                                               ;|.-|.-|.-|\r\n
                                               ;+--+--+--+\r\n
                                               ;|.-|.-|.-|\r\n
                                               ;+--+--+--+\r\n
                                               ;|.-|.-|.-|\r\n
                                               ;+--+--+--+\r\n$
                                               ;where . stands for char 0

                                               ;width=3*cols+3=4E, 4E*2=9C

                or      [di-51h], al           ;mark exit (7C|2B=7F)

                xchg    dx, ax                 ;prepare for next grid
                                               ;set ax, dx on last loop

                inc     di                     ;skip $ and count
                jns     gridloop               ;draw several grids

                                               ;dx->the real grid
                mov     di, 2D79h              ;di=dx+4E
                aaa                            ;ax=102
                stosb                          ;mark ghost, di++

                                               ;we have di->first cell
                                               ;for initial position
                                               ;we must add X*3+Y*2*4E

                inc     ax                     ;al=3
                jmp     rng
                                                                                  
calccoord:
                xchg    bx, ax                 ;prepare for aam and mul
                                               ;bx=103 or 99C

                aam     19h                    ;modulo cols or rows
                mul     bl                     ;multiply with 3 or 9C
                add     di, ax                 ;adjust position
               
                mov     ax, 0E013h             ;see below
                xor     [bx+3Ch], al           ;changes [13F]=modulo
                                               ;or [9D8]=dummy location

                add     ax, 2989h              ;ax=99C
                org     $-2
dfs:
                mov     [bx+di], bp            ;clear wall
rng:
                                               ;RNG    
                imul    bx, [si], 4E35h        ;*=4E35 (large prime)
                inc     bx                     ;+=1
                mov     [si], bx
                xchg    bl, bh                 ;bl=random number

                inc     cx                     ;add X to pos, cx=1, PF=0
                                               ;add Y to pos, cx=2, PF=0
                jnp     calccoord              ;start DFS, cx=3, PF=1

                                               ;bx is lower than FFFC
                                               ;which means inc bx/jnz
                                               ;loops for all directions
                                               ;often more than once :)

                mov     [di], bp               ;clear cell
nextdir:
                pusha                          ;all on stack but RNG and maze

                and     bx, cx                 ;bx=0,1,2 or 3
                dec     bx                     ;bx=-1,0,1 or 2

                test    bl, dh                 ;dh=2D, ZF if bx=0 or 2
                jnz     nomul                  ;go to move if bx ready

                dec     bx                     ;bx=-1 or 1
                imul    bx, 4Eh                ;bx=-4E or 4E

nomul:
                sub     di, bx                 ;move
                cmp     [di], ch               ;ch=0, ZF if empty cell
                loopne  nomul                  ;loop for max 3 times

                lahf                           ;ah=46 if ZF=PF=1

                mov     cl, 2                  ;cx=2 to continue DFS
                je      dfs                    ;if cell empty then move

back:
                popa

                inc     bx                     ;get next direction
                jnz     nextdir                ;and keep trying...

                int     21h
                                               ;if ah=46 redirect 
                                               ;stdin (0) to stdaux (3)
                                               ;if ah=9 send maze to stdout
                                               ;if ah=0 bye, bye!
 
                jmp     back                   ;move back

                cseg    ends

                end     start
                                                

