;-----------------------------------------------------------------------;
;                                                                       ;
; Entry for HUGI size coding competition #26: The Golden Ratio          ;
; To compile with MASM: ml entry.asm                                    ;
;                                                                       ;
; By Jeff (USA)                                                         ;
;                                                                       ;
;-----------------------------------------------------------------------;
                .model  tiny
		.code
		.386
		.startup

                mov     di, bp          ; di = bp = 09xxh = Our buffer
                mov     ch, 0dh         ; cx > 3436
                inc     ax              ; ax = 1
                rep     stosw           ; init buffer

DigitLoop:
                cwd                     ; dx:ax < 300h at this point
                mov     bl, 100         ; bx = 100, the base we use
                mov     si, 2*3436      ; higher than needed
                mov     [bp+si], si     ; large last number forces rounding
MultLoop:
                xchg    ax, [si+bp]     ; save ax, load [si+bp]
                xchg    di, dx          ; save dx

                mul     bx              ; dx:ax = [si+bp] * 100
                add     ax, [si+bp]     ; dx:ax += old dx:ax
                adc     dx, di

                imul    di, si, 5
                div     di              ; see algorithm for this step
                mov     [si+bp], dx

                dec     si
                mul     si              ; more algorithm optimization

                dec     si
                jnz     MultLoop

                div     bl              ; divide by 100
                add     al, [si+bp]     ; add the old value

                mov     dx, '.1'        ; first time through, print "1."
                mov     byte ptr [si+bp], 3dh   ; adjust for the next 6
                jcxz    dot             ; print first two chars

                mov     [si+bp], ah     ; save remainder

                cmp     cx, 322h        ; base 100 requires adjusting one digit
                jne     noinc
                inc     ax              ; add one to the digit
                sub     [si+bp], bx     ; subtract 100 from the next number
noinc:
                aam                     ; divide by 10
                xchg    al, ah          ; switch order for printing
                add     ax, '00'        ; convert to ASCII
                xchg    dx, ax          ; put in dx for printing
dot:
                mov     ah, 2
                int     21h             ; print first char
                mov     dl, dh
                int     21h             ; print second char

                inc     cx
                cmp     cx, 1201        ; loop through all digits
                jb      DigitLoop
                mov     dx, 0a0dh       ; print CR LF pair last
                jz      dot
                ret                     ; return to DOS

                END
