; Hugi Size Coding Competition #26 - Golden Ratio
; fabled's entry (fabled@iki.fi)

org 100h
section .text

; SI = 0100
; BP = 09xx
; CX = 00FF
; AX = BX = 0000
; DI = SP = FFFE
; DX = CS = DS = ES = SS = xxxx, 0080 <= DX <=9000.

ODD	EQU 1

start:
;	ss			; '6'
;	or	ax, 0240ah	; 0dh, 0ah, '$'

	std
	mov	cx, (0fffeh-stuff)/2+ODD
	mov	al, 10
;	cbw
	rep	stosw		; Initialize the hypergeometric terms
				; to 10. Everything *10 since we start
				; displaying from second digit.
				; This writes also "couple of" extra
				; bytes but leaves DI pointing to 'stuff'.
	xchg	bp, ax		; BP = 10
;	push	si		; Store 100h (addr of end of output string)

digit:
	; [FFFE]:AX is used as carry that overflows from the previous
	; hypergeometric term. During first iteration [FFFE] is 000A
	; as written above (rep stosw) and AX is 09xx. And on consecutive
	; rounds [FFFE] = 0 and AX < 3100. This is actually a good thing -
	; it does not affect the result if we have enough terms (> 3436),
	; and actually results in the rounded value if terms are chosen
	; correctly (= 3436).

	mov	ch, 01bh	; cx = 2* amount of terms to calculate
	mov	si, string+2400+(1-ODD) + 01b00h
				; Point to last term. Basically this can
				; be anything, but we want si to point to
				; last calculated digit after the looping
				; for easy comparison.
%if ODD = 1
	inc	di
%endif

term:
	xchg	ax, bx		; [SP]:BX = Carry from previous term

	lodsw
	mul	bp		; DX:AX = 10*f[k]

	add	ax, bx
	pop	bx		; Get high part of "carry"
	adc	dx, bx		; DX:AX = carry + 10*f[k]

	imul	bx, cx, byte 5	; bx = 10*k
	div	bx		; (carry+f[k]*10) / 10*k

	mov	[si+2], dx	; Remainder back to f[k]

	dec	cx		; CX = 2k-1
	mul	cx		; DX:AX = carry * (2k-1)

	push	dx		; Put carry back (or 0000h for return addr.)
	loop	term

				; AX = Carry = the digit to display
				; due to nature of hypergeometric
				; representation this can actually be
				; something between 0..10, where 10 means
				; '0' but add one carry to the previous digit.
				; This is handled by the AAA below.

	push	di
carry:	aaa			; AL %= 10, AH += 1 if AL > 10
	add	ax, 00930h	; AL = ASCII digit to write
				; AH = 9 (during first loop) for INT 21h below
				; AH.0 = 0 if AAA carried
	sahf			; Store AH.0 to CF
	stosb			; Write new/updated digit
	mov	al, [di]
	inc	ax		; Pre-fetch/pre-increment old digit
	jnc     short carry	; and update it if AAA carried
	pop	di

%if ODD = 0
	inc	di
%endif

	cmp	di, si
%if ODD = 1
	jbe     short digit	; Calculate all digits
%else
	jb	short digit
%endif

;	pop	si		; SI=100
;	movsd			; Copy termination string from beginning
	mov	[di], dword 0240a0d36h

	mov	dx, string
	int	21h		; And dump it to screen
	retn			; All done! Yay!

string	db	"1.5"
stuff	EQU	$-$$+100h
