;-----------------------------------------------------------------------------
; Entry for  Hugi Compo #26 - Golden Ratio  (http://www.hugi.scene.org/compo)
; Compile with: tasm /m
; By  Magne, Norway           (mage2[at]online[dot]no)
;
; 18 May 2006  First version, 85 bytes
; 31 May 2006  removed initial array clearing and int 21,9 calls
;
; Calculates the Golden Ratio (phi) using the continued fraction
;    f = 1/(11+1(11+...) = 1/(11+f)
; and
;    phi = 1.6 + f/5
;
; Multiplying the fractional part by 10 for each digit give:
;
;    void main() {                         /* without rounding */
;       #define decsize 2400
;       char a[decsize+3]; int i, j, q, r, c;
;       printf("1.6");
;       a[1]=2; a[2]=0;
;       for (j=2; j<decsize+1; j++) {
;          q=0; a[j+1]=0;
;          for (i=j; i>0; i--) {           /* 0<=a[i]<=12, 0<=q<=10 */
;             c=a[i]>a[i+1]; q+=a[i]*10-c;
;             r=q%11+c; q=q/11;
;             if (q>a[i+1]) {
;                a[i+1]+=11; a[i+2]++; r--; }
;             a[i+1]-=q; a[i]=r; }
;          printf("%u",q); } }
;
; Removes the multiplication in the assembly code  (a*10/11 = a - a/11)
;-----------------------------------------------------------------------------

        .486
cseg    segment dword public use16 'code'
        assume  cs:cseg, ds:cseg, es:cseg, ss:cseg

DecSize equ     2400  ; no of digits after the decimal point
RndSize equ     2296  ; last pos that gives a digit = floor(DecSize/log(11+f))

        org     100h
Start:
        std
        lea     si, [txt+7]    ; text includes the rounded last digit
        mov     cx, DecSize+1  ; no of all digits + decimal point

NextC:                         ; for  all chars  do
        lodsb                  ; al:= next char
        test    al, al
        js      Exit
        jnz     WriteC         ; calculate next digit if al = 0
        inc     si

NextD:                         ; for  decimal digit 2 to DecSize  do
        lea     di, [a+DecSize]
        sub     di, cx
        stosb                  ; a[j+1]:= 0

NextAI:                        ; for  a[j] ... a[1]  do
                               ;   invariant:  0<=a[i]<=12, 0<=q<=10
        mov     dl, [di]       ; dl = new q:= a[i],  al = previous q
        inc     di
        cmp     [di], dl       ; cf:= q > a[i+1]
        lahf                   ; save carry flag
        sbb     al, dl         ; al = r:= previous q - a[i] - cf

ChkR:   jae     ChkBorrow      ; while  r < 0  do
AddR:   dec     dx             ; q:= q - 1, q >= 0, max two times in this loop
        add     al, 0Bh        ; r:= r + 11
        jl      AddR           ; end - while  r < 0

ChkBorrow:
        sahf                   ; r:= r + cf   (cf = a[i] > a[i+1])
        adc     al, 0
        sub     [di], dl       ; a[i+1]:= a[i+1] - q
        jae     NoBorrow       ; if q <= a[i+1] then  NoBorrow

Borrow: dec     ax             ; r:= r - 1
        add     [di], word ptr 000Bh ; a[i+1]:= a[i+1]+11,  a[i+2]:= a[i+2]+1

NoBorrow:
        dec     di
        stosb                  ; a[i]:= r
        xchg    ax, dx         ; al:= previous q
        cmp     di, offset a-1
        jne     NextAI         ; end - for a[j]...a[1]

        add     al, '0'        ; write digit
                               ; end - for decimal digit 2 to DecSize

WriteC: xchg    dx, ax         ; write char
        mov     ah, 2
        int     21h
        loopnz    NextC        ; end - for all chars

        dec     si
        jmp     NextC

Exit:   int     20h            ; end - program

;-----------------------------------------------------------------------------

txt:    db      0FFh,0Ah,0Dh,'6',0,'6.1'

a       db      2, 0           ; start with 2
        db      decsize+1 dup (?)

cseg    ends
        end     Start
