	page	240, 132
;ENTRY.ASM		Boreal
;Display the Golden Ratio (phi) accurate to 2400 places after the decimal point
; phi = (sqrt(5)+1)/2 = 1.618033989...
;Assemble with:
; tasm /m entry
; tlink /t entry

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

siz	equ	3433		;size of the array

	org	100h
start:	push	9		;last location gets a 9 (to make rounding right)
	mov	cx, siz-3	;fill rest of Array with 1's
phi05:	push	1
	loop	phi05
	push	6		;second location gets a 6
	push	cx		;first location doesn't matter
	mov	di, sp		;point to Array
;Array now looks like: [0, 6, 1, 1, 1, 1, ... 9]
;(cx=0)
	push	cx		;push return address

; ax = scratch
; bx = I, Array index
; cx = N (iteration counter)
; dx = mul, div
; si = T low word
; di = Array
; bp = T high word

phi10:	mov	bx, 2*(siz-1)	;I:= siz-1; *2 to index words instead of bytes
;(ah<80h)
	cwd			;T:= 0 (low word need not be initialized)
phi20:	mov	bp, dx		;T:= dx:ax (see below)
	mov	ax, 1000	;T + Array(I)*1000
n1000:	mul	word ptr [bx+di] ;dx:ax:= ax*[bx+di]; 32-bit product
	add	ax, si		;+ low word
	adc	dx, bp		;+ high word

	imul	si, bx, 5	;/(I*10)
	div	si		;ax(q):dx(r):= dx:ax/si
	mov	[bx+di], dx	;Array(I):= remainder

	dec	bx		;I-1; (bx is already *2)
	mul	bx		;* (2*I-1); dx:ax:= ax*bx
	mov	si, ax		;T:= dx:ax

	dec	bx		;I--
	jne	phi20		;loop until I = 0

;(dx:ax = T)			;T:= T/1000 + Array(0)
	div	word ptr [n1000-2] ;ax(q):dx(r):= dx:ax/1000
	add	ax, [di]
	mov	[di], dx	;Array(0):= rem(0)

	mov	dx, offset str1	;output "1."
	jcxz	phi50		;skip if first pass (cx=0)

;Convert value in ax to a 3-digit ASCII string 
	mov	si, dx		;point to string
;(bh=0)
	mov	bl, 2		;set index to end of string
phi40:	div	byte ptr [si+5]	;al:= ax/10; ah=rem
	add	ah, '0'		;convert remainder to ASCII
	mov	[bx+si], ah	;store it into string
;(al<100)
	cbw			;ah:= 0; get ready for next divide
	dec	bx		;move index to next higher digit
	jns	phi40		;loop for 3 digits
phi50:
	call	outStr		;output string pointed to by dx

	inc	cx		;loop for 2400 places after decimal point
	cmp	cx, 801
	jne	phi10

;(dx=str1)
	mov	dl, low offset str2 ;output CR+LF
outStr:	mov	ah, 9		;output string to stdout
	int	21h
	ret

str1	db	'1.$$'		;initial string; gets overwritten by 3 digits
str2	db	0Dh, 0Ah, '$'	;CR, LF; contains 10 for div instruction

cseg	ends
	end	start
