	page	240, 132
;EXAMPLE.ASM	8-Apr-2006
;Example program for Hugi Compo #26
;Display the Golden Ratio (phi) accurate to 2400 places after the decimal point
;Assemble with:
; tasm /m example
; tlink /t example

	.486
cseg	segment dword public use16 'code'
	assume	cs:cseg, ds:cseg, es:cseg, ss:cseg

siz	equ	3433		;size of the array

	org	100h
start:
	mov	cx, 801		;calculate 800*3 digits after the decimal point
phi10:	test	cx, cx
	jne	phi15
	 jmp	phi90
phi15:	mov	bx, siz-1	;J:= siz-1			bx = J
phi20:	test	bx, bx		;while J > 0 do...
	jbe	phi30		;for each element in array (except the first)...

	xor	eax, eax
	shl	bx, 1		;index words (instead of bytes)
	mov	ax, [bx+array]	;temp:= temp + array(J)*1000
	shr	bx, 1
	imul	eax, 1000
	add	temp, eax

	xor	ebp, ebp
	imul	bp, bx, 10	;array(J):= rem(temp/(J*10))
	mov	eax, temp
	xor	edx, edx
	div	ebp		;eax(q):edx(r):= edx:eax/ebp
	shl	bx, 1		;index words (instead of bytes)
	mov	[bx+array], dx	;remainder
	shr	bx, 1

	xor	ebp, ebp
	imul	bp, bx, 10	;temp:= temp/(J*10) * (2*J-1)
	mov	eax, temp
	xor	edx, edx
	div	ebp		;eax(q):edx(r):= edx:eax/ebp
	mov	temp, eax
	xor	eax, eax
	imul	ax, bx, 2
	sub	ax, 1
	imul	eax, temp
	mov	temp, eax

	dec	bx		;J--
	jmp	phi20		;end of 'while' loop
phi30:
        ;printf("%.3d", array[0] + temp / 1000)

	cmp	first,0		;first time here?
	je	phi40		;jump if not
	mov	first, 0	;clear 'first' flag
	mov	ah, 2		;output '1.'
	mov	dl, '1'
	int	21h
	mov	dl, '.'
	int	21h
	jmp	phi50
phi40:
	mov	eax, temp	;numOut:= array(0) + temp/1000
	xor	edx, edx
	mov	ebp, 1000
	div	ebp		;eax(q):edx(r):= edx:eax/ebp
	add	ax, [array+0]
	call	numOut
phi50:
	mov	eax, temp	;array(0):= rem(temp / 1000)
	xor	edx, edx
	mov	ebp, 1000
	div	ebp		;eax(q):edx(r):= edx:eax/ebp
	mov	[array+0], dx

	dec	cx
	jmp	phi10
phi90:
	mov	dl, 0Dh		;output carriage return
	mov	ah, 2
	int	21h
	mov	dl, 0Ah		;output line feed
	int	21h

	int	20h		;terminate program

;-------------------------------------------------------------------------------
;Output the value in ax as a 3-digit decimal number with leading zeros

numOut:	push	ax		;preserve registers
	push	dx
	push	bp

	mov	dx, 0		;ax:= rem(ax/100)
	mov	bp, 100
	div	bp		;ax(q):dx(r):= dx:ax/bp
	add	al, '0'		;convert to ASCII
	push	dx		;save remainder
	mov	dl, al		;output character
	mov	ah, 2
	int	21h
	pop	dx		;get remainder
	mov	ax, dx

	mov	dx, 0		;ax:= rem(ax/10)
	mov	bp, 10
	div	bp		;ax(q):dx(r):= dx:ax/bp
	add	al, '0'		;convert to ASCII
	push	dx		;save remainder
	mov	dl, al		;output character
	mov	ah, 2
	int	21h
	pop	dx		;get remainder

	add	dl, '0'		;convert to ASCII
	int	21h

	pop	bp		;restore registers
	pop	dx
	pop	ax
	ret


array	dw	1, 6		;start with '1.6'
	dw	siz-3 dup (1)
	dw	9		;make last digit round properly (from 5 to 6)
temp	dd	0		;initialize with 0
first	db	1		;flag to force output of '1.' on the first pass

cseg	ends
	end	start
