; Convert 320*200*256 BMP picture to turtle commands
; for HC24 - A Turtle Drawing Machine
;
; Uses only turtle commands:
;   2 - move down
;   5 - move to coords
;   6 - pen on
;   8 - change color
;   9 - pause
;
; Compile with fasm v1.56+
;
; Version history:
;   363 - 13.Aug.2005 by ATV, Finland   email: askovuori[at]hotmail.com

use16
org 100h				;assume: cld,ds=es=cs

main:
	mov	dx,msgBMPFileName
	mov	ah,09h
	int	21h
	mov	dx,keyBuf
	mov	ah,0Ah			;get file name from console
	int	21h
	inc	dx
	inc	dx
	mov	bx,dx
	add	bl,[bx-1]
	mov	ax,3D00h		;open file
	mov	[bx],al 		;Z-terminate string
	int	21h
	jc	the_end			;if error, exit program
	mov	[fileBMPHandle],ax

	call	check_BMP
	jc	close_BMP

	mov	dx,msgTurtleFileName
	mov	ah,09h
	int	21h
	mov	dx,keyBuf
	mov	ah,0Ah			;get file name from console
	int	21h
	inc	dx
	inc	dx
	mov	bx,dx
	add	bl,[bx-1]
	xor	cx,cx
	mov	ax,3C00h		;create file
	mov	[bx],al 		;Z-terminate string
	int	21h
	jc	close_BMP		;if error, exit program
	mov	[fileTurtleHandle],ax

	call	convert_file

	mov	bx,[fileTurtleHandle]
	mov	ah,3Eh			;close file
	int	21h

close_BMP:
	mov	bx,[fileBMPHandle]
	mov	ah,3Eh			;close file
	int	21h

the_end:
	int	20h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
check_BMP:
	mov	bx,[fileBMPHandle]
	mov	cx,0054h
	mov	dx,buffer
	mov	ah,3Fh			;read file
	int	21h
	cmp	word [buffer+00h],4D42h	;is it BMP file?
	jnz	bmp_error
	mov	si,word [buffer+12h]	;picture width
	mov	bp,word [buffer+16h]	;picture depth
	cmp	si,320
	ja	bmp_error
	cmp	bp,200
	ja	bmp_error
	cmp	word [buffer+1Ch],8	;bits per pixel
	jnz	bmp_error
	mov	dx,1078
	mov	cx,0
	mov	ax,4200h
	int	21h
	jc	bmp_error
	mov	bx,[fileBMPHandle]
	mov	cx,64000
	mov	dx,BMPpicture
	mov	ah,3Fh			;read file
	int	21h
	cmp	ax,64000
	jb	bmp_error
	clc
	ret
bmp_error:
	stc
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
convert_file:
	mov	di,buffer
	mov	al,06h
	stosb
	xor	bx,bx
new_col:
	xor	bp,bp
	mov	al,05h
	stosb
	mov	ax,bx
	stosw
	mov	ax,bp
	stosw
	xor	cx,cx			;ch=used color , cl=counter
new_row:
	call	get_pixel
	test	cl,cl
	jz	new_pixel
	cmp	al,ch
	jz	same_color
	xchg	al,ch
	mov	ah,al
	mov	al,08h
	stosw
	mov	al,02h
	mov	ah,cl
	stosw
	mov	cl,1
	jmp	next_pixel
new_pixel:
	mov	ch,al
same_color:
	inc	cl
next_pixel:
	inc	bp
	cmp	bp,200
	jb	new_row
	test	cl,cl
	jz	flush
	mov	ah,al
	mov	al,08h
	stosw
	mov	al,02h
	mov	ah,cl
	stosw
flush:
	cmp	bx,319
	jnz	not_last_col
	mov	al,09h
	stosb
not_last_col:
	push	bx
	mov	cx,di
	mov	di,buffer
	sub	cx,di
	mov	bx,[fileTurtleHandle]
	mov	dx,di
	mov	ah,40h			;write file
	int	21h
	pop	bx
	inc	bx
	cmp	bx,320
	jb	new_col
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_pixel:
	mov	si,199
	sub	si,bp
	imul	si,si,320
	mov	al,[bx+si+BMPpicture]
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
msgBMPFileName		db "Enter BMP file name: $"
msgTurtleFileName	db 0Dh,0Ah,"Enter dest. turtle file name: $"
fileBMPHandle		dw ?
fileTurtleHandle	dw ?

keyBuf			db 20h,0
			rb 20h
buffer			rb 0200h
BMPpicture		rb 64000
