.model tiny
.code
.486

	org	100h

;assume ax=0000, bx=0000, cx = 00FF, si = 0100, di=FFFE, bp=09xx

start:
;------------------------------------------------------------
; Set screen mode
; assume that bx not changed after both int 10h
;------------------------------------------------------------
	mov	al, 01h		;set 40x25 screen and clear it, ah=0
	int	10h

	mov	ah, 01h		;turn off the annoying flashing cursor
	mov	ch, 20h
	int	10h

;------------------------------------------------------------
; Draw grid
;------------------------------------------------------------
	mov	ax,54			;bar 115 symbols
grid_loop:
	push	ax
	aam	11			;ah=Y al=X
	mov	bp,ax
	or	ax,0FE7Ch
	add	ax,(1C2h-1FCh)*80h+1	;(offset GridTbl-1FCh)*80h+1
	shr	ax,7			;GridTbl + (ah&1)*2 + ((al==3)1:0)
	xchg	bp,ax
	call	print_one
	pop	ax
	dec	ax
	jne	short grid_loop

;------------------------------------------------------------
; Game loop
;------------------------------------------------------------
	mov	si,03FEh	;Omask
	or	di,si		;Xmask	di has sign bit for AI
game_loop:
	call	get_key

	mov	bp,offset strX

	sub	al,'0'		;check key
	je	short pass_move
	cmp	al,9
	ja	short game_loop
				;ax=1..9
	bt	si,ax		;check busy field
	jnc	short game_loop
	btr	di,ax		;check and set X
	jnc	short game_loop

	call	put_symbol	;bp=strX

pass_move:
	inc	bp

	call	play
	jnc	short adraw

	pushf
	call	put_symbol	;bp=strO
	popf
	jz	short finita

	test	si,di		;check all field busy
	jne	short game_loop	;ah=0 after call put_symbol

adraw:	add	bp,bx		;bx=7 after call put_symbol
finita:	mov	dx,1411h
	call	print

	push	offset start
				;ah=0 after call print
;------------------------------------------------------------
; Wait key and check for exit
;------------------------------------------------------------
get_key:			;ah=0 for all cases
	int	16h		;assume al<80h
	dec	ah		;ah=1 for ESC
	jne	short mret	;ah=0 and retn

	mov	al,03h		;ax=0003 clear screen & restore flashing cursor
	pop	dx		;pass one address
	jmp	short int10

;------------------------------------------------------------
; Stupid AI 
; return move in ax and flags c=0 - A draw, z=1 - O wins
; assume bh=0, ah=0
; change only dx
;------------------------------------------------------------
play:	cwd			;dx=0
	mov	al,9		;ah=0
playl:	
	bt	di,ax		;check busy field
	jnc	short playn
	btr	si,ax		;check and set O
	jnc	short playn

	pusha
				;check that O wins
	mov	bl,10
	db	0D6h		;salc 0FFh->al
check_loop:
	dec	bx
	je	short poparet	;z=1 - win, o=0, s=0, (c=1 in poparet)
	bt	si,bx
	jnc	short check_loop
	and	al,byte ptr WinTbl[bx-1]
	jne	short check_loop

	xchg	si,di		;now swap players
	call	play
	jl	short poparet0	;sf!=of, z=0 - normal move, c=0 (c=1 in poparet0)
				;jmp only after full loop (retn in play)
	popa
	dec	dx		;may lose 
	bts	si,ax		;restore bit

playn:	dec	ax
	jne	short playl
	or	dx,si		;s=0 or 1, o=0, c=0, z=0
				;s=1 for O moves only if lose, for X moves if draw too
	retn			;c=0 - a draw (or lose)

;------------------------------------------------------------
; Put one or many symbols 
; assume bh=0
; not change bp,si,di, after call ax=1,bx=7
;------------------------------------------------------------
put_symbol:			;ax=1..9
	add	al,2		;ax=3..11
	aam	3		;al=X ah=Y+1
	add	ax,ax
	add	al,al
	xor	ax,601h
print_one:
	add	ax,10*100h+15	;X0=15, Y0=10
	xchg	ax,dx
	mov	bl,1
print:
	mov	cx,bx
	mov	ax,1301h	;display string
	mov	bl,07h		;normal white on black
int10:
	pusha
	int	10h
poparet0:
	inc	ax		;ah=0 => o=0, s=0, z=0
poparet:
	popa
mret:
	cbw			;ah=0
WinTbl:	;db	0B9h,0aFh,01Fh,0F5h,0C3h,077h,0DCh,0EEh,07Ah
	mov	cx,1FAFh
	cmc			;c=1
	retn
	db	077h,0DCh,0EEh,07Ah
        
;------------------------------------------------------------
; Symbols
;------------------------------------------------------------
GridTbl	db	020h,0b3h,0c4h,0c5h
strX	db	'X'
strO:
strWin	db	'O wins!'
strDraw	db	"A draw!"

	end	start
